package org.eclipse.birt.report.engine.emitter.excel.chart;

import org.eclipse.birt.chart.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.datafeed.GanttEntry;
import org.eclipse.birt.chart.datafeed.StockEntry;


public class DataHelperFactory
{
	public static DataHelper createDataHelper(Object val)
	{
		if ( val == null )
		{
			return null;
		}
		
		if(val instanceof Object[])
		{
			Object[] value = (Object[]) val;
			
			if(value[0] instanceof GanttEntry)
			{
				return new GattDataHelper();
			}
			else if(value[0] instanceof DifferenceEntry)
			{
				return new DifferenceDataHelper();
			}
			else if(value[0] instanceof StockEntry)
			{
				return new StockDataHelper(); 
			}
			else 
			{
				return new SingleDataHelper();
			}	
		}
		
		return null;
	}
}
