
package org.eclipse.birt.report.engine.emitter.excel.chart;

import org.eclipse.birt.chart.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.report.engine.emitter.excel.Data;

public class DifferenceDataHelper extends AbstractDataHelper
{
	public String[] getColumnHeader( String title, Series series )
	{
		return new String[]{"Positive", "Negative"};
	}	

	protected int getWidth( )
	{
		return 2;
	}

	protected void setValueToColumn( TableDataSet[] cols, int pos )
	{
		cols[0].addCell( AbstractDataHelper.createData( entries[pos]
				.getPositiveValue( )
				+ "", Data.NUMBER ) );
		cols[1].addCell( AbstractDataHelper.createData( entries[pos]
				.getNegativeValue( )
				+ "", Data.NUMBER ) );
	}

	public boolean analyseData( Object value )
	{
		if ( super.analyseData( value ) )
		{
			Object[] val = (Object[]) value;
			entries = new DifferenceEntry[val.length];
			
			for(int i = 0; i < val.length; i++)
			{
				entries[i] = (DifferenceEntry) val[i]; 
			}	

			return true;
		}

		return false;
	}

	private DifferenceEntry[] entries = null;

}
