
package org.eclipse.birt.report.engine.emitter.excel.chart;

import org.eclipse.birt.chart.datafeed.GanttEntry;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.report.engine.emitter.excel.Data;

public class GattDataHelper extends AbstractDataHelper
{

	protected int getWidth( )
	{
		return 3;
	}

	protected void setValueToColumn( TableDataSet[] cols, int pos )
	{
		cols[0].addCell( AbstractDataHelper.createData(
				gantts[pos].getStart( ), Data.DATE ) );

		cols[1].addCell( AbstractDataHelper.createData( gantts[pos].getEnd( ),
				Data.DATE ) );

		cols[2].addCell( AbstractDataHelper.createData(
				gantts[pos].getLabel( ), Data.STRING ) );
	}

	public String[] getColumnHeader( String title, Series series )
	{
		return new String[]{"Start Date", "End Date", "Docoration Label"};
	}

	public boolean analyseData( Object value )
	{
		if ( super.analyseData( value ) )
		{

			Object[] val = (Object[]) value;
			gantts = new GanttEntry[val.length];

			for ( int i = 0; i < val.length; i++ )
			{
				gantts[i] = (GanttEntry) val[i];
			}

			return true;

		}
		return false;
	}
    
	
	private GanttEntry[] gantts = null;
}
