
package org.eclipse.birt.report.engine.emitter.excel.chart;

import java.util.Calendar;
import java.util.Date;

import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;

public class SingleDataHelper extends AbstractDataHelper
{

	protected int getWidth( )
	{
		return 1;
	}

	protected void setValueToColumn( TableDataSet[] cols, int pos )
	{
		Object value = entries[pos];

		//TableCell cell = null;
         Data cell = null;
		if ( value != null )
		{
			int type=ExcelUtil.getType(value);
			if(type==SheetData.NUMBER )
			{
			   cell = AbstractDataHelper.createData(value, Data.NUMBER);	
			}
			else if(type==SheetData.CALENDAR )
			{
			   cell = AbstractDataHelper.createData(((Calendar)value).getTime( ), Data.DATE);	
			}
			else if(type==Data.CDATETIME)
			{
			   cell = AbstractDataHelper.createData(((CDateTime)value).getTime(),  Data.DATE);
			}
			else
			{
		       cell = AbstractDataHelper.createData(value, Data.STRING);
			}
			
			/*if ( value instanceof Double )
			{
				Double val = (Double) value;
				cell = new TableCell( TableGen.STRING, val.toString( ) );
			}
			else if ( value instanceof Calendar )
			{
				Calendar val = (Calendar) value;
				cell = new TableCell( TableGen.DATETIME, val.toString( ) );
			}
			else if ( value instanceof String )
			{
				String val = (String) value;
				cell = new TableCell( TableGen.DATETIME, val );
			}
			else if (value instanceof CDateTime)
			{
				Date da = ((CDateTime)value).getTime();
				String a = da.toString();
				a = a;
			}
			else
			{
				cell = new TableCell( TableGen.STRING, value.toString( ) );
			}
			*/
		}
		
		cols[0].addCell( cell );
	}

	public boolean analyseData( Object value )
	{
		if ( super.analyseData( value ) )
		{
			if ( value instanceof Object[] )
			{
				entries = (Object[]) value;
				return true;
			}
		}

		return false;
	}

	public String[] getColumnHeader( String title, Series series )
	{
		if ( title != null && !"".equalsIgnoreCase( title ) )
		{
			return new String[]{title};
		}

		if ( series.getDataDefinition( ) != null )
		{
			return new String[]{( (Query) series.getDataDefinition( ).get( 0 ) )
					.getDefinition( )};
		}
		else
		{
			return new String[]{""};
		}
	}

	private Object[] entries = null;
}
