package org.eclipse.birt.report.engine.emitter.excel.chart;

import org.eclipse.birt.chart.datafeed.StockEntry;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.SheetData;

public class StockDataHelper extends AbstractDataHelper
{
	protected int getWidth( )
	{		
		return 4;
	}

	protected void setValueToColumn( TableDataSet[] cols, int pos )
	{		
		cols[0].addCell( AbstractDataHelper.createData( entries[pos].getHigh( )
				+ "", SheetData.NUMBER ) );
		cols[1].addCell( AbstractDataHelper.createData( entries[pos].getLow( )
				+ "", Data.NUMBER ) );
		cols[2].addCell( AbstractDataHelper.createData( entries[pos].getOpen( )
				+ "", Data.NUMBER ) );
		cols[3].addCell( AbstractDataHelper.createData( entries[pos].getClose( )
				+ "", Data.NUMBER ) );
	}

	public boolean analyseData( Object value )
	{
		if(super.analyseData( value ))
		{
			Object[] val = (Object[]) value;
			entries = new StockEntry[val.length];
			
			for(int i = 0; i < val.length; i++)
			{
				entries[i] = (StockEntry) val[i]; 
			}
			
			return true;
		}	
		return false;
	}

	public String[] getColumnHeader( String title, Series series )
	{
		return new String[]{"High", "Low", "Open", "Close"};
	}
	
	private StockEntry[] entries = null;
}
