
package org.eclipse.birt.report.engine.emitter.excel.layout;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;

public class PageDef
{
	int width, contentwidth;
	int topmargin, bottommargin, leftmargin, rightmargin;
	int height, footerheight, headerheight;
	IStyle style;

	public PageDef( SimpleMasterPageDesign page, IStyle style )
	{
		parsePage( page );
		this.style = style;
	}

	private void parsePage( SimpleMasterPageDesign page)
	{
		this.width = ExcelUtil.covertDimensionType( page.getPageWidth( ), 0 );
		this.leftmargin = ExcelUtil.covertDimensionType( page.getLeftMargin( ),
				width );
		this.rightmargin = ExcelUtil.covertDimensionType(
				page.getRightMargin( ), width );
		this.contentwidth = width - leftmargin - rightmargin;

		this.height = ExcelUtil.covertDimensionType( page.getPageHeight( ), 0 );
		this.headerheight = ExcelUtil.covertDimensionType( page
				.getHeaderHeight( ), height );
		this.footerheight = ExcelUtil.covertDimensionType( page
				.getFooterHeight( ), height );

		this.topmargin = ExcelUtil.covertDimensionType(
				page.getTopMargin( ), height );
		this.bottommargin = ExcelUtil.covertDimensionType(
				page.getBottomMargin( ), height );
		//TODO calculate the orientation
	}	
}
