package org.eclipse.birt.report.engine.emitter.excel.layout;


public interface TableInfo
{
	public int getColumnCount();
	
	public int getColumnWidth(int index);
	
	public int getTableWidth();

	public int[] getColumns( );
}

class DefaultTableInfo implements TableInfo
{
	// Each column width
	private int[] columns;
	// the total table width
	private int width;
	
	public DefaultTableInfo(int colcount, int width)
	{
		columns = new int[colcount];
		int per = (int) width / colcount;
		
		for(int i = 0; i < columns.length - 1; i++)
		{
			columns[i] = per;
		}
		
		columns[colcount - 1] = width - (per * (colcount - 1));		
	}
	
	public DefaultTableInfo(int[] columns)
	{
		this.columns = columns;
		
		for(int i = 0; i < columns.length; i++) 
		{
			width += columns[i];
		}	
	}

	public int getColumnCount( )
	{
		return columns.length;
	}

	public int getColumnWidth( int index )
	{
		return columns[index];
	}	
	
	public int getTableWidth() 
	{
		return width;
	}

	public int[] getColumns( )
	{
		return columns;
	}
}
