/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class EngineLoggerHandler extends Handler
{

	static private ThreadLocal threadLogger = new ThreadLocal( );

	private Logger sharedLogger;

	private Logger rootLogger;

	public static void setLogger( Logger logger )
	{
		threadLogger.set( logger );
	}

	public EngineLoggerHandler( Logger rootLogger )
	{
		this.rootLogger = rootLogger;
	}

	public void setSharedLogger( Logger logger )
	{
		sharedLogger = logger;
	}

	public void close( ) throws SecurityException
	{
	}

	public void flush( )
	{
		Logger logger = (Logger) threadLogger.get( );
		if ( logger == null )
		{
			logger = sharedLogger;
		}
		if ( logger == null )
		{
			logger = rootLogger.getParent( );
		}
		while ( logger != null )
		{
			Handler[] handles = logger.getHandlers( );
			if ( handles != null )
			{
				for ( int i = 0; i < handles.length; i++ )
				{
					handles[i].flush( );
				}
			}
			if ( !logger.getUseParentHandlers( ) )
			{
				break;
			}
			logger = logger.getParent( );
		}
	}

	public void publish( LogRecord record )
	{
		Logger logger = (Logger) threadLogger.get( );
		if ( logger == null )
		{
			logger = sharedLogger;
		}
		if ( logger == null )
		{
			logger = rootLogger.getParent( );
		}
		while ( logger != null )
		{
			Handler[] handles = logger.getHandlers( );
			if ( handles != null )
			{
				for ( int i = 0; i < handles.length; i++ )
				{
					handles[i].publish( record );
				}
			}
			if ( !logger.getUseParentHandlers( ) )
			{
				break;
			}
			logger = logger.getParent( );
		}
	}
}
