/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.util.ChartUtil;

public class ChartUtilTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testIsColorTransparent() {
        ChartUtilTest.assertFalse((boolean)ChartUtil.isColorTransparent((ColorDefinition)ColorDefinitionImpl.BLUE()));
        ChartUtilTest.assertTrue((boolean)ChartUtil.isColorTransparent((ColorDefinition)ColorDefinitionImpl.TRANSPARENT()));
    }

    public void testIsShadowDefined() {
        Label label = LabelImpl.create();
        ChartUtilTest.assertFalse((boolean)ChartUtil.isShadowDefined((Label)label));
        label.setShadowColor(ColorDefinitionImpl.BLACK());
        ChartUtilTest.assertTrue((boolean)ChartUtil.isShadowDefined((Label)label));
    }

    public void testMathGT() {
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathGT((double)1.000000001, (double)1.0));
        ChartUtilTest.assertFalse((boolean)ChartUtil.mathGT((double)1.00000000001, (double)1.0));
    }

    public void testMathLT() {
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathLT((double)1.0, (double)1.000000001));
        ChartUtilTest.assertFalse((boolean)ChartUtil.mathLT((double)1.0, (double)1.00000000001));
    }

    public void testMathEqual() {
        ChartUtilTest.assertFalse((boolean)ChartUtil.mathEqual((double)1.000000001, (double)1.0));
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathEqual((double)1.00000000001, (double)1.0));
        ChartUtilTest.assertTrue((boolean)ChartUtil.mathEqual((double)1.0, (double)1.00000000001));
    }

    public void testGetQuadrant() {
        ChartUtilTest.assertEquals((int)-1, (int)ChartUtil.getQuadrant((double)0.0));
        ChartUtilTest.assertEquals((int)-2, (int)ChartUtil.getQuadrant((double)90.0));
        ChartUtilTest.assertEquals((int)-3, (int)ChartUtil.getQuadrant((double)180.0));
        ChartUtilTest.assertEquals((int)-4, (int)ChartUtil.getQuadrant((double)270.0));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.getQuadrant((double)45.0));
        ChartUtilTest.assertEquals((int)2, (int)ChartUtil.getQuadrant((double)-200.0));
        ChartUtilTest.assertEquals((int)3, (int)ChartUtil.getQuadrant((double)-100.0));
        ChartUtilTest.assertEquals((int)4, (int)ChartUtil.getQuadrant((double)-45.0));
    }

    public void testIsBinding() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isBinding((String)"data[\"ab c\"]", (boolean)false));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isBinding((String)"data[\"data\"]", (boolean)false));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isBinding((String)"data[\"ab c\"]+100", (boolean)false));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isBinding((String)"data[\"ab c\"]+100", (boolean)true));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isBinding((String)"100+data[\"ab c\"]", (boolean)true));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isBinding((String)"data[\"ab c\"]+data[\"data\"]", (boolean)true));
    }

    public void testGetBindingName() {
        ChartUtilTest.assertEquals((String)"ab c", (String)ChartXTabUtil.getBindingName((String)"data[\"ab c\"]", (boolean)false));
        ChartUtilTest.assertEquals((String)"data", (String)ChartXTabUtil.getBindingName((String)"data[\"data\"]", (boolean)false));
        ChartUtilTest.assertEquals(null, (String)ChartXTabUtil.getBindingName((String)"data[\"data\"] + 100", (boolean)false));
        ChartUtilTest.assertEquals((String)"ab c", (String)ChartXTabUtil.getBindingName((String)"data[\"ab c\"]", (boolean)true));
        ChartUtilTest.assertEquals((String)"ab c", (String)ChartXTabUtil.getBindingName((String)"data[\"ab c\"] + 100", (boolean)true));
        ChartUtilTest.assertEquals((String)"ab c", (String)ChartXTabUtil.getBindingName((String)"100 * data[\"ab c\"] ", (boolean)true));
        ChartUtilTest.assertEquals((String)"123", (String)ChartXTabUtil.getBindingName((String)"data[\"123\"] + data[\"ab c\"] ", (boolean)true));
        ChartUtilTest.assertEquals((String)"123", (String)ChartXTabUtil.getBindingName((String)"data[\"12\"+\"3\"] ", (boolean)true));
    }

    public void testGetBindingNameList() {
        List names = ChartXTabUtil.getBindingNameList((String)"data[\"123\"] + data[\"ab c\"]");
        ChartUtilTest.assertEquals((int)2, (int)names.size());
        ChartUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        ChartUtilTest.assertEquals((String)"ab c", (String)((String)names.get(1)));
        names = ChartXTabUtil.getBindingNameList((String)"123");
        ChartUtilTest.assertEquals((int)0, (int)names.size());
        names = ChartXTabUtil.getBindingNameList((String)"data[\"123\"]");
        ChartUtilTest.assertEquals((int)1, (int)names.size());
        ChartUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        names = ChartXTabUtil.getBindingNameList((String)"data[\"123\"] + 100");
        ChartUtilTest.assertEquals((int)1, (int)names.size());
        ChartUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        names = ChartXTabUtil.getBindingNameList((String)"data[\"123\"] + data[\"ab c\"] + data[\"a\"]");
        ChartUtilTest.assertEquals((int)3, (int)names.size());
        ChartUtilTest.assertEquals((String)"123", (String)((String)names.get(0)));
        ChartUtilTest.assertEquals((String)"ab c", (String)((String)names.get(1)));
        ChartUtilTest.assertEquals((String)"a", (String)((String)names.get(2)));
    }

    public void testIsDimensionExpresion() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isDimensionExpresion((String)"dimension[\"abc\"][\"12 3\"]"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isDimensionExpresion((String)"dimension[\"a\"+\"bc\"][\"12 3\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isDimensionExpresion((String)"dimension[\"abc\"][\"12 3\"]+2"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isDimensionExpresion((String)"2+dimension[\"abc\"][\"12 3\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isDimensionExpresion((String)"dimension[\"abc\"][12 3]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isDimensionExpresion((String)"dimension[\"abc\"]"));
    }

    public void testGetLevelNameFromDimensionExpression() {
        String[] levels = ChartXTabUtil.getLevelNameFromDimensionExpression((String)"dimension[\"abc\"][\"12 3\"]");
        ChartUtilTest.assertEquals((String)"abc", (String)levels[0]);
        ChartUtilTest.assertEquals((String)"12 3", (String)levels[1]);
        levels = ChartXTabUtil.getLevelNameFromDimensionExpression((String)"dimension[\"a\"+\"bc\"][\"a\"+2*3+\"b\"]");
        ChartUtilTest.assertEquals((String)"abc", (String)levels[0]);
        ChartUtilTest.assertEquals((String)"a6b", (String)levels[1]);
        levels = ChartXTabUtil.getLevelNameFromDimensionExpression((String)"1+dimension[\"abc\"][\"12 3\"]");
        ChartUtilTest.assertNull((Object)levels);
    }

    public void testIsMeasureExpresion() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isMeasureExpresion((String)"measure[\"12 3\"]"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartXTabUtil.isMeasureExpresion((String)"measure[\"a\"+\"bc\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isMeasureExpresion((String)"measure[\"12 3\"]+1"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isMeasureExpresion((String)"1*measure[\"12 3\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isMeasureExpresion((String)"measure[12 3]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartXTabUtil.isMeasureExpresion((String)"dimension[\"abc\"]"));
    }

    public void testGetMeasureName() {
        ChartUtilTest.assertEquals((String)"12 3", (String)ChartXTabUtil.getMeasureName((String)"measure[\"12 3\"]"));
        ChartUtilTest.assertEquals((String)"abc", (String)ChartXTabUtil.getMeasureName((String)"measure[\"a\"+\"bc\"]"));
        ChartUtilTest.assertNull((Object)ChartXTabUtil.getMeasureName((String)"measure[\"abc\"+5]"));
    }

    public void testCheckStringInExpression() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartReportItemUtil.checkStringInExpression((String)"data[\"year\"]+\"Q\"+data[\"quarter\"]"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartReportItemUtil.checkStringInExpression((String)"\"Q\"+data[\"quarter\"]"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartReportItemUtil.checkStringInExpression((String)"data[\"quarter\"]+\"Q\""));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartReportItemUtil.checkStringInExpression((String)"data[\"year\"]+data[\"quarter\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartReportItemUtil.checkStringInExpression((String)"4+data[\"quarter\"]"));
    }

    public void testIsSingleExpression() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartReportItemUtil.isSimpleExpression((String)"row[\"xxxxx\"]"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartReportItemUtil.isSimpleExpression((String)"row[\"row a\"]"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartReportItemUtil.isSimpleExpression((String)"data[\"xxxxx\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartReportItemUtil.isSimpleExpression((String)"row[\"xxxxx\"]+row[\"xxxxx\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartReportItemUtil.isSimpleExpression((String)"row[\"xxxxx\"] + 1"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartReportItemUtil.isSimpleExpression((String)"1+row[\"xxxxx\"]"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartReportItemUtil.isSimpleExpression((String)"row[\"xxxxx\"].getDay()"));
    }

    public void testCompareVersion() {
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"2", (String)"2"));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"2", (String)"2."));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"2", (String)"2.0"));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.compareVersion((String)"3", (String)"2"));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.compareVersion((String)"3.", (String)"2"));
        ChartUtilTest.assertEquals((int)-16, (int)ChartUtil.compareVersion((String)"3.1", (String)"3.17"));
        ChartUtilTest.assertEquals((int)-15, (int)ChartUtil.compareVersion((String)"3.2", (String)"3.17"));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"3.1.", (String)"3.1.0"));
        ChartUtilTest.assertEquals((int)2, (int)ChartUtil.compareVersion((String)"3.1.2", (String)"3.1"));
        ChartUtilTest.assertEquals((int)-1, (int)ChartUtil.compareVersion((String)"3.1.2", (String)"3.1.3"));
        ChartUtilTest.assertEquals((int)1, (int)ChartUtil.compareVersion((String)"3.1.1.5", (String)"3.1"));
        ChartUtilTest.assertEquals((int)0, (int)ChartUtil.compareVersion((String)"3.1.1.5", (String)"3.1.1.5.0"));
        ChartUtilTest.assertEquals((int)-1, (int)ChartUtil.compareVersion((String)"3.1.1.5", (String)"3.1.1.6"));
    }

    public void testIsCubeRowExpression() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isCubeRowExpression((String)"data[\"a\"]", (boolean)true));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isCubeRowExpression((String)"data[\"a\"]", (boolean)false));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isCubeRowExpression((String)"data[\"a\"]+5", (boolean)true));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartUtil.isCubeRowExpression((String)"data[\"a\"]+5", (boolean)false));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isCubeRowExpression((String)"data[\"a\"]+data[\"c d\"]", (boolean)true));
    }

    public void testIsConstantExpression() {
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isConstantExpression((String)"0"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isConstantExpression((String)"20000"));
        ChartUtilTest.assertEquals((boolean)true, (boolean)ChartUtil.isConstantExpression((String)"-1.5"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartUtil.isConstantExpression((String)"1d"));
        ChartUtilTest.assertEquals((boolean)false, (boolean)ChartUtil.isConstantExpression((String)"1.2.4"));
    }
}

