/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.birt.chart.internal.model.Fraction;
import org.eclipse.birt.chart.internal.model.FractionApproximator;

public class FractionTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(FractionTest.class);
    }

    public void testConstructorPrecise() {
        Fraction f = FractionApproximator.getExactFraction((double)0.02);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)50L);
        f = FractionApproximator.getExactFraction((double)0.333333333333);
        FractionTest.assertEquals((long)f.getNumerator(), (long)33333333L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100000000L);
        f = FractionApproximator.getExactFraction((double)-0.333333333333);
        FractionTest.assertEquals((long)f.getNumerator(), (long)-33333333L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100000000L);
        f = FractionApproximator.getExactFraction((double)-0.33);
        FractionTest.assertEquals((long)f.getNumerator(), (long)-33L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100L);
    }

    public void testConstructorFixedNumerator() {
        Fraction f = FractionApproximator.getFractionWithNumerator((double)0.02, (long)2L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)2L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100L);
        f = FractionApproximator.getFractionWithNumerator((double)2.0, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)2L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)1L);
        f = FractionApproximator.getFractionWithNumerator((double)3.5, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)7L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)2L);
        f = FractionApproximator.getFractionWithNumerator((double)3.5, (long)10L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)10L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)3L);
        f = FractionApproximator.getFractionWithNumerator((double)0.064, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)16L);
        f = FractionApproximator.getFractionWithNumerator((double)-0.064, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)-16L);
        f = FractionApproximator.getFractionWithNumerator((double)-0.064, (long)-1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)-1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)16L);
        f = FractionApproximator.getFractionWithNumerator((double)0.0, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)0L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)1L);
    }

    public void testConstructorMaxDigits() {
        Fraction f = FractionApproximator.getFractionWithMaxDigits((double)0.17, (int)1);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)6L);
        f = FractionApproximator.getFractionWithMaxDigits((double)0.17, (int)2);
        FractionTest.assertEquals((long)f.getNumerator(), (long)8L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)47L);
        f = FractionApproximator.getFractionWithMaxDigits((double)0.17, (int)3);
        FractionTest.assertEquals((long)f.getNumerator(), (long)17L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100L);
        f = FractionApproximator.getFractionWithMaxDigits((double)0.33, (int)1);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)3L);
        f = FractionApproximator.getFractionWithMaxDigits((double)-0.33, (int)1);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)-3L);
    }

    public void testToString() {
        Fraction f = FractionApproximator.getFractionWithNumerator((double)0.02, (long)2L);
        FractionTest.assertEquals((String)f.toString(":"), (String)"2:100");
        FractionTest.assertEquals((String)f.toString(), (String)"2/100");
        f = new Fraction(5L, 1L);
        FractionTest.assertEquals((String)f.toString(), (String)"5");
        f = new Fraction(-2L, 3L);
        FractionTest.assertEquals((String)f.toString(), (String)"-2/3");
        f = new Fraction(2L, -3L);
        FractionTest.assertEquals((String)f.toString(), (String)"-2/3");
        f = new Fraction(-2L, -3L);
        FractionTest.assertEquals((String)f.toString(), (String)"2/3");
    }

    public void testInvert() {
        Fraction f1 = new Fraction(1L, 3L);
        Fraction f2 = new Fraction(3L, 1L);
        f1.invert();
        FractionTest.assertEquals((long)f1.getDenominator(), (long)f2.getDenominator());
        FractionTest.assertEquals((long)f2.getNumerator(), (long)f1.getNumerator());
    }
}

