/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.impl.FilterAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.datatools.connectivity.oda.design.AndExpression;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.CompositeFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.CustomFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DynamicFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.design.ExpressionParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.FilterExpression;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;

public class FilterAdapterTest
extends BaseTestCase {
    private static final String INPUT_FILE_ODA = "OdaDataSetCovertFilterExpression.xml";
    private static final String GOLDEN_FILE_ODA = "OdaDataSetCovertFilterExpression_golden.xml";
    private static final String INPUT_FILE_REPORT = "OdaDataSetCovertFilterCondition.xml";
    private static final String GOLDEN_FILE_REPORT = "OdaDataSetCovertFilterCondition_golden.xml";
    private static final String[] COLUMNS = new String[]{"name", "date", "id"};

    private DataSetDesign createDataSetDesign() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        setDesign.setPrimaryResultSet(resultSetDefn);
        return setDesign;
    }

    private DataSetDesign createTestDataSetDesign() {
        DataSetDesign setDesign = this.createDataSetDesign();
        this.updateResultSetCriteria(setDesign.getPrimaryResultSet());
        return setDesign;
    }

    private void updateResultSetCriteria(ResultSetDefinition resultSetDefn) {
        resultSetDefn.setCriteria(DesignFactory.eINSTANCE.createResultSetCriteria());
        ResultSetColumns resultSetColumns = DesignFactory.eINSTANCE.createResultSetColumns();
        int i = 0;
        while (i < 3) {
            ColumnDefinition column = DesignFactory.eINSTANCE.createColumnDefinition();
            column.setAttributes(DesignFactory.eINSTANCE.createDataElementAttributes());
            column.getAttributes().setName(COLUMNS[i]);
            resultSetColumns.getResultColumnDefinitions().add((Object)column);
            ++i;
        }
        resultSetDefn.setResultSetColumns(resultSetColumns);
        resultSetDefn.getCriteria().setFilterSpecification(this.createFilterSpec(resultSetDefn));
    }

    private FilterExpression createFilterSpec(ResultSetDefinition resultSetDefn) {
        CustomFilterExpression customStaticExpr = DesignFactory.eINSTANCE.createCustomFilterExpression();
        customStaticExpr.setDeclaringExtensionId("org.eclipse.datatools.connectivity.oda.consumer.testdriver.dynamicResultSetExtension");
        customStaticExpr.setId("IdentityEq");
        customStaticExpr.setContextVariable(DesignUtil.createFilterVariable((ResultSetColumns)resultSetDefn.getResultSetColumns(), (int)0));
        DynamicFilterExpression dynamicFilter1 = DesignFactory.eINSTANCE.createDynamicFilterExpression();
        dynamicFilter1.setContextVariable(DesignUtil.createFilterVariable((ResultSetColumns)resultSetDefn.getResultSetColumns(), (int)1));
        DynamicFilterExpression dynamicFilter2 = DesignFactory.eINSTANCE.createDynamicFilterExpression();
        dynamicFilter2.setContextVariable(DesignUtil.createFilterVariable((ResultSetColumns)resultSetDefn.getResultSetColumns(), (int)1));
        dynamicFilter2.setIsOptional(true);
        dynamicFilter2.setContextArguments(DesignFactory.eINSTANCE.createExpressionArguments());
        ExpressionArguments exprArgs2 = dynamicFilter2.getContextArguments();
        exprArgs2.addStaticParameter((Object)new Integer(100));
        ((ExpressionParameterDefinition)exprArgs2.getExpressionParameterDefinitions().get(0)).addStaticValue((Object)new Integer(200));
        DynamicFilterExpression dynamicFilter3 = DesignFactory.eINSTANCE.createDynamicFilterExpression();
        dynamicFilter3.setContextVariable(DesignUtil.createFilterVariable((ResultSetColumns)resultSetDefn.getResultSetColumns(), (int)2));
        dynamicFilter3.setContextArguments(DesignFactory.eINSTANCE.createExpressionArguments());
        ExpressionArguments exprArgs3 = dynamicFilter3.getContextArguments();
        exprArgs3.addDynamicParameter(this.createParameterDefinition());
        ((ExpressionParameterDefinition)exprArgs3.getExpressionParameterDefinitions().get(0)).addStaticValue((Object)"dummy");
        DynamicFilterExpression dynamicFilter4 = DesignFactory.eINSTANCE.createDynamicFilterExpression();
        dynamicFilter4.setContextVariable(DesignUtil.createFilterVariable((ResultSetColumns)resultSetDefn.getResultSetColumns(), (int)2));
        dynamicFilter4.setContextArguments(DesignFactory.eINSTANCE.createExpressionArguments());
        ExpressionArguments exprArgs4 = dynamicFilter3.getContextArguments();
        exprArgs4.addDynamicParameter(this.createParameterDefinition());
        ((ExpressionParameterDefinition)exprArgs4.getExpressionParameterDefinitions().get(0)).addStaticValue((Object)"dummy");
        CompositeFilterExpression filterExprRoot = DesignFactory.eINSTANCE.createCompositeFilterExpression();
        filterExprRoot.add((FilterExpression)customStaticExpr);
        filterExprRoot.add((FilterExpression)dynamicFilter1);
        AndExpression andExpr = DesignFactory.eINSTANCE.createAndExpression();
        andExpr.add((FilterExpression)dynamicFilter2);
        andExpr.add((FilterExpression)dynamicFilter3);
        andExpr.add((FilterExpression)dynamicFilter4);
        filterExprRoot.add((FilterExpression)andExpr);
        return filterExprRoot;
    }

    private ParameterDefinition createParameterDefinition() {
        ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
        paramDefn.setAttributes(DesignFactory.eINSTANCE.createDataElementAttributes());
        DataElementAttributes paramAttrs = paramDefn.getAttributes();
        paramAttrs.setPosition(1);
        paramAttrs.setNativeDataTypeCode(1);
        paramAttrs.setNullability(ElementNullability.NULLABLE_LITERAL);
        int i = 1;
        while (i <= 3) {
            paramDefn.addDefaultValue((Object)("value" + i));
            ++i;
        }
        InputElementAttributes inputAttrs = paramDefn.getInputAttributes().getElementAttributes();
        inputAttrs.setUiPromptStyle(InputPromptControlStyle.SELECTABLE_LIST_WITH_TEXT_FIELD_LITERAL);
        inputAttrs.getUiHints().setAutoSuggestThreshold(3);
        return paramDefn;
    }

    public void testODAToReport() throws Exception {
        this.openDesign(INPUT_FILE_ODA);
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        FilterAdapter adapter = new FilterAdapter(setHandle, this.createTestDataSetDesign());
        adapter.updateROMFilterCondition();
        List filters = setHandle.getListProperty("filter");
        FilterAdapterTest.assertEquals((int)3, (int)filters.size());
        FilterCondition filter = (FilterCondition)filters.get(0);
        FilterAdapterTest.assertEquals((String)COLUMNS[0], (String)filter.getExpr());
        FilterAdapterTest.assertEquals((String)"org.eclipse.datatools.connectivity.oda.consumer.testdriver.dynamicResultSetExtension", (String)filter.getExtensionName());
        FilterAdapterTest.assertEquals((String)"IdentityEq", (String)filter.getExtensionExprId());
        FilterAdapterTest.assertTrue((boolean)filter.pushDown());
        filter = (FilterCondition)filters.get(1);
        FilterAdapterTest.assertEquals((String)COLUMNS[1], (String)filter.getExpr());
        FilterAdapterTest.assertTrue((boolean)filter.isOptional());
        FilterAdapterTest.assertNotNull((Object)filter.getDynamicFilterParameter());
        DynamicFilterParameterHandle parameter = (DynamicFilterParameterHandle)this.designHandle.findParameter(filter.getDynamicFilterParameter());
        FilterAdapterTest.assertEquals((String)setHandle.getName(), (String)parameter.getDataSetName());
        FilterAdapterTest.assertEquals((String)COLUMNS[1], (String)parameter.getColumn());
        filter = (FilterCondition)filters.get(2);
        FilterAdapterTest.assertEquals((String)COLUMNS[2], (String)filter.getExpr());
        FilterAdapterTest.assertNotNull((Object)filter.getDynamicFilterParameter());
        parameter = (DynamicFilterParameterHandle)this.designHandle.findParameter(filter.getDynamicFilterParameter());
        FilterAdapterTest.assertEquals((String)setHandle.getName(), (String)parameter.getDataSetName());
        FilterAdapterTest.assertEquals((String)COLUMNS[2], (String)parameter.getColumn());
        List defaultValues = parameter.getDefaultValueList();
        FilterAdapterTest.assertNotNull((Object)defaultValues);
        FilterAdapterTest.assertEquals((int)3, (int)defaultValues.size());
        int i = 0;
        while (i < 3) {
            FilterAdapterTest.assertEquals((Object)("value" + (i + 1)), defaultValues.get(i));
            ++i;
        }
        this.save();
        FilterAdapterTest.assertTrue((boolean)this.compareTextFile(GOLDEN_FILE_ODA));
    }

    public void testReportToOda() throws Exception {
        this.openDesign(INPUT_FILE_REPORT);
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = this.createDataSetDesign();
        FilterAdapter adapter = new FilterAdapter(setHandle, setDesign);
        adapter.updateOdaFilterExpression();
        ResultSetDefinition resultSet = setDesign.getPrimaryResultSet();
        FilterExpression filterExpr = resultSet.getCriteria().getFilterSpecification();
        FilterAdapterTest.assertTrue((boolean)(filterExpr instanceof CompositeFilterExpression));
        FilterAdapterTest.assertEquals((int)3, (int)((CompositeFilterExpression)filterExpr).getChildren().size());
        CompositeFilterExpression compoisteFilterExpr = (CompositeFilterExpression)filterExpr;
        FilterAdapterTest.assertTrue((boolean)(compoisteFilterExpr.getChildren().get(0) instanceof CustomFilterExpression));
        FilterAdapterTest.assertTrue((boolean)(compoisteFilterExpr.getChildren().get(1) instanceof DynamicFilterExpression));
        FilterAdapterTest.assertTrue((boolean)(compoisteFilterExpr.getChildren().get(2) instanceof DynamicFilterExpression));
        CustomFilterExpression customFilterExpr = (CustomFilterExpression)compoisteFilterExpr.getChildren().get(0);
        FilterAdapterTest.assertEquals((String)COLUMNS[0], (String)customFilterExpr.getContextVariable().getIdentifier());
        FilterAdapterTest.assertEquals((String)"org.eclipse.datatools.connectivity.oda.consumer.testdriver.dynamicResultSetExtension", (String)customFilterExpr.getDeclaringExtensionId());
        FilterAdapterTest.assertEquals((String)"IdentityEq", (String)customFilterExpr.getId());
        DynamicFilterExpression dynamicFilterExpr = (DynamicFilterExpression)compoisteFilterExpr.getChildren().get(1);
        FilterAdapterTest.assertEquals((String)COLUMNS[1], (String)dynamicFilterExpr.getContextVariable().getIdentifier());
        FilterAdapterTest.assertTrue((boolean)dynamicFilterExpr.isOptional());
        FilterAdapterTest.assertFalse((boolean)((ExpressionParameterDefinition)dynamicFilterExpr.getContextArguments().getExpressionParameterDefinitions().get(0)).getDynamicInputParameter().getAttributes().allowsNull());
        dynamicFilterExpr = (DynamicFilterExpression)compoisteFilterExpr.getChildren().get(2);
        FilterAdapterTest.assertEquals((String)COLUMNS[2], (String)dynamicFilterExpr.getContextVariable().getIdentifier());
        FilterAdapterTest.assertFalse((boolean)dynamicFilterExpr.isOptional());
        ExpressionParameterDefinition paramDefn = (ExpressionParameterDefinition)dynamicFilterExpr.getContextArguments().getExpressionParameterDefinitions().get(0);
        FilterAdapterTest.assertEquals((int)3, (int)paramDefn.getDynamicInputParameter().getDefaultValueCount());
        int i = 0;
        while (i < 3) {
            Object defualtValue = paramDefn.getDynamicInputParameter().getDefaultValues().getValues().get(i);
            FilterAdapterTest.assertEquals((Object)("value" + (i + 1)), (Object)defualtValue);
            ++i;
        }
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setResultSets(setDesign.getResultSets());
        this.saveDesignValuesToFile(values);
        FilterAdapterTest.assertTrue((boolean)this.compareTextFile(GOLDEN_FILE_REPORT));
    }
}

