/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;
import org.eclipse.emf.common.util.EList;

public class ResultSetColumnAdapterTest
extends BaseTestCase {
    public void testToODAResultSetsWithColumnHint() throws Exception {
        this.openDesign("OdaDataSetConvertResultSetsTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setResultSets(setDesign.getResultSets());
        this.saveDesignValuesToFile(values);
        ResultSetColumnAdapterTest.assertTrue((boolean)this.compareTextFile("ResultSetsWithHint_golden.xml"));
    }

    public void testToROMResultSetsWithColumnHints() throws Exception {
        this.openDesign("OdaDataSetConvertResultSetsTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        ResultSets sets = setDesign.getResultSets();
        ResultSetDefinition setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        this.updateResultSetDefinition1(setDefn);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        ResultSetColumnAdapterTest.assertTrue((boolean)this.compareTextFile("OdaDataSetConvertResultSetsTest_golden.xml"));
        this.openDesign("OdaDataSetConvertResultSetsTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        sets = setDesign.getResultSets();
        setDefn = (ResultSetDefinition)sets.getResultSetDefinitions().get(0);
        this.updateResultSetDefinition1(setDefn);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        ResultSetColumnAdapterTest.assertTrue((boolean)this.compareTextFile("OdaDataSetConvertResultSetsTest_1_golden.xml"));
        this.openDesign("OdaDataSetConvertResultSetsTest_1.xml");
        setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        Iterator hints = setHandle.columnHintsIterator();
        Iterator columns = setHandle.resultSetIterator();
        this.updateResultSetColumnAndHint((OdaResultSetColumnHandle)columns.next(), (ColumnHintHandle)hints.next());
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        ResultSetColumnAdapterTest.assertTrue((boolean)this.compareTextFile("OdaDataSetConvertResultSetsTest_2_golden.xml"));
    }

    public void testToROMResultSetsWithBlobType() throws Exception {
        this.openDesign("OdaDataSetConvertResultSetsTest_2.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("myDataSet1");
        DataSetDesign setDesign = new ModelOdaAdapter().createDataSetDesign(setHandle);
        this.updateResultSetDefinition2(setHandle);
        new ModelOdaAdapter().updateDataSetHandle(setDesign, setHandle, false);
        this.save();
        ResultSetColumnAdapterTest.assertTrue((boolean)this.compareTextFile("OdaDataSetConvertResultSetsTest_3_golden.xml"));
    }

    private void updateResultSetColumnAndHint(OdaResultSetColumnHandle column, ColumnHintHandle hint) throws SemanticException {
        column.setDataType("decimal");
        hint.setDisplayName("new display name for column 1");
        hint.setHelpText("new help text for column 1");
        hint.setFormat("new format ");
    }

    private void updateResultSetDefinition1(ResultSetDefinition setDefn) {
        EList columns = setDefn.getResultSetColumns().getResultColumnDefinitions();
        ColumnDefinition column1 = (ColumnDefinition)columns.get(0);
        ColumnDefinition column2 = (ColumnDefinition)columns.get(1);
        DataElementAttributes dataAttrs = column1.getAttributes();
        DataElementUIHints dataUIHints = dataAttrs.getUiHints();
        dataUIHints.setDisplayName("new display name for column 1");
        OutputElementAttributes usageHints = column1.getUsageHints();
        usageHints.setHelpText("new help text for column 1");
        usageHints.getFormattingHints().setDisplayFormat("new format for column 1");
        dataUIHints = DesignFactory.eINSTANCE.createDataElementUIHints();
        dataUIHints.setDisplayName("new display name for column 2");
        dataAttrs = column2.getAttributes();
        dataAttrs.setUiHints(dataUIHints);
        usageHints = DesignFactory.eINSTANCE.createOutputElementAttributes();
        usageHints.setHelpText("new help text for column 2");
        ValueFormatHints format = DesignFactory.eINSTANCE.createValueFormatHints();
        format.setDisplayFormat("new format for column 2");
        usageHints.setFormattingHints(format);
        column2.setUsageHints(usageHints);
    }

    private void updateResultSetDefinition2(OdaDataSetHandle setHandle) throws SemanticException {
        Iterator iter1 = setHandle.resultSetIterator();
        OdaResultSetColumnHandle column = (OdaResultSetColumnHandle)iter1.next();
        column.setNativeDataType(new Integer(10));
    }
}

