/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.SearchKey;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ActionHandleTest
extends BaseTestCase {
    ActionHandle actionHandle = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ActionHandleTest.xml");
        ActionHandleTest.assertNotNull((Object)this.designHandle);
    }

    private ActionHandle getAction(String imageName) {
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement(imageName);
        ActionHandleTest.assertNotNull((Object)imageHandle);
        return imageHandle.getActionHandle();
    }

    public void testAdd() throws Exception {
        this.openDesign("ActionHandleTest2.xml");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image1");
        ActionHandle actionHandle = imageHandle.getActionHandle();
        MemberHandle memberHandle = actionHandle.getParamBindings();
        ActionHandleTest.assertEquals((int)1, (int)memberHandle.getListValue().size());
        ActionHandleTest.assertEquals((String)"exp0", (String)((ParamBindingHandle)memberHandle.getAt(0)).getExpression());
        memberHandle.removeItem(0);
        ActionHandleTest.assertEquals((int)0, (int)memberHandle.getListValue().size());
        Action action = StructureFactory.createAction();
        actionHandle = imageHandle.setAction(action);
        ActionHandleTest.assertEquals((String)"hyperlink", (String)actionHandle.getLinkType());
        actionHandle.setReportName("report-name1");
        actionHandle.setLinkType("drill-through");
        SearchKey key1 = StructureFactory.createSearchKey();
        key1.setExpression("Key1");
        SearchKey key2 = StructureFactory.createSearchKey();
        key2.setExpression("Key2");
        actionHandle.addSearch(key1);
        actionHandle.addSearch(key2);
        ParamBinding param1 = StructureFactory.createParamBinding();
        param1.setExpression("exp1");
        param1.setParamName("param1");
        ParamBinding param2 = StructureFactory.createParamBinding();
        param2.setExpression("exp2");
        param2.setParamName("param2");
        actionHandle.addParamBinding(param1);
        actionHandle.getParamBindings().addItem((IStructure)param2);
        this.save();
        ActionHandleTest.assertTrue((boolean)this.compareFile("ActionHandleTest2_golden.xml"));
    }

    public void testGetLinkExpr() throws Exception {
        this.actionHandle = this.getAction("Image1");
        ActionHandleTest.assertEquals((String)"www.rock.com.cn/haha/test.html", (String)this.actionHandle.getURI());
        ActionHandleTest.assertNull((Object)this.actionHandle.getTargetBookmark());
        Iterator iter = this.actionHandle.paramBindingsIterator();
        ActionHandleTest.assertFalse((boolean)iter.hasNext());
        iter = this.actionHandle.searchIterator();
        ActionHandleTest.assertFalse((boolean)iter.hasNext());
        this.actionHandle = this.getAction("Image2");
        ActionHandleTest.assertEquals((String)"www.rock.com/bookmarks/1.jsp", (String)this.actionHandle.getTargetBookmark());
        this.actionHandle = this.getAction("Image4");
        ActionHandleTest.assertEquals((String)"www.rock.com.cn/haha/index.html/bookmarklink1", (String)this.actionHandle.getTargetBookmark());
    }

    public void testSetLinkExpr() throws SemanticException {
        this.actionHandle = this.getAction("Image1");
        this.actionHandle.setURI("http://birt.eclipse.org/");
        this.actionHandle.setLinkType("hyperlink");
        ActionHandleTest.assertEquals((String)"http://birt.eclipse.org/", (String)this.actionHandle.getURI());
        ActionHandleTest.assertNull((Object)this.actionHandle.getTargetBookmark());
        this.actionHandle.setTargetBookmark("Bookmark1");
        this.actionHandle.setLinkType("bookmark-link");
        ActionHandleTest.assertEquals((String)"Bookmark1", (String)this.actionHandle.getTargetBookmark());
        ActionHandleTest.assertEquals((String)"bookmark-link", (String)this.actionHandle.getLinkType());
        ActionHandleTest.assertNull((Object)this.actionHandle.getURI());
        this.actionHandle.setTargetBookmark("report1#section 1");
        this.actionHandle.setLinkType("drill-through");
        ActionHandleTest.assertEquals((String)"report1#section 1", (String)this.actionHandle.getTargetBookmark());
        ActionHandleTest.assertNull((Object)this.actionHandle.getURI());
    }

    public void testGetLinkType() throws Exception {
        this.actionHandle = this.getAction("Image1");
        ActionHandleTest.assertEquals((String)"hyperlink", (String)this.actionHandle.getLinkType());
        this.actionHandle = this.getAction("Image2");
        ActionHandleTest.assertEquals((String)"drill-through", (String)this.actionHandle.getLinkType());
        this.actionHandle = this.getAction("Image4");
        ActionHandleTest.assertEquals((String)"bookmark-link", (String)this.actionHandle.getLinkType());
    }

    public void testGetDrillthroughParameters() throws Exception {
        this.actionHandle = this.getAction("Image2");
        Iterator iter = this.actionHandle.paramBindingsIterator();
        ParamBindingHandle p1 = (ParamBindingHandle)iter.next();
        ActionHandleTest.assertEquals((String)"1+1=3", (String)p1.getExpression());
        ActionHandleTest.assertEquals((String)"param1", (String)p1.getParamName());
        ActionHandleTest.assertNotNull(iter.next());
        ActionHandleTest.assertNull(iter.next());
        p1.setExpression("hello 1");
        p1.setParamName("hello name 1");
        ActionHandleTest.assertEquals((String)"hello 1", (String)p1.getExpression());
        ActionHandleTest.assertEquals((String)"hello name 1", (String)p1.getParamName());
    }

    public void testAddDrillthroughParameter() throws Exception {
        this.actionHandle = this.getAction("Image2");
        ParamBinding p = new ParamBinding();
        PropertyDefn nameProp = (PropertyDefn)p.getDefn().getMember("paramName");
        PropertyDefn exprProp = (PropertyDefn)p.getDefn().getMember("expression");
        p.setProperty(nameProp, (Object)"ParamX");
        p.setProperty(exprProp, (Object)"ExprX");
        MemberHandle paramHandle = this.actionHandle.getParamBindings();
        paramHandle.addItem((IStructure)p);
        Iterator iter = this.actionHandle.paramBindingsIterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        ActionHandleTest.assertEquals((int)3, (int)count);
    }

    public void testGetDrillthroughSearchKeys() throws Exception {
        this.actionHandle = this.getAction("Image3");
        Iterator searchKeys = this.actionHandle.searchIterator();
        SearchKeyHandle key1 = (SearchKeyHandle)searchKeys.next();
        ActionHandleTest.assertEquals((String)"searchKey1", (String)key1.getExpression());
        key1.setExpression("new expression");
        ActionHandleTest.assertEquals((String)"new expression", (String)key1.getExpression());
        ActionHandleTest.assertNotNull(searchKeys.next());
        ActionHandleTest.assertNull(searchKeys.next());
    }

    public void testaddDrillthroughSearchKeys() throws Exception {
        this.actionHandle = this.getAction("Image3");
        SearchKey key = new SearchKey();
        PropertyDefn exprProp = (PropertyDefn)key.getDefn().getMember("expression");
        key.setProperty(exprProp, (Object)"new Key3");
        MemberHandle searchHandle = this.actionHandle.getSearch();
        searchHandle.addItem((IStructure)key);
        Iterator iter = this.actionHandle.searchIterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        ActionHandleTest.assertEquals((int)3, (int)count);
    }

    public void testOtherMethods() throws Exception {
        this.actionHandle = this.getAction("Image3");
        ActionHandleTest.assertEquals((String)"Window3", (String)this.actionHandle.getTargetWindow());
        this.actionHandle = this.getAction("Image1");
        ActionHandleTest.assertEquals((String)"_blank", (String)this.actionHandle.getTargetWindow());
        this.actionHandle.setTargetWindow("new target windows");
        ActionHandleTest.assertEquals((String)"new target windows", (String)this.actionHandle.getTargetWindow());
    }

    public void testActionFormatType() throws Exception {
        this.openDesign("ActionHandleTest3.xml");
        this.actionHandle = this.getAction("Image");
        ActionHandleTest.assertEquals((String)"html", (String)this.actionHandle.getFormatType());
        this.actionHandle.setFormatType("pdf");
        ActionHandleTest.assertEquals((String)"pdf", (String)this.actionHandle.getFormatType());
        this.actionHandle.setFormatType("userDefinedType");
        this.save();
        ActionHandleTest.assertTrue((boolean)this.compareFile("ActionHandleTest3_golden.xml"));
    }

    public void testActionTargetFileType() throws Exception {
        this.openDesign("ActionHandleTest4.xml");
        this.actionHandle = this.getAction("Image");
        ActionHandleTest.assertNull((Object)this.actionHandle.getTargetFileType());
        ActionHandleTest.assertEquals((String)"toc", (String)this.actionHandle.getTargetBookmarkType());
        this.actionHandle.setTargetBookmarkType("bookmark");
        this.actionHandle = this.getAction("Image1");
        ActionHandleTest.assertNull((Object)this.actionHandle.getTargetBookmarkType());
        ActionHandleTest.assertEquals((String)"report-document", (String)this.actionHandle.getTargetFileType());
        this.actionHandle.setTargetFileType("report-design");
        ActionHandleTest.assertEquals((String)"report-design", (String)this.actionHandle.getTargetFileType());
        try {
            this.actionHandle.setTargetFileType("wrong choice");
            ActionHandleTest.fail();
        }
        catch (PropertyValueException e) {
            ActionHandleTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        this.save();
        ActionHandleTest.assertTrue((boolean)this.compareFile("ActionHandleTest4_golden.xml"));
    }
}

