/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.LineHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ElementFactoryTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    public void testNewElement() {
        ElementFactory factory = new ElementFactory((Module)this.design);
        DesignElementHandle element = factory.newElement("Data", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof DataItemHandle));
        element = factory.newElement("Cell", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof CellHandle));
        element = factory.newElement("Column", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ColumnHandle));
        element = factory.newElement("DataSet", null);
        ElementFactoryTest.assertNull((Object)element);
        element = factory.newElement("DataSource", null);
        ElementFactoryTest.assertNull((Object)element);
        element = factory.newElement("ExtendedItem", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ExtendedItemHandle));
        element = factory.newElement("FreeForm", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof FreeFormHandle));
        element = factory.newElement("GraphicMasterPage", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof GraphicMasterPageHandle));
        element = factory.newElement("Grid", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof GridHandle));
        element = factory.newElement("Image", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ImageHandle));
        element = factory.newElement("Label", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof LabelHandle));
        element = factory.newElement("Line", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof LineHandle));
        element = factory.newElement("ListGroup", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ListGroupHandle));
        element = factory.newElement("List", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ListHandle));
        element = factory.newElement("MasterPage", null);
        ElementFactoryTest.assertNull((Object)element);
        element = factory.newElement("TextData", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof TextDataHandle));
        element = factory.newElement("ParameterGroup", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ParameterGroupHandle));
        element = factory.newElement("Rectangle", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof RectangleHandle));
        element = factory.newElement("ReportDesign", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ReportDesignHandle));
        element = factory.newElement("ReportItem", null);
        ElementFactoryTest.assertNull((Object)element);
        element = factory.newElement("Row", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof RowHandle));
        element = factory.newElement("ScalarParameter", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ScalarParameterHandle));
        element = factory.newElement("ScriptDataSource", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof ScriptDataSourceHandle));
        element = factory.newElement("SimpleMasterPage", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof SimpleMasterPageHandle));
        element = factory.newElement("Style", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof StyleHandle));
        element = factory.newElement("TableGroup", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof TableGroupHandle));
        element = factory.newElement("Table", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof TableHandle));
        element = factory.newElement("Text", null);
        ElementFactoryTest.assertTrue((boolean)(element instanceof TextItemHandle));
        element = factory.newElement("Text", "text item");
        ElementFactoryTest.assertEquals((String)"text item", (String)element.getName());
    }

    public void testNewElementFrom() throws Exception {
        this.openDesign("ElementFactoryTest_1.xml");
        LibraryHandle libHandle = this.designHandle.getLibrary("Lib3");
        LabelHandle baseLabelHandle = (LabelHandle)libHandle.getComponents().get(0);
        TableHandle baseTableHandle = (TableHandle)libHandle.getComponents().get(1);
        ElementFactory factory = this.designHandle.getElementFactory();
        LabelHandle label1 = (LabelHandle)factory.newElementFrom((DesignElementHandle)baseLabelHandle, "label1");
        TableHandle table1 = (TableHandle)factory.newElementFrom((DesignElementHandle)baseTableHandle, "table1");
        this.designHandle.getBody().add((DesignElementHandle)label1);
        this.designHandle.getBody().add((DesignElementHandle)table1);
        this.design.getActivityStack().undo();
        this.design.getActivityStack().undo();
        ElementFactoryTest.assertNull((Object)this.designHandle.findElement("label1"));
        ElementFactoryTest.assertNull((Object)this.designHandle.findElement("table1"));
        ParameterGroupHandle baseParameterGroup = (ParameterGroupHandle)libHandle.getParameters().get(0);
        ElementFactoryTest.assertNotNull((Object)baseParameterGroup);
        ParameterGroupHandle childParameterGroup = (ParameterGroupHandle)factory.newElementFrom((DesignElementHandle)baseParameterGroup, "newPara");
        this.designHandle.getParameters().add((DesignElementHandle)childParameterGroup);
        childParameterGroup = (ParameterGroupHandle)factory.newElementFrom((DesignElementHandle)baseParameterGroup, "newParaTwo");
        this.designHandle.getParameters().add((DesignElementHandle)childParameterGroup);
        this.save();
        this.compareFile("ElementFactoryTest_golden.xml");
        int count = this.designHandle.getParameters().getCount();
        int i = count - 1;
        while (i >= 0) {
            DesignElementHandle param = this.designHandle.getParameters().get(i);
            param.drop();
            --i;
        }
        childParameterGroup = (ParameterGroupHandle)factory.newElementFrom((DesignElementHandle)baseParameterGroup, "newPara");
        this.designHandle.getParameters().add((DesignElementHandle)childParameterGroup);
        this.save();
    }

    public void testNewSpecifiedElement() {
        ElementFactory factory = new ElementFactory((Module)this.design);
        CellHandle handle = factory.newCell();
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newDataItem("new data");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newFreeForm("new freeform");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newGraphicMasterPage("new graphic master page");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newGridItem("new grid item");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newImage("new image item");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newLabel("new label");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newLineItem("new line");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newList("new list");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newListGroup();
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newParameterGroup("new parameter group");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newRectangle("new rectangle");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newScalarParameter(null);
        ElementFactoryTest.assertEquals((String)"NewParameter", (String)handle.getName());
        handle = factory.newScalarParameter("new scalar parameter");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newDynamicFilterParameter(null);
        ElementFactoryTest.assertEquals((String)"NewDynamicFilterParameter", (String)handle.getName());
        handle = factory.newDynamicFilterParameter("new dynamic filter parameter");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newScriptDataSet("new script data set");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newScriptDataSource("new script data source");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newSimpleMasterPage("new simple master page");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newStyle("new style");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newTableColumn();
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newTableGroup();
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newTableItem("new table");
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newTableRow();
        ElementFactoryTest.assertNotNull((Object)handle);
        handle = factory.newTextItem("new text");
        ElementFactoryTest.assertNotNull((Object)handle);
    }

    public void testNewTableItem() {
        int j;
        ElementFactoryTest.assertFalse((boolean)this.designHandle.needsSave());
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle tableHandle1 = factory.newTableItem("Table1", 2);
        ElementFactoryTest.assertFalse((boolean)this.designHandle.needsSave());
        ElementFactoryTest.assertEquals((String)"Table1", (String)tableHandle1.getName());
        ElementFactoryTest.assertEquals((int)1, (int)tableHandle1.getHeader().getCount());
        ElementFactoryTest.assertEquals((int)1, (int)tableHandle1.getFooter().getCount());
        ElementFactoryTest.assertEquals((int)1, (int)tableHandle1.getDetail().getCount());
        ElementFactoryTest.assertEquals((int)2, (int)tableHandle1.getColumns().getCount());
        RowHandle rowHandle = (RowHandle)tableHandle1.getHeader().get(0);
        ElementFactoryTest.assertEquals((int)2, (int)rowHandle.getCells().getCount());
        ElementFactoryTest.assertEquals((Object)tableHandle1, (Object)rowHandle.getContainer());
        rowHandle = (RowHandle)tableHandle1.getFooter().get(0);
        ElementFactoryTest.assertEquals((int)2, (int)rowHandle.getCells().getCount());
        ElementFactoryTest.assertEquals((Object)tableHandle1, (Object)rowHandle.getContainer());
        rowHandle = (RowHandle)tableHandle1.getDetail().get(0);
        ElementFactoryTest.assertEquals((int)2, (int)rowHandle.getCells().getCount());
        ElementFactoryTest.assertEquals((Object)tableHandle1, (Object)rowHandle.getContainer());
        TableHandle tableHandle2 = factory.newTableItem("Table2", 3, 4, 5, 6);
        ElementFactoryTest.assertEquals((String)"Table2", (String)tableHandle2.getName());
        ElementFactoryTest.assertEquals((int)3, (int)tableHandle2.getColumns().getCount());
        ElementFactoryTest.assertEquals((int)4, (int)tableHandle2.getHeader().getCount());
        ElementFactoryTest.assertEquals((int)5, (int)tableHandle2.getDetail().getCount());
        ElementFactoryTest.assertEquals((int)6, (int)tableHandle2.getFooter().getCount());
        int i = 0;
        while (i < 4) {
            rowHandle = (RowHandle)tableHandle2.getHeader().get(i);
            ElementFactoryTest.assertEquals((int)3, (int)rowHandle.getCells().getCount());
            j = 0;
            while (j < 2) {
                ElementFactoryTest.assertEquals((Object)rowHandle, (Object)rowHandle.getCells().get(j).getContainer());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            rowHandle = (RowHandle)tableHandle2.getDetail().get(i);
            ElementFactoryTest.assertEquals((int)3, (int)rowHandle.getCells().getCount());
            j = 0;
            while (j < 2) {
                ElementFactoryTest.assertEquals((Object)rowHandle, (Object)rowHandle.getCells().get(j).getContainer());
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            rowHandle = (RowHandle)tableHandle2.getFooter().get(i);
            ElementFactoryTest.assertEquals((int)3, (int)rowHandle.getCells().getCount());
            j = 0;
            while (j < 2) {
                ElementFactoryTest.assertEquals((Object)rowHandle, (Object)rowHandle.getCells().get(j).getContainer());
                ++j;
            }
            ++i;
        }
        TableHandle tableHandle3 = factory.newTableItem("Table3", -1, -1, -1, -1);
        ElementFactoryTest.assertEquals((String)"Table3", (String)tableHandle3.getName());
        ElementFactoryTest.assertEquals((int)0, (int)tableHandle3.getHeader().getCount());
        ElementFactoryTest.assertEquals((int)0, (int)tableHandle3.getFooter().getCount());
        ElementFactoryTest.assertEquals((int)0, (int)tableHandle3.getDetail().getCount());
        ElementFactoryTest.assertEquals((int)0, (int)tableHandle3.getColumns().getCount());
    }

    public void testNewGridItem() {
        ElementFactoryTest.assertFalse((boolean)this.designHandle.needsSave());
        ElementFactory factory = new ElementFactory((Module)this.design);
        GridHandle gridHandle1 = factory.newGridItem("Grid1", 2, 3);
        ElementFactoryTest.assertFalse((boolean)this.designHandle.needsSave());
        ElementFactoryTest.assertEquals((int)2, (int)gridHandle1.getColumns().getCount());
        ElementFactoryTest.assertEquals((int)3, (int)gridHandle1.getRows().getCount());
        int i = 0;
        while (i < 2) {
            ColumnHandle colHandle = (ColumnHandle)gridHandle1.getColumns().get(i);
            ElementFactoryTest.assertEquals((Object)gridHandle1, (Object)colHandle.getContainer());
            ++i;
        }
        i = 0;
        while (i < 3) {
            RowHandle rowHandle = (RowHandle)gridHandle1.getRows().get(i);
            ElementFactoryTest.assertEquals((int)2, (int)rowHandle.getCells().getCount());
            ElementFactoryTest.assertEquals((Object)gridHandle1, (Object)rowHandle.getContainer());
            int j = 0;
            while (j < 2) {
                CellHandle cell = (CellHandle)rowHandle.getCells().get(j);
                ElementFactoryTest.assertEquals((Object)rowHandle, (Object)cell.getContainer());
                ++j;
            }
            ++i;
        }
        GridHandle gridHandle2 = factory.newGridItem("Grid1", -1, -1);
        ElementFactoryTest.assertEquals((int)0, (int)gridHandle2.getColumns().getCount());
        ElementFactoryTest.assertEquals((int)0, (int)gridHandle2.getRows().getCount());
    }

    public void testMakeUniqueName() throws ContentException, NameException {
        ElementFactoryTest.assertFalse((boolean)this.designHandle.needsSave());
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle tableHandle1 = factory.newTableItem("Table1", 2);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle1);
        TableHandle tableHandle2 = factory.newTableItem("Table1", 2);
        ElementFactoryTest.assertEquals((String)"Table11", (String)tableHandle2.getName());
        TableHandle tableHandle3 = factory.newTableItem(null);
        ElementFactoryTest.assertNull((Object)tableHandle3.getName());
        TabularDimensionHandle dimension = factory.newTabularDimension("a/b\\c.d:1!2;3,f");
        ElementFactoryTest.assertEquals((String)"a_b_c_d:1_2_3_f", (String)dimension.getName());
    }

    public void testNewExtendedItemFrom() throws Exception {
        this.openDesign("ElementFactoryTest_2.xml");
        LibraryHandle libraryHandle = this.designHandle.getLibrary("ElementFactoryLibTest");
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)libraryHandle.getElementByID(77L);
        DesignElementHandle handle = this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)extendedItem, "NewMatrix");
        ElementFactoryTest.assertNotNull((Object)handle);
        ElementFactoryTest.assertEquals((String)"NewMatrix", (String)handle.getName());
    }

    public void testNewStyleNameForTheme() throws Exception {
        this.openLibrary("LibraryWithTheme.xml");
        ThemeHandle theme = this.libraryHandle.findTheme("defaultTheme");
        ElementFactoryTest.assertNotNull((Object)theme.getElement());
        SharedStyleHandle newCreatedStyle = this.libraryHandle.getElementFactory().newStyle(theme, null);
        ElementFactoryTest.assertNotNull((Object)newCreatedStyle);
        ElementFactoryTest.assertEquals((String)"NewStyle1", (String)newCreatedStyle.getName());
        theme.addElement((DesignElementHandle)newCreatedStyle, 0);
        newCreatedStyle.dropAndClear();
        SharedStyleHandle style2 = this.libraryHandle.getElementFactory().newStyle(theme, null);
        ElementFactoryTest.assertEquals((String)"NewStyle1", (String)style2.getName());
    }
}

