/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class FactoryPropertyHandleTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetValues() throws DesignFileException, SemanticException {
        this.openDesign("FactoryPropertyHandleTest.xml");
        SharedStyleHandle style = this.designHandle.findStyle("My-Style");
        style.setStringProperty("fontSize", "larger");
        FactoryPropertyHandle property = style.getFactoryPropertyHandle("fontSize");
        FactoryPropertyHandleTest.assertEquals((boolean)false, (boolean)property.getBooleanValue());
        FactoryPropertyHandleTest.assertEquals(null, (String)property.getColorValue());
        FactoryPropertyHandleTest.assertEquals((int)0, (int)property.getIntValue());
        FactoryPropertyHandleTest.assertEquals((double)0.0, (double)property.getFloatValue(), (double)1.0);
        FactoryPropertyHandleTest.assertEquals((Object)new BigDecimal(0.0), (Object)property.getNumberValue());
        FactoryPropertyHandleTest.assertEquals((String)"larger", (String)property.getStringValue());
        style.setStringProperty("fontSize", "12" + this.design.getSession().getUnits());
        property = style.getFactoryPropertyHandle("fontSize");
        FactoryPropertyHandleTest.assertEquals((boolean)false, (boolean)property.getBooleanValue());
        FactoryPropertyHandleTest.assertEquals(null, (String)property.getColorValue());
        FactoryPropertyHandleTest.assertEquals((int)0, (int)property.getIntValue());
        FactoryPropertyHandleTest.assertEquals((double)12.0, (double)property.getFloatValue(), (double)1.0);
        FactoryPropertyHandleTest.assertEquals((Object)new BigDecimal(12), (Object)property.getNumberValue());
        FactoryPropertyHandleTest.assertEquals((String)("12" + this.design.getSession().getUnits()), (String)property.getStringValue());
        style.setStringProperty("orphans", "inherit");
        property = style.getFactoryPropertyHandle("orphans");
        FactoryPropertyHandleTest.assertEquals((boolean)false, (boolean)property.getBooleanValue());
        FactoryPropertyHandleTest.assertEquals(null, (String)property.getColorValue());
        FactoryPropertyHandleTest.assertEquals((int)0, (int)property.getIntValue());
        FactoryPropertyHandleTest.assertEquals((double)0.0, (double)property.getFloatValue(), (double)1.0);
        FactoryPropertyHandleTest.assertEquals((Object)new BigDecimal(0.0), (Object)property.getNumberValue());
        FactoryPropertyHandleTest.assertEquals((String)"inherit", (String)property.getStringValue());
        style.setStringProperty("orphans", "19");
        property = style.getFactoryPropertyHandle("orphans");
        FactoryPropertyHandleTest.assertEquals((boolean)true, (boolean)property.getBooleanValue());
        FactoryPropertyHandleTest.assertEquals(null, (String)property.getColorValue());
        FactoryPropertyHandleTest.assertEquals((int)19, (int)property.getIntValue());
        FactoryPropertyHandleTest.assertEquals((double)19.0, (double)property.getFloatValue(), (double)1.0);
        FactoryPropertyHandleTest.assertEquals((Object)new BigDecimal(19), (Object)property.getNumberValue());
        FactoryPropertyHandleTest.assertEquals((String)"19", (String)property.getStringValue());
        String color = style.getFactoryPropertyHandle("color").getColorValue();
        FactoryPropertyHandleTest.assertEquals((String)"red", (String)color);
        boolean isStyleProperty = style.getFactoryPropertyHandle("color").isStyleProperty();
        FactoryPropertyHandleTest.assertTrue((boolean)isStyleProperty);
    }
}

