/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.ApiTestUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class GridColumnHandleTest
extends BaseTestCase {
    private String fileName = "GridColumnHandleTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testColumnCopy() throws Exception {
        this.openDesign(this.fileName);
        GridHandle grid = (GridHandle)this.designHandle.findElement("My grid1");
        GridColumnHandleTest.assertNotNull((Object)grid);
        ColumnBandData data = grid.copyColumn(1);
        GridColumnHandleTest.assertEquals((int)2, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        grid = (GridHandle)this.designHandle.findElement("My grid2");
        GridColumnHandleTest.assertNotNull((Object)grid);
        data = grid.copyColumn(2);
        GridColumnHandleTest.assertEquals((int)1, (int)ApiTestUtil.getCopiedCells((ColumnBandData)data).size());
        TableColumn column = ApiTestUtil.getCopiedColumn((ColumnBandData)data);
        GridColumnHandleTest.assertEquals((int)1, (int)column.getIntProperty((Module)this.design, "repeat"));
        GridColumnHandleTest.assertEquals((String)"red", (String)column.getStringProperty((Module)this.design, "color"));
        GridColumnHandleTest.assertEquals((int)2, (int)ApiTestUtil.getCopiedCell((ColumnBandData)data, (int)0).getRowSpan((Module)this.design));
        grid = (GridHandle)this.designHandle.findElement("My grid3");
        GridColumnHandleTest.assertNotNull((Object)grid);
        try {
            data = grid.copyColumn(1);
            GridColumnHandleTest.fail();
        }
        catch (SemanticException e) {
            GridColumnHandleTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        try {
            data = grid.copyColumn(2);
            GridColumnHandleTest.fail();
        }
        catch (SemanticException e) {
            GridColumnHandleTest.assertEquals((String)"Error.SemanticError.COLUMN_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testCopyPasteWithForbiddenLayout() throws Exception {
        this.openDesign(this.fileName);
        GridHandle grid = (GridHandle)this.designHandle.findElement("My grid1");
        GridColumnHandleTest.assertNotNull((Object)grid);
        ColumnBandData adapter = grid.copyColumn(1);
        ElementFactory factory = grid.getElementFactory();
        GridHandle newGrid = factory.newGridItem("newGrid1", 2, 1);
        GridColumnHandleTest.assertEquals((int)2, (int)newGrid.getColumns().getCount());
        try {
            newGrid.pasteColumn(adapter, 1, true);
            GridColumnHandleTest.fail();
        }
        catch (SemanticException e) {
            GridColumnHandleTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_FORBIDDEN", (String)e.getErrorCode());
        }
    }

    public void testCopyNoColumnHeader2HasColumn() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        GridHandle grid1 = factory.newGridItem("grid1", 2, 2);
        GridHandle grid2 = factory.newGridItem("grid2", 2, 2);
        SlotHandle columns2 = grid2.getColumns();
        ColumnHandle column1InTable2 = (ColumnHandle)columns2.get(0);
        ColumnHandle column2InTable2 = (ColumnHandle)columns2.get(1);
        column1InTable2.setStringProperty("color", "aqua");
        column2InTable2.setStringProperty("color", "aqua");
        int numOfColumnsInTable1 = grid1.getColumns().getCount();
        int i = 0;
        while (i < numOfColumnsInTable1) {
            grid1.getColumns().dropAndClear(0);
            ++i;
        }
        GridColumnHandleTest.assertEquals((int)0, (int)grid1.getColumns().getCount());
        ColumnBandData adapter = grid1.copyColumn(1);
        grid2.pasteColumn(adapter, 1, true);
        GridColumnHandleTest.assertEquals((int)2, (int)columns2.getCount());
        column1InTable2 = (ColumnHandle)columns2.get(0);
        GridColumnHandleTest.assertEquals((Object)"black", (Object)column1InTable2.getProperty("color"));
        column2InTable2 = (ColumnHandle)columns2.get(1);
        GridColumnHandleTest.assertEquals((Object)"aqua", (Object)column2InTable2.getProperty("color"));
    }

    public void testCopyHasColumnHeader2NoColumn() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        GridHandle grid1 = factory.newGridItem("grid1", 2, 2);
        GridHandle grid2 = factory.newGridItem("grid2", 2, 2);
        SlotHandle columns1 = grid1.getColumns();
        ColumnHandle column1InTable1 = (ColumnHandle)columns1.get(0);
        ColumnHandle column2InTable1 = (ColumnHandle)columns1.get(1);
        column1InTable1.setStringProperty("color", "aqua");
        column2InTable1.setStringProperty("color", "aqua");
        int numOfColumnsInTable1 = grid2.getColumns().getCount();
        int i = 0;
        while (i < numOfColumnsInTable1) {
            grid2.getColumns().dropAndClear(0);
            ++i;
        }
        GridColumnHandleTest.assertEquals((int)0, (int)grid2.getColumns().getCount());
        ColumnBandData data = grid1.copyColumn(1);
        grid2.pasteColumn(data, 1, true);
        SlotHandle columns2 = grid2.getColumns();
        GridColumnHandleTest.assertEquals((int)2, (int)columns2.getCount());
        ColumnHandle column1InTable2 = (ColumnHandle)columns2.get(0);
        GridColumnHandleTest.assertEquals((Object)"aqua", (Object)column1InTable2.getProperty("color"));
        ColumnHandle column2InTable2 = (ColumnHandle)columns2.get(1);
        column2InTable2 = (ColumnHandle)columns2.get(1);
        GridColumnHandleTest.assertEquals((Object)"black", (Object)column2InTable2.getProperty("color"));
    }

    public void testCopyColumnHeader() throws Exception {
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        ElementFactory factory = new ElementFactory((Module)this.design);
        GridHandle grid1 = factory.newGridItem("grid1", 3, 2);
        GridHandle grid2 = factory.newGridItem("grid2", 3, 2);
        SlotHandle columns1 = grid1.getColumns();
        ColumnHandle column1InTable1 = (ColumnHandle)columns1.get(0);
        column1InTable1.setStringProperty("color", "aqua");
        SlotHandle columns2 = grid2.getColumns();
        int numOfColumnsInTable2 = columns2.getCount();
        int i = 0;
        while (i < numOfColumnsInTable2 - 1) {
            columns2.dropAndClear(0);
            ++i;
        }
        ColumnHandle columnInTable2 = (ColumnHandle)columns2.get(0);
        columnInTable2.setRepeatCount(3);
        GridColumnHandleTest.assertEquals((int)1, (int)columns2.getCount());
        ColumnBandData data = grid1.copyColumn(1);
        grid2.pasteColumn(data, 1, true);
        GridColumnHandleTest.assertEquals((int)2, (int)columns2.getCount());
        ColumnHandle column1InTable2 = (ColumnHandle)columns2.get(0);
        GridColumnHandleTest.assertEquals((Object)"aqua", (Object)column1InTable2.getProperty("color"));
        ColumnHandle column2InTable2 = (ColumnHandle)columns2.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)column2InTable2.getRepeatCount());
        GridColumnHandleTest.assertEquals((Object)"black", (Object)column2InTable2.getProperty("color"));
        numOfColumnsInTable2 = columns2.getCount();
        int i2 = 0;
        while (i2 < numOfColumnsInTable2 - 1) {
            columns2.dropAndClear(0);
            ++i2;
        }
        columnInTable2 = (ColumnHandle)columns2.get(0);
        columnInTable2.setRepeatCount(3);
        GridColumnHandleTest.assertEquals((int)1, (int)columns2.getCount());
        data = grid1.copyColumn(1);
        grid2.pasteColumn(data, 3, true);
        GridColumnHandleTest.assertEquals((int)2, (int)columns2.getCount());
        column1InTable2 = (ColumnHandle)columns2.get(0);
        GridColumnHandleTest.assertEquals((int)2, (int)column1InTable2.getRepeatCount());
        GridColumnHandleTest.assertEquals((Object)"black", (Object)column1InTable2.getProperty("color"));
        column2InTable2 = (ColumnHandle)columns2.get(1);
        GridColumnHandleTest.assertEquals((Object)"aqua", (Object)column2InTable2.getProperty("color"));
        numOfColumnsInTable2 = columns2.getCount();
        columns2.dropAndClear(1);
        columnInTable2 = (ColumnHandle)columns2.get(0);
        columnInTable2.setRepeatCount(3);
        GridColumnHandleTest.assertEquals((int)1, (int)columns2.getCount());
        data = grid1.copyColumn(1);
        grid2.pasteColumn(data, 2, true);
        GridColumnHandleTest.assertEquals((int)3, (int)columns2.getCount());
        column1InTable2 = (ColumnHandle)columns2.get(0);
        GridColumnHandleTest.assertEquals((int)1, (int)column1InTable2.getRepeatCount());
        GridColumnHandleTest.assertEquals((Object)"black", (Object)column1InTable2.getProperty("color"));
        column2InTable2 = (ColumnHandle)columns2.get(1);
        GridColumnHandleTest.assertEquals((int)1, (int)column2InTable2.getRepeatCount());
        GridColumnHandleTest.assertEquals((Object)"aqua", (Object)column2InTable2.getProperty("color"));
        ColumnHandle column3InTable2 = (ColumnHandle)columns2.get(2);
        GridColumnHandleTest.assertEquals((int)1, (int)column3InTable2.getRepeatCount());
        GridColumnHandleTest.assertEquals((Object)"black", (Object)column3InTable2.getProperty("color"));
    }

    public void copyPasteNonMergedCells2MergedCells() throws Exception {
        this.openDesign(this.fileName);
        GridHandle copyGrid = (GridHandle)this.designHandle.findElement("CopyGrid1");
        GridColumnHandleTest.assertNotNull((Object)copyGrid);
        GridHandle pasteGrid = (GridHandle)this.designHandle.findElement("PasteGrid1");
        GridColumnHandleTest.assertNotNull((Object)pasteGrid);
        SlotHandle detail = pasteGrid.getRows();
        RowHandle row1 = (RowHandle)detail.get(0);
        RowHandle row2 = (RowHandle)detail.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)1, (int)row2.getCells().getCount());
        CellHandle cell1 = (CellHandle)row1.getCells().get(0);
        GridColumnHandleTest.assertEquals((int)1, (int)cell1.getRowSpan());
        SlotHandle columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)2, (int)columns.getCount());
        ColumnHandle column2 = (ColumnHandle)columns.get(1);
        GridColumnHandleTest.assertEquals((String)"red", (String)column2.getStringProperty("color"));
        ColumnBandData data = copyGrid.copyColumn(1);
        try {
            pasteGrid.pasteColumn(data, 2, false);
            GridColumnHandleTest.fail();
        }
        catch (SemanticException e) {
            GridColumnHandleTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_DIFFERENT_LAYOUT", (String)e.getErrorCode());
        }
        pasteGrid.pasteColumn(data, 2, true);
        detail = pasteGrid.getRows();
        GridColumnHandleTest.assertEquals((int)2, (int)detail.getCount());
        row1 = (RowHandle)detail.get(0);
        row2 = (RowHandle)detail.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)2, (int)row2.getCells().getCount());
        cell1 = (CellHandle)row1.getCells().get(0);
        GridColumnHandleTest.assertEquals((int)2, (int)cell1.getRowSpan());
        columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)2, (int)columns.getCount());
        column2 = (ColumnHandle)columns.get(1);
        GridColumnHandleTest.assertEquals((String)"aqua", (String)column2.getStringProperty("color"));
        GridColumnHandleTest.assertEquals((int)1, (int)column2.getRepeatCount());
        ColumnHandle column1 = (ColumnHandle)columns.get(0);
        GridColumnHandleTest.assertEquals((String)"yellow", (String)column1.getStringProperty("color"));
        GridColumnHandleTest.assertEquals((int)1, (int)column2.getRepeatCount());
    }

    public void copyPasteMergedCells2NonMergedCells() throws Exception {
        this.openDesign(this.fileName);
        GridHandle copyGrid = (GridHandle)this.designHandle.findElement("CopyGrid1");
        GridColumnHandleTest.assertNotNull((Object)copyGrid);
        GridHandle pasteGrid = (GridHandle)this.designHandle.findElement("PasteGrid1");
        GridColumnHandleTest.assertNotNull((Object)pasteGrid);
        SlotHandle detail = pasteGrid.getRows();
        RowHandle row1 = (RowHandle)detail.get(0);
        RowHandle row2 = (RowHandle)detail.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)2, (int)row2.getCells().getCount());
        SlotHandle columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)1, (int)columns.getCount());
        ColumnHandle column1 = (ColumnHandle)columns.get(0);
        GridColumnHandleTest.assertEquals((int)2, (int)column1.getRepeatCount());
        GridColumnHandleTest.assertEquals((String)"aqua", (String)column1.getStringProperty("color"));
        ColumnBandData adapter = copyGrid.copyColumn(1);
        GridColumnHandleTest.assertEquals((int)2, (int)adapter.getCells().size());
        try {
            pasteGrid.pasteColumn(adapter, 2, false);
            GridColumnHandleTest.fail();
        }
        catch (SemanticException e) {
            GridColumnHandleTest.assertEquals((String)"Error.SemanticError.COLUMN_PASTE_DIFFERENT_LAYOUT", (String)e.getErrorCode());
        }
        pasteGrid.pasteColumn(adapter, 2, true);
        detail = pasteGrid.getRows();
        GridColumnHandleTest.assertEquals((int)2, (int)detail.getCount());
        row1 = (RowHandle)detail.get(0);
        row2 = (RowHandle)detail.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)1, (int)row2.getCells().getCount());
        CellHandle cell1 = (CellHandle)row1.getCells().get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)cell1.getRowSpan());
        GridColumnHandleTest.assertEquals((int)1, (int)cell1.getContent().getCount());
        columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)2, (int)columns.getCount());
        ColumnHandle column2 = (ColumnHandle)columns.get(1);
        GridColumnHandleTest.assertEquals((String)"yellow", (String)column2.getStringProperty("color"));
        GridColumnHandleTest.assertEquals((int)1, (int)column2.getRepeatCount());
        column1 = (ColumnHandle)columns.get(0);
        GridColumnHandleTest.assertEquals((String)"aqua", (String)column1.getStringProperty("color"));
        GridColumnHandleTest.assertEquals((int)1, (int)column2.getRepeatCount());
    }

    public void copyPasteWithUndoRedo() throws Exception {
        this.openDesign(this.fileName);
        GridHandle copyGrid = (GridHandle)this.designHandle.findElement("CopyGrid2");
        GridColumnHandleTest.assertNotNull((Object)copyGrid);
        GridHandle pasteGrid = (GridHandle)this.designHandle.findElement("PasteGrid2");
        GridColumnHandleTest.assertNotNull((Object)pasteGrid);
        SlotHandle detail = pasteGrid.getRows();
        RowHandle row1 = (RowHandle)detail.get(0);
        RowHandle row2 = (RowHandle)detail.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)2, (int)row2.getCells().getCount());
        SlotHandle columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)1, (int)columns.getCount());
        ColumnBandData data = copyGrid.copyColumn(1);
        pasteGrid.pasteColumn(data, 2, true);
        detail = pasteGrid.getRows();
        GridColumnHandleTest.assertEquals((int)2, (int)detail.getCount());
        row1 = (RowHandle)detail.get(0);
        row2 = (RowHandle)detail.get(1);
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)1, (int)row2.getCells().getCount());
        columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)2, (int)columns.getCount());
        this.design.getActivityStack().undo();
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)2, (int)row2.getCells().getCount());
        columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)1, (int)columns.getCount());
        this.design.getActivityStack().redo();
        GridColumnHandleTest.assertEquals((int)2, (int)row1.getCells().getCount());
        GridColumnHandleTest.assertEquals((int)1, (int)row2.getCells().getCount());
        columns = pasteGrid.getColumns();
        GridColumnHandleTest.assertEquals((int)2, (int)columns.getCount());
    }
}

