/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class GridItemHandleTest
extends BaseTestCase {
    private String fileName = "GridItemHandleTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(this.fileName);
    }

    public void testMethods() throws Exception {
        GridItemHandleTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("My grid");
        GridItemHandleTest.assertNotNull((Object)gridHandle);
        GridItemHandleTest.assertEquals((int)4, (int)gridHandle.getColumnCount());
        SlotHandle slotHandle = gridHandle.getColumns();
        GridItemHandleTest.assertEquals((int)2, (int)slotHandle.getCount());
        slotHandle = gridHandle.getRows();
        GridItemHandleTest.assertEquals((int)2, (int)slotHandle.getCount());
        gridHandle = (GridHandle)this.designHandle.findElement("My grid 1");
        GridItemHandleTest.assertEquals((int)5, (int)gridHandle.getColumnCount());
        slotHandle = gridHandle.getColumns();
        GridItemHandleTest.assertEquals((int)0, (int)slotHandle.getCount());
    }

    public void testRowCopyPasteAction() throws Exception {
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("My grid");
        GridHandle gridHandle2 = (GridHandle)this.designHandle.findElement("My grid 1");
        RowOperationParameters parameters1 = new RowOperationParameters(0, -1, 0);
        RowOperationParameters parameters2 = new RowOperationParameters(0, -1, 1);
        RowOperationParameters parameters3 = new RowOperationParameters(0, -1, 100);
        RowOperationParameters parameters4 = new RowOperationParameters(0, -1, -100);
        GridItemHandleTest.assertTrue((boolean)gridHandle.canCopyRow(parameters1));
        GridItemHandleTest.assertTrue((boolean)gridHandle.canCopyRow(parameters2));
        GridItemHandleTest.assertFalse((boolean)gridHandle.canCopyRow(parameters3));
        GridItemHandleTest.assertFalse((boolean)gridHandle.canCopyRow(parameters4));
        IDesignElement clonedData = gridHandle.copyRow(parameters1);
        TableRow clonedRow = (TableRow)clonedData.getHandle((Module)this.design).getElement();
        Cell cell = (Cell)clonedRow.getContentsSlot().get(0);
        Object obj = cell.getSlot(0).getContents().get(0);
        GridItemHandleTest.assertTrue((boolean)(obj instanceof Label));
        GridItemHandleTest.assertNull((Object)clonedRow.getContainer());
        try {
            gridHandle.copyRow(parameters3);
            GridItemHandleTest.fail((String)"fail to copy row");
        }
        catch (SemanticException e) {
            GridItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_COPY_FORBIDDEN", (String)e.getErrorCode());
        }
        GridItemHandleTest.assertTrue((boolean)gridHandle.canPasteRow(clonedData, parameters1));
        GridItemHandleTest.assertFalse((boolean)gridHandle.canPasteRow(clonedData, parameters3));
        GridItemHandleTest.assertFalse((boolean)gridHandle.canPasteRow(clonedData, parameters4));
        gridHandle.pasteRow(clonedData, parameters2);
        this.save();
        GridItemHandleTest.assertTrue((boolean)this.compareFile("GridRowCopy_golden_1.xml"));
        try {
            gridHandle2.pasteRow(null, parameters1);
            GridItemHandleTest.fail((String)"fail to paste table row in grid because copied row is null");
        }
        catch (IllegalArgumentException e) {
            GridItemHandleTest.assertEquals((String)"empty row to paste.", (String)e.getMessage());
        }
        clonedData = (IDesignElement)clonedData.clone();
        GridItemHandleTest.assertTrue((boolean)gridHandle2.canInsertRow(parameters1));
        GridItemHandleTest.assertFalse((boolean)gridHandle2.canInsertRow(parameters2));
        GridItemHandleTest.assertFalse((boolean)gridHandle2.canInsertRow(parameters3));
        try {
            gridHandle2.insertRow(parameters2);
            GridItemHandleTest.fail((String)"fail to insert table row");
        }
        catch (SemanticException e) {
            GridItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_INSERT_FORBIDDEN", (String)e.getErrorCode());
        }
        gridHandle2.insertRow(parameters1);
        gridHandle2.insertRow(parameters1);
        this.save();
        GridItemHandleTest.assertTrue((boolean)this.compareFile("GridRowCopy_golden_2.xml"));
        parameters2.setSourceIndex(0);
        GridItemHandleTest.assertTrue((boolean)gridHandle.canShiftRow(parameters2));
        parameters1.setSourceIndex(1);
        GridItemHandleTest.assertTrue((boolean)gridHandle.canShiftRow(parameters1));
        parameters1.setSourceIndex(0);
        GridItemHandleTest.assertFalse((boolean)gridHandle.canShiftRow(parameters1));
        try {
            gridHandle.shiftRow(parameters1);
            GridItemHandleTest.fail((String)"fail to shift table row");
        }
        catch (SemanticException e) {
            GridItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_SHIFT_FORBIDDEN", (String)e.getErrorCode());
        }
        parameters1.setSourceIndex(1);
        gridHandle.shiftRow(parameters1);
        this.save();
        GridItemHandleTest.assertTrue((boolean)this.compareFile("GridRowCopy_golden_3.xml"));
        clonedData = (IDesignElement)clonedData.clone();
        GridItemHandleTest.assertTrue((boolean)gridHandle.canInsertAndPasteRow(clonedData, parameters2));
        GridItemHandleTest.assertFalse((boolean)gridHandle.canInsertAndPasteRow(clonedData, parameters3));
        try {
            gridHandle.insertAndPasteRow(clonedData, parameters3);
            GridItemHandleTest.fail((String)"fail to insert and paste table row");
        }
        catch (SemanticException e) {
            GridItemHandleTest.assertEquals((String)"Error.SemanticError.ROW_INSERTANDPASTE_FORBIDDEN", (String)e.getErrorCode());
        }
        gridHandle.insertAndPasteRow(clonedData, parameters2);
        this.save();
        GridItemHandleTest.assertTrue((boolean)this.compareFile("GridRowCopy_golden_4.xml"));
    }

    public void testGetCell() {
        GridItemHandleTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("My grid");
        GridItemHandleTest.assertNotNull((Object)gridHandle);
        gridHandle = (GridHandle)this.designHandle.findElement("My grid");
        GridItemHandleTest.assertEquals((int)2, (int)gridHandle.getRows().getCount());
        GridItemHandleTest.assertEquals((int)4, (int)gridHandle.getColumnCount());
        SlotHandle rows = gridHandle.getRows();
        RowHandle row1 = (RowHandle)rows.get(0);
        RowHandle row2 = (RowHandle)rows.get(1);
        CellHandle cell_11 = (CellHandle)row1.getCells().get(0);
        GridItemHandleTest.assertEquals((int)1, (int)cell_11.getColumnSpan());
        GridItemHandleTest.assertEquals((int)1, (int)cell_11.getRowSpan());
        CellHandle cell_12 = (CellHandle)row1.getCells().get(1);
        GridItemHandleTest.assertEquals((int)3, (int)cell_12.getColumnSpan());
        GridItemHandleTest.assertEquals((int)1, (int)cell_12.getRowSpan());
        CellHandle cell_21 = (CellHandle)row2.getCells().get(0);
        GridItemHandleTest.assertEquals((int)4, (int)cell_21.getColumnSpan());
        GridItemHandleTest.assertEquals((int)1, (int)cell_21.getRowSpan());
        GridItemHandleTest.assertNull((Object)gridHandle.getCell(1, 5));
        GridItemHandleTest.assertNull((Object)gridHandle.getCell(3, 1));
        GridItemHandleTest.assertNull((Object)gridHandle.getCell(3, 5));
        GridItemHandleTest.assertEquals((Object)cell_11, (Object)gridHandle.getCell(1, 1));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 2));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 3));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 4));
        GridItemHandleTest.assertEquals((Object)cell_21, (Object)gridHandle.getCell(2, 1));
        GridItemHandleTest.assertEquals((Object)cell_21, (Object)gridHandle.getCell(2, 2));
        GridItemHandleTest.assertEquals((Object)cell_21, (Object)gridHandle.getCell(2, 3));
        GridItemHandleTest.assertEquals((Object)cell_21, (Object)gridHandle.getCell(2, 4));
        gridHandle = (GridHandle)this.designHandle.findElement("My grid 1");
        GridItemHandleTest.assertEquals((int)2, (int)gridHandle.getRows().getCount());
        GridItemHandleTest.assertEquals((int)5, (int)gridHandle.getColumnCount());
        rows = gridHandle.getRows();
        row1 = (RowHandle)rows.get(0);
        row2 = (RowHandle)rows.get(1);
        cell_11 = (CellHandle)row1.getCells().get(0);
        GridItemHandleTest.assertEquals((int)1, (int)cell_11.getColumnSpan());
        GridItemHandleTest.assertEquals((int)2, (int)cell_11.getRowSpan());
        cell_12 = (CellHandle)row1.getCells().get(1);
        GridItemHandleTest.assertEquals((int)4, (int)cell_12.getColumnSpan());
        GridItemHandleTest.assertEquals((int)1, (int)cell_12.getRowSpan());
        cell_21 = (CellHandle)row2.getCells().get(0);
        GridItemHandleTest.assertEquals((int)2, (int)cell_21.getColumnSpan());
        GridItemHandleTest.assertEquals((int)1, (int)cell_21.getRowSpan());
        GridItemHandleTest.assertNull((Object)gridHandle.getCell(1, 6));
        GridItemHandleTest.assertNull((Object)gridHandle.getCell(3, 1));
        GridItemHandleTest.assertNull((Object)gridHandle.getCell(3, 6));
        GridItemHandleTest.assertEquals((Object)cell_11, (Object)gridHandle.getCell(1, 1));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 2));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 3));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 4));
        GridItemHandleTest.assertEquals((Object)cell_12, (Object)gridHandle.getCell(1, 5));
        GridItemHandleTest.assertEquals((Object)cell_11, (Object)gridHandle.getCell(2, 1));
        GridItemHandleTest.assertEquals((Object)cell_21, (Object)gridHandle.getCell(2, 2));
        GridItemHandleTest.assertEquals((Object)cell_21, (Object)gridHandle.getCell(2, 3));
        GridItemHandleTest.assertEquals(null, (Object)gridHandle.getCell(2, 4));
        GridItemHandleTest.assertEquals(null, (Object)gridHandle.getCell(2, 5));
    }
}

