/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ImageHandleTest
extends BaseTestCase {
    ImageHandle fileImage;
    ImageHandle exprImage;
    ImageHandle urlImage;

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ImageItemHandleTest.xml");
        ImageHandleTest.assertNotNull((Object)this.designHandle);
        this.fileImage = (ImageHandle)this.designHandle.findElement("Image1");
        ImageHandleTest.assertEquals((String)"file", (String)this.fileImage.getSource());
        this.exprImage = (ImageHandle)this.designHandle.findElement("Image3");
        ImageHandleTest.assertEquals((String)"expr", (String)this.exprImage.getSource());
        this.urlImage = (ImageHandle)this.designHandle.findElement("Image6");
        ImageHandleTest.assertEquals((String)"url", (String)this.urlImage.getSource());
    }

    public void testSearchFile() throws Exception {
        ImageHandleTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        ImageHandleTest.assertEquals((int)1, (int)this.designHandle.getWarningList().size());
        ImageHandleTest.assertEquals((int)0, (int)this.designHandle.getErrorList().size());
        ImageHandleTest.assertEquals((String)"image2.jpg", (String)this.fileImage.getURI());
        ImageHandleTest.assertTrue((boolean)this.fileImage.isValid());
    }

    public void testChangeImageType() throws SemanticException {
        ImageHandleTest.assertEquals((String)"Image1", (String)this.fileImage.getName());
        String refType = this.fileImage.getSource();
        ImageHandleTest.assertEquals((String)"file", (String)refType);
        this.fileImage.setImageName("ImageName.jpg");
        ImageHandleTest.assertEquals((String)"ImageName.jpg", (String)this.fileImage.getImageName());
        ImageHandleTest.assertEquals((String)"embed", (String)this.fileImage.getSource());
        refType = this.exprImage.getSource();
        ImageHandleTest.assertEquals((String)"expr", (String)refType);
        this.exprImage.setImageName("newName.jpg");
        refType = this.exprImage.getSource();
        ImageHandleTest.assertEquals((String)"embed", (String)refType);
        this.urlImage.setURL("file:///c:\\logo.gif");
        ImageHandleTest.assertEquals((String)"url", (String)this.urlImage.getSource());
        ImageHandleTest.assertEquals((String)"file:///c:\\logo.gif", (String)this.urlImage.getURI());
    }

    public void testSetImageProperties() throws Exception {
        this.fileImage.setImageName("hello noway.jpg");
        this.exprImage.setValueExpression("newExpression");
        ImageHandleTest.assertEquals((String)"newExpression", (String)this.exprImage.getValueExpression());
        this.exprImage.setValueExpression(null);
        ImageHandle image = (ImageHandle)this.designHandle.findMasterPage("My Page").getSlot(0).get(5);
        ImageHandleTest.assertNotNull((Object)image);
        ImageHandleTest.assertEquals((String)"file", (String)image.getSource());
        image.setHeight("99999mm");
        ImageHandleTest.assertEquals((String)"99999mm", (String)image.getHeight().getStringValue());
        ImageHandleTest.assertEquals((String)"mm", (String)image.getHeight().getUnits());
        image.setWidth("10mm");
        ImageHandleTest.assertEquals((String)"10mm", (String)image.getWidth().getStringValue());
        image.setSize("scale-to-item");
        ImageHandleTest.assertEquals((String)"scale-to-item", (String)image.getStringProperty("size"));
        image.setScale(0.1);
        image.setName("newNameIgmage4");
        Style style = new Style();
        style.getHandle((Module)this.design).setName("testStyle");
        try {
            image.setStyle((SharedStyleHandle)style.getHandle((Module)this.design));
            ImageHandleTest.fail();
        }
        catch (StyleException se) {
            ImageHandleTest.assertEquals((String)"Error.StyleException.NOT_FOUND", (String)se.getErrorCode());
            System.out.println(se.getMessage());
        }
        try {
            image.setStyleElement((StyleElement)style);
            ImageHandleTest.fail();
        }
        catch (StyleException se) {
            ImageHandleTest.assertEquals((String)"Error.StyleException.NOT_FOUND", (String)se.getErrorCode());
        }
        image.setStyleName("My-Style");
        ImageHandleTest.assertEquals((String)"My-Style", (String)image.getStyle().getName());
        image.setBookmark("bookMark");
        ImageHandleTest.assertEquals((String)"bookMark", (String)image.getBookmark());
        image.setX("100mm");
        ImageHandleTest.assertEquals((String)"100mm", (String)image.getX().getStringValue());
        image.setY("1009mm");
        ImageHandleTest.assertEquals((String)"1009mm", (String)image.getY().getStringValue());
        image.setProperty("altTextID", (Object)"alt key");
        ImageHandleTest.assertEquals((String)"alt key", (String)image.getAltTextKey());
        image.setProperty("altText", (Object)"alt text");
        ImageHandleTest.assertEquals((String)"alt text", (String)image.getAltText());
        String uri = image.getURI();
        image.setFile("C:\\image.jsp");
        ImageHandleTest.assertEquals((String)"file", (String)image.getSource());
        ImageHandleTest.assertEquals((String)"C:\\image.jsp", (String)image.getURI());
        image.setURL(uri);
        ImageHandleTest.assertEquals((String)"url", (String)image.getSource());
        Expression expr = new Expression((Object)"C:\\image.jsp", null);
        image.setFile(expr);
        ImageHandleTest.assertEquals((String)"file", (String)image.getSource());
        ImageHandleTest.assertEquals((String)"C:\\image.jsp", (String)image.getURI());
        image.setURL(expr);
        ImageHandleTest.assertEquals((String)"url", (String)image.getSource());
        ImageHandleTest.assertEquals((String)"C:\\image.jsp", (String)image.getURI());
    }

    public void testGetImageProperties() {
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findMasterPage("My Page").getSlot(0).get(5);
        ImageHandleTest.assertNotNull((Object)imageHandle);
        ImageHandleTest.assertEquals((String)"file", (String)imageHandle.getSource());
        ActionHandle action = this.fileImage.getActionHandle();
        ImageHandleTest.assertNotNull((Object)action);
        ImageHandleTest.assertEquals((Object)this.fileImage, (Object)action.getElementHandle());
        IChoice[] choiceList = this.fileImage.getChoices("size");
        ImageHandleTest.assertEquals((int)3, (int)choiceList.length);
        ImageHandleTest.assertNotNull((Object)this.fileImage.getColorProperty("backgroundColor"));
        ImageHandleTest.assertEquals((Object)"green", (Object)this.fileImage.getExtends().getProperty("backgroundColor"));
        ImageHandleTest.assertEquals((String)"newImage", (String)this.fileImage.getExtends().getName());
        ImageHandleTest.assertEquals((Object)this.design.findPage("My Page"), (Object)this.fileImage.getContainer());
        ImageHandleTest.assertEquals((int)0, (int)this.fileImage.getContainerSlotHandle().getSlotID());
        DimensionHandle dh = this.fileImage.getDimensionProperty("width");
        ImageHandleTest.assertNotNull((Object)dh);
        dh = this.fileImage.getHeight();
        ImageHandleTest.assertNotNull((Object)dh);
        ImageHandleTest.assertEquals((String)"Image1", (String)this.fileImage.getDisplayLabel());
        ImageHandleTest.assertEquals((Object)this.designHandle.getComponents().get(0), (Object)this.fileImage.getExtends());
    }

    public void testGetImageName() {
        GridHandle myGrid1 = (GridHandle)this.designHandle.findElement("myGrid1");
        CellHandle cell1 = (CellHandle)((RowHandle)myGrid1.getRows().get(0)).getCells().get(0);
        ImageHandle imageHandle = (ImageHandle)cell1.getContent().get(0);
        ImageHandleTest.assertEquals((String)"A_001.jpg", (String)imageHandle.getImageName());
        GridHandle myGrid2 = (GridHandle)this.designHandle.findElement("myGrid2");
        RowHandle row2 = (RowHandle)myGrid2.getRows().get(0);
        CellHandle cell2 = (CellHandle)row2.getCells().get(0);
        imageHandle = (ImageHandle)cell2.getContent().get(0);
        ImageHandleTest.assertEquals((String)"Lib2.002.jpg", (String)imageHandle.getImageName());
    }

    public void testGetSource() throws DesignFileException {
        this.openDesign("ImageItemHandleTest_1.xml");
        ImageHandle image = (ImageHandle)this.designHandle.findElement("Image");
        ImageHandleTest.assertEquals((String)"file", (String)image.getSource());
        this.designHandle.close();
        this.designHandle = null;
    }
}

