/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LabelHandleTest
extends BaseTestCase {
    private static final String INPUT_FILE = "LabelHandleTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(INPUT_FILE);
    }

    public void testGetDisplayText() {
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("label1");
        ThreadResources.setLocale((ULocale)ULocale.US);
        LabelHandleTest.assertEquals((String)"en_US", (String)label1.getDisplayText());
        ThreadResources.setLocale((ULocale)new ULocale("en"));
        LabelHandleTest.assertEquals((String)"en", (String)label1.getDisplayText());
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("label2");
        LabelHandleTest.assertEquals((String)"label2", (String)label2.getDisplayText());
        LabelHandle label3 = (LabelHandle)this.designHandle.findElement("label3");
        LabelHandleTest.assertEquals((String)"label3", (String)label3.getDisplayText());
        LabelHandle label4 = (LabelHandle)this.designHandle.findElement("label4");
        ThreadResources.setLocale((ULocale)ULocale.US);
        LabelHandleTest.assertEquals((String)"label4", (String)label4.getDisplayText());
    }

    public void testSetGetProperties() throws SemanticException {
        ElementFactory factory = new ElementFactory((Module)this.design);
        LabelHandle label = factory.newLabel("label1");
        label.setText("  Hello,\n  There is...   ");
        LabelHandleTest.assertEquals((String)"  Hello,\n  There is...   ", (String)label.getText());
        label.setText("");
        LabelHandleTest.assertEquals((String)"", (String)label.getText());
        label.setProperty("fontSize", (Object)"");
        LabelHandleTest.assertEquals(null, (String)label.getStringProperty("medium"));
        label.setHeight("100000000000000000000000000000000pt");
        LabelHandleTest.assertEquals((String)"100000000000000000000000000000000pt", (String)label.getHeight().getStringValue());
        LabelHandle label5 = factory.newLabel("label5");
        this.designHandle.getBody().add((DesignElementHandle)label5);
        LabelHandleTest.assertEquals((Object)"normal", (Object)label5.getProperty("fontStyle"));
        SharedStyleHandle reportSelector = factory.newStyle("report");
        reportSelector.setFontStyle("italic");
        this.designHandle.getStyles().add((DesignElementHandle)reportSelector);
        LabelHandleTest.assertEquals((Object)"italic", (Object)label5.getProperty("fontStyle"));
    }

    public void testGetLocalizationMessage() {
        LabelHandle handle10 = (LabelHandle)this.designHandle.findElement("label10");
        LabelHandleTest.assertEquals((String)"", (String)handle10.getDisplayText());
        LabelHandleTest.assertNull((Object)handle10.getRoot().getMessage(handle10.getTextKey()));
        LabelHandle handle11 = (LabelHandle)this.designHandle.findElement("label11");
        LabelHandleTest.assertEquals((String)"label in i18n", (String)handle11.getDisplayText());
        LabelHandleTest.assertEquals((String)"label in i18n", (String)handle11.getRoot().getMessage(handle11.getTextKey()));
        LabelHandle handle12 = (LabelHandle)this.designHandle.findElement("label12");
        LabelHandleTest.assertEquals((String)"", (String)handle12.getRoot().getMessage(handle12.getTextKey()));
        LabelHandle handle15 = (LabelHandle)this.designHandle.findElement("label15");
        LabelHandleTest.assertEquals((String)"label_localized", (String)handle15.getDisplayText());
        LabelHandleTest.assertNull((Object)handle15.getRoot().getMessage(handle15.getTextKey()));
        LabelHandle handle16 = (LabelHandle)this.designHandle.findElement("label16");
        LabelHandleTest.assertEquals((String)"actuate", (String)handle16.getDisplayText());
        LabelHandleTest.assertEquals((String)"actuate", (String)handle16.getRoot().getMessage(handle16.getTextKey()));
    }

    public void testBaseIdLocalizationMessage() throws Exception {
        if (this.designHandle != null) {
            this.designHandle.close();
        }
        if (this.libraryHandle != null) {
            this.libraryHandle.close();
        }
        this.openDesign("LabelHandleTest_1.xml");
        LabelHandle handle = (LabelHandle)this.designHandle.findElement("NewLabel");
        LabelHandleTest.assertEquals((String)"actuate", (String)handle.getDisplayText());
    }
}

