/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ReportElementHandleTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ReportElementHandleTest.xml");
    }

    public void testPropertyMaskFromPropertyHandle() throws Exception {
        List list = this.designHandle.getErrorList();
        ReportElementHandleTest.assertEquals((int)2, (int)list.size());
        ReportElementHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
        ReportElementHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)((ErrorDetail)list.get(0)).getErrorCode());
        LabelHandle handle = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        int count = 0;
        Iterator iterator = handle.propertyMaskIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        ReportElementHandleTest.assertEquals((int)5, (int)count);
        PropertyHandle propHandle = handle.getPropertyHandle("propertyMasks");
        StructureHandle structHandle = propHandle.getAt(0);
        MemberHandle memberHandle = structHandle.getMember("mask");
        ReportElementHandleTest.assertEquals((String)"lock", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementHandleTest.assertEquals((String)"text", (String)memberHandle.getStringValue());
        structHandle = propHandle.getAt(1);
        memberHandle = structHandle.getMember("mask");
        ReportElementHandleTest.assertEquals((String)"lock", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementHandleTest.assertEquals((String)"extends", (String)memberHandle.getStringValue());
        structHandle = propHandle.getAt(4);
        memberHandle = structHandle.getMember("mask");
        ReportElementHandleTest.assertEquals((String)"hide", (String)memberHandle.getStringValue());
        memberHandle = structHandle.getMember("name");
        ReportElementHandleTest.assertNull((Object)memberHandle.getStringValue());
        structHandle = propHandle.getAt(0);
        memberHandle = structHandle.getMember("mask");
        memberHandle.setValue((Object)"change");
        ReportElementHandleTest.assertEquals((String)"change", (String)memberHandle.getStringValue());
        handle = (LabelHandle)this.designHandle.findElement("child1");
        count = 0;
        Iterator iterator2 = handle.propertyMaskIterator();
        while (iterator2.hasNext()) {
            ++count;
            iterator2.next();
        }
        ReportElementHandleTest.assertEquals((int)5, (int)count);
    }

    public void testPropertyMaskOnProperty() throws Exception {
        LabelHandle bodyLabelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        ReportElementHandleTest.assertEquals((String)"lock", (String)bodyLabelHandle.getPropertyMask("text"));
        ReportElementHandleTest.assertEquals((String)"lock", (String)bodyLabelHandle.getPropertyMask("extends"));
        ReportElementHandleTest.assertEquals((String)"hide", (String)bodyLabelHandle.getPropertyMask("textID"));
        ReportElementHandleTest.assertEquals((String)"lock", (String)bodyLabelHandle.getPropertyMask("height"));
        ReportElementHandleTest.assertNull((Object)bodyLabelHandle.getPropertyMask("content"));
        LabelHandle childLabelHandle = (LabelHandle)this.designHandle.findElement("child1");
        ReportElementHandleTest.assertEquals((String)"hide", (String)childLabelHandle.getPropertyMask("text"));
        ReportElementHandleTest.assertEquals((String)"change", (String)childLabelHandle.getPropertyMask("extends"));
        ReportElementHandleTest.assertEquals((String)"lock", (String)childLabelHandle.getPropertyMask("height"));
        childLabelHandle.setPropertyMask("height", "change");
        ReportElementHandleTest.assertEquals((String)"change", (String)bodyLabelHandle.getPropertyMask("height"));
        childLabelHandle.setPropertyMask("height", null);
        ReportElementHandleTest.assertEquals((String)"lock", (String)bodyLabelHandle.getPropertyMask("height"));
        try {
            childLabelHandle.setProperty("height", (Object)"12pc");
            ReportElementHandleTest.fail();
        }
        catch (PropertyValueException e) {
            ReportElementHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_LOCKED", (String)e.getErrorCode());
        }
        bodyLabelHandle.setPropertyMask("height", "change");
        bodyLabelHandle.setProperty("height", (Object)"12pc");
        ReportElementHandleTest.assertEquals((String)"12pc", (String)bodyLabelHandle.getStringProperty("height"));
        bodyLabelHandle.setPropertyMask("height", "hide");
        bodyLabelHandle.setProperty("height", (Object)"2pc");
        ReportElementHandleTest.assertEquals((String)"2pc", (String)bodyLabelHandle.getStringProperty("height"));
        bodyLabelHandle.setPropertyMask("height", "lock");
        ReportElementHandleTest.assertEquals((String)"2pc", (String)bodyLabelHandle.getStringProperty("height"));
        bodyLabelHandle.setPropertyMask("height", "hide");
        LabelHandle baseHandle = (LabelHandle)this.designHandle.findElement("base");
        ReportElementHandleTest.assertEquals((String)"lock", (String)baseHandle.getPropertyMask("height"));
        ReportElementHandleTest.assertEquals((String)"lock", (String)childLabelHandle.getPropertyMask("height"));
    }

    public void testPropertyMaskOnMethod() throws SemanticException {
        LabelHandle bodyLabelHandle = (LabelHandle)this.designHandle.findElement("bodyLabel1");
        LabelHandle childLabelHandle = (LabelHandle)this.designHandle.findElement("child1");
        ReportElementHandleTest.assertEquals((String)"hello, show me on create.", (String)bodyLabelHandle.getOnCreate());
        ReportElementHandleTest.assertEquals((String)"hello, show me on render.", (String)bodyLabelHandle.getOnRender());
        childLabelHandle.setOnCreate("new create script");
        try {
            childLabelHandle.setOnRender("new render script");
            ReportElementHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportElementHandleTest.assertEquals((String)"Error.PropertyValueException.VALUE_LOCKED", (String)e.getErrorCode());
        }
    }

    public void testPropertyMaskOnListGroup() {
        ListHandle listHandle = (ListHandle)this.designHandle.findElement("first list");
        SlotHandle groupSlot = listHandle.getSlot(1);
        ListGroupHandle group = (ListGroupHandle)groupSlot.get(0);
        try {
            group.setPropertyMask("interval", "lock");
            ReportElementHandleTest.fail();
        }
        catch (SemanticException e) {
            ReportElementHandleTest.assertEquals((String)"Error.PropertyNameException.PROPERTY_NOT_VALID", (String)e.getErrorCode());
            ReportElementHandleTest.assertEquals((Object)"group1", (Object)e.getElement().getLocalProperty((Module)this.design, "groupName"));
        }
    }

    public void testIsValidLayout() throws Exception {
        this.openDesign("ReportElementHandleTest_isValidLayout.xml");
        GridHandle gridHandle = (GridHandle)this.designHandle.getBody().get(0);
        ReportElementHandleTest.assertFalse((boolean)ModelUtil.isValidLayout((Module)this.designHandle.getModule(), (DesignElement)gridHandle.getElement()));
        gridHandle.getSlot(0).drop(0);
        ReportElementHandleTest.assertTrue((boolean)ModelUtil.isValidLayout((Module)this.designHandle.getModule(), (DesignElement)gridHandle.getElement()));
    }
}

