/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportItemDataRefTest
extends BaseTestCase {
    private static final String FILE_NAME = "ReportItemDataRefTest.xml";
    private static final String FILE_NAME_1 = "ReportItemDataRefTest_1.xml";

    public void testDataBindingRef() throws Exception {
        this.openDesign("ReportItemHandleTest_2.xml");
        DataItemHandle data1 = (DataItemHandle)this.designHandle.findElement("myData1");
        Iterator columns = data1.columnBindingsIterator();
        ComputedColumnHandle column = (ComputedColumnHandle)columns.next();
        this.verifyColumnValues(column);
        DataItemHandle data2 = (DataItemHandle)this.designHandle.findElement("myData2");
        columns = data2.columnBindingsIterator();
        column = (ComputedColumnHandle)columns.next();
        this.verifyColumnValues(column);
        ReportItemDataRefTest.assertEquals((String)"myData1", (String)data2.getDataBindingReferenceName());
        DataItemHandle newData = (DataItemHandle)this.designHandle.findElement("myData3");
        newData.setDataBindingReference((ReportItemHandle)data2);
        columns = newData.columnBindingsIterator();
        column = (ComputedColumnHandle)columns.next();
        this.verifyColumnValues(column);
        try {
            newData.setDataBindingReference((ReportItemHandle)newData);
            ReportItemDataRefTest.fail();
        }
        catch (SemanticException e) {
            ReportItemDataRefTest.assertEquals((String)"Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE", (String)e.getErrorCode());
        }
        try {
            data1.setDataBindingReference((ReportItemHandle)data2);
            ReportItemDataRefTest.fail();
        }
        catch (SemanticException e) {
            ReportItemDataRefTest.assertEquals((String)"Error.SemanticError.CIRCULAR_ELEMENT_REFERNECE", (String)e.getErrorCode());
        }
        Iterator paramBindings = data2.paramBindingsIterator();
        ParamBindingHandle paramBinding = (ParamBindingHandle)paramBindings.next();
        ReportItemDataRefTest.assertEquals((String)"table value1", (String)paramBinding.getExpression());
        TableHandle table2 = (TableHandle)this.designHandle.findElement("myTable2");
        Iterator filters = table2.filtersIterator();
        FilterConditionHandle filter = (FilterConditionHandle)filters.next();
        ReportItemDataRefTest.assertEquals((String)"table 1 filter expression", (String)filter.getExpr());
        Iterator sorts = table2.sortsIterator();
        SortKeyHandle sort = (SortKeyHandle)sorts.next();
        ReportItemDataRefTest.assertEquals((String)"table 1 name", (String)sort.getKey());
    }

    public void testgetAvailableDataBindingReferenceList() throws Exception {
        this.openDesign("ReportItemHandleBindingDataTypeTest.xml");
        TextItemHandle text = (TextItemHandle)this.designHandle.findElement("myText");
        ReportItemDataRefTest.assertEquals((int)1, (int)text.getDataBindingType());
        List tmpList = text.getAvailableCubeBindingReferenceList();
        ReportItemDataRefTest.assertEquals((int)5, (int)tmpList.size());
        ReportItemDataRefTest.assertNull((Object)((ReportItemHandle)tmpList.get(4)).getName());
        ReportItemDataRefTest.assertEquals((int)4, (int)text.getNamedCubeBindingReferenceList().size());
        tmpList = text.getAvailableDataSetBindingReferenceList();
        ReportItemDataRefTest.assertEquals((int)7, (int)tmpList.size());
        ReportItemDataRefTest.assertNull((Object)((ReportItemHandle)tmpList.get(6)).getName());
        tmpList = text.getAvailableDataBindingReferenceList();
        ReportItemDataRefTest.assertEquals((int)10, (int)tmpList.size());
        ReportItemDataRefTest.assertEquals((int)6, (int)text.getNamedDataSetBindingReferenceList().size());
        ListHandle list = (ListHandle)this.designHandle.findElement("my list");
        ReportItemDataRefTest.assertEquals((int)1, (int)list.getDataBindingType());
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)this.designHandle.findElement("ex1");
        ReportItemDataRefTest.assertEquals((int)1, (int)extendedItem.getDataBindingType());
        TableHandle table = (TableHandle)this.designHandle.findElement("table");
        ReportItemDataRefTest.assertEquals((int)2, (int)table.getDataBindingType());
        DataItemHandle data = (DataItemHandle)this.designHandle.findElement("data1");
        ReportItemDataRefTest.assertEquals((int)0, (int)data.getDataBindingType());
        PropertyHandle propHandle = list.getPropertyHandle("dataBindingRef");
        List handleList = propHandle.getReferenceableElementList();
        ReportItemDataRefTest.assertEquals((int)7, (int)handleList.size());
        ReportItemDataRefTest.assertEquals((String)"myText", (String)((DesignElementHandle)handleList.get(0)).getName());
        ReportItemDataRefTest.assertEquals((String)"ex1", (String)((DesignElementHandle)handleList.get(1)).getName());
        ReportItemDataRefTest.assertEquals((String)"table", (String)((DesignElementHandle)handleList.get(2)).getName());
        ReportItemDataRefTest.assertEquals((String)"table2", (String)((DesignElementHandle)handleList.get(3)).getName());
        ReportItemDataRefTest.assertEquals((String)"data1", (String)((DesignElementHandle)handleList.get(4)).getName());
        ReportItemDataRefTest.assertEquals((String)"table5", (String)((DesignElementHandle)handleList.get(5)).getName());
        ReportItemDataRefTest.assertEquals((String)"data2", (String)((DesignElementHandle)handleList.get(6)).getName());
    }

    private void verifyColumnValues(ComputedColumnHandle column) {
        ReportItemDataRefTest.assertEquals((String)"CUSTOMERNUMBER", (String)column.getName());
        ReportItemDataRefTest.assertEquals((String)"dataSetRow[\"CUSTOMERNUMBER\"]", (String)column.getExpression());
        ReportItemDataRefTest.assertEquals((String)"integer", (String)column.getDataType());
    }

    public void testPropsOfDataGroupRef() throws Exception {
        this.openDesign(FILE_NAME);
        TableHandle table2 = (TableHandle)this.designHandle.findElement("myTable2");
        TableGroupHandle group2 = (TableGroupHandle)table2.getGroups().get(0);
        ReportItemDataRefTest.assertEquals((String)"row[\"CUSTOMERNAME\"]", (String)group2.getKeyExpr());
        ReportItemDataRefTest.assertEquals((String)"group1", (String)group2.getName());
        ReportItemDataRefTest.assertEquals((String)"group1", (String)group2.getDisplayLabel());
        Iterator iter1 = group2.filtersIterator();
        FilterConditionHandle filter = (FilterConditionHandle)iter1.next();
        ReportItemDataRefTest.assertEquals((String)"table 1 filter expression", (String)filter.getExpr());
        ReportItemDataRefTest.assertEquals((String)"lt", (String)filter.getOperator());
        iter1 = group2.sortsIterator();
        SortKeyHandle sort = (SortKeyHandle)iter1.next();
        ReportItemDataRefTest.assertEquals((String)"table 1 name", (String)sort.getKey());
        ReportItemDataRefTest.assertEquals((String)"asc", (String)sort.getDirection());
        TableHandle table1 = (TableHandle)this.designHandle.findElement("myTable1");
        TableGroupHandle group1 = (TableGroupHandle)table1.getGroups().get(0);
        group1.setKeyExpr("the new expression");
        ReportItemDataRefTest.assertEquals((String)"the new expression", (String)group2.getKeyExpr());
        group1.setName("newGroup1");
        ReportItemDataRefTest.assertEquals((String)"newGroup1", (String)group2.getDisplayLabel());
        ListHandle list1 = (ListHandle)this.designHandle.findElement("myList1");
        ListGroupHandle listGroup = (ListGroupHandle)list1.getGroups().get(0);
        ReportItemDataRefTest.assertEquals((String)"the new expression", (String)listGroup.getKeyExpr());
        ReportItemDataRefTest.assertEquals((String)"newGroup1", (String)listGroup.getName());
        ReportItemDataRefTest.assertEquals((String)"newGroup1", (String)listGroup.getDisplayLabel());
        iter1 = listGroup.filtersIterator();
        filter = (FilterConditionHandle)iter1.next();
        ReportItemDataRefTest.assertEquals((String)"table 1 filter expression", (String)filter.getExpr());
        ReportItemDataRefTest.assertEquals((String)"lt", (String)filter.getOperator());
    }

    public void testAddandRemoveDataGroup() throws Exception {
        this.openDesign(FILE_NAME);
        TableHandle table1 = (TableHandle)this.designHandle.findElement("myTable1");
        TableGroupHandle newGroup = this.designHandle.getElementFactory().newTableGroup();
        table1.addElement((DesignElementHandle)newGroup, 1);
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("DataGroupAdded_golden.xml"));
        newGroup.drop();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("DataGroupDropped_golden.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("DataGroupUndoDrop_golden.xml"));
        newGroup.getContainerSlotHandle().shift((DesignElementHandle)newGroup, 0);
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("DataGroupShiftPosition_golden.xml"));
    }

    public void testCanMumbleForDataGroup() throws Exception {
        this.openDesign(FILE_NAME);
        TableHandle table2 = (TableHandle)this.designHandle.findElement("myTable2");
        TableGroupHandle group2 = (TableGroupHandle)table2.getGroups().get(0);
        ReportItemDataRefTest.assertFalse((boolean)group2.canDrop());
        ReportItemDataRefTest.assertTrue((boolean)group2.canContain(0, "Row"));
        ReportItemDataRefTest.assertFalse((boolean)table2.canContain(1, (DesignElementHandle)this.designHandle.getElementFactory().newTableGroup()));
        ReportItemDataRefTest.assertFalse((boolean)table2.canContain(1, group2.getDefn().getName()));
        ReportItemDataRefTest.assertTrue((boolean)group2.canContain(1, "Row"));
    }

    public void testEstablishDataGroup() throws Exception {
        this.openDesign("DataGroupRef_2.xml");
        TableHandle table2 = (TableHandle)this.designHandle.findElement("myTable2");
        TableHandle table1 = (TableHandle)this.designHandle.findElement("myTable1");
        ListHandle list1 = (ListHandle)this.designHandle.findElement("myList1");
        CommandStack cmdStack = this.designHandle.getCommandStack();
        cmdStack.startTrans(null);
        table2.setDataBindingReference((ReportItemHandle)table1);
        list1.setDataBindingReference((ReportItemHandle)table1);
        cmdStack.commit();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("SetDataGroupRef_golden.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("SetDataGroupRefUndo_golden.xml"));
        this.designHandle.getCommandStack().redo();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("SetDataGroupRefRedo_golden.xml"));
        cmdStack.startTrans(null);
        table2.setDataBindingReference(null);
        list1.setDataBindingReference(null);
        cmdStack.commit();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("SetDataGroupRefNull_golden.xml"));
        this.designHandle.getCommandStack().undo();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("SetDataGroupRefNullUndo_golden.xml"));
        cmdStack.startTrans(null);
        TableHandle table3 = this.designHandle.getElementFactory().newTableItem("myTable3");
        table2.setDataBindingReference((ReportItemHandle)table3);
        list1.setDataBindingReference((ReportItemHandle)table3);
        cmdStack.commit();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("SetDataGroupRefInvalid_golden.xml"));
    }

    public void testParseInconsistentDataGroup() throws Exception {
        this.openDesign("DataGroupRef_3.xml");
        ReportItemDataRefTest.assertEquals((int)3, (int)this.designHandle.getWarningList().size());
        List warnings = this.designHandle.getWarningList();
        ReportItemDataRefTest.assertEquals((String)"The data binding reference of the element Table(\"myTable3\") has different number of groups with element Table(\"myTable1\") it refers to.", (String)((ErrorDetail)warnings.get(0)).getMessage());
        ReportItemDataRefTest.assertEquals((String)"The data binding reference of the element Table(\"myTable2\") has different number of groups with element Table(\"myTable1\") it refers to.", (String)((ErrorDetail)warnings.get(1)).getMessage());
        ReportItemDataRefTest.assertEquals((String)"The data binding reference of the element List(\"myList1\") has different number of groups with element Table(\"myTable1\") it refers to.", (String)((ErrorDetail)warnings.get(2)).getMessage());
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("ParseInconsistentDataGroup_golden.xml"));
    }

    public void testGetDataBindingOfContainer() throws Exception {
        this.openDesign("DataBindingOfContainerTest.xml");
        TableHandle table = (TableHandle)this.designHandle.getElementByID(9L);
        List list = table.getAvailableDataSetBindingReferenceList();
        ReportItemDataRefTest.assertEquals((int)0, (int)list.size());
        ExtendedItemHandle handle = (ExtendedItemHandle)this.designHandle.getElementByID(28L);
        try {
            table.setDataBindingReference((ReportItemHandle)handle);
            ReportItemDataRefTest.fail();
        }
        catch (SemanticError e) {
            ReportItemDataRefTest.assertEquals((String)"Error.SemanticError.INVALID_DATA_BINDING_REF", (String)e.getErrorCode());
        }
    }

    public void testDropAndClear() throws Exception {
        this.openDesign(FILE_NAME);
        TableHandle table1 = (TableHandle)this.designHandle.findElement("myTable1");
        table1.dropAndClear();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("ReportItemDataRefTest_golden.xml"));
    }

    public void testLocalizeColumnBindingWithAggregation() throws Exception {
        this.openDesign(FILE_NAME_1);
        TableHandle table1 = (TableHandle)this.designHandle.findElement("myTable1");
        table1.dropAndClear();
        this.save();
        ReportItemDataRefTest.assertTrue((boolean)this.compareFile("ReportItemDataRefTest_golden_1.xml"));
    }
}

