/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.ApiTestUtil;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class SessionHandleTest
extends BaseTestCase {
    private final String fileName = "SessionHandleTest.xml";
    private final String outFileName = "SessionHandleTest_out.xml";
    private final String wrongTagFileName = "SessionHandleTest_1.xml";
    private final String semanticErrorFileName = "SessionHandleTest_2.xml";
    private final String missingStartingTagFileName = "SessionHandleTest_3.xml";
    private final String unmatchedTagFileName = "SessionHandleTest_4.xml";
    private final String missingEndingTagFileName = "SessionHandleTest_5.xml";
    private final String invalidAttrFileName = "SessionHandleTest_6.xml";
    private final String undefinedPropertyFileName = "SessionHandleTest_7.xml";
    private final String notExistedFileName = "NotExistedFile.xml";
    private final String UTF8BOMFileName = "SessionHandleTest_UTF8BOM.xml";
    private final String simpleDesignFile = "SessionHandleTest_8.xml";
    private final String simpleLibraryFile = "SessionHandleTest_9.xml";
    private final String streamFileName = "SessionHandleTest_Stream.xml";
    private SessionHandle session = null;
    private DesignEngine designEngine = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.designEngine = new DesignEngine(new DesignConfig());
        this.session = this.designEngine.newSessionHandle(null);
        SessionHandleTest.assertEquals((Object)ULocale.getDefault(), (Object)this.session.getULocale());
        IMetaDataDictionary dic = this.designEngine.getMetaData();
        SessionHandleTest.assertFalse((boolean)dic.getElements().isEmpty());
    }

    public void testULocale() {
        this.session = this.designEngine.newSessionHandle(ULocale.ENGLISH);
        SessionHandleTest.assertEquals((Object)ULocale.ENGLISH, (Object)this.session.getULocale());
        this.session = this.designEngine.newSessionHandle(ULocale.KOREA);
        SessionHandleTest.assertEquals((Object)ULocale.KOREA, (Object)this.session.getULocale());
    }

    public void testCreateOpenAndClose() throws Exception {
        String outputPath = String.valueOf(this.getTempFolder()) + "/output/";
        File outputFolder = new File(outputPath);
        if (!outputFolder.exists() && !outputFolder.mkdirs()) {
            throw new IOException("Can not create the output folder");
        }
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest.xml").toString());
        SessionHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)1, (int)this.getDesignCount());
        this.designHandle.setStringProperty("author", "abc");
        SessionHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        this.designHandle.saveAs(String.valueOf(outputPath) + "SessionHandleTest_out.xml");
        SessionHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)1, (int)this.getDesignCount());
        FreeFormHandle freeForm = this.designHandle.getElementFactory().newFreeForm("My Form");
        this.designHandle.getBody().add((DesignElementHandle)freeForm);
        SessionHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        this.designHandle.close();
        SessionHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        SessionHandleTest.assertFalse((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)0, (int)this.getDesignCount());
        ReportDesignHandle newDesign = this.session.createDesign();
        SessionHandleTest.assertFalse((boolean)newDesign.needsSave());
        SessionHandleTest.assertTrue((boolean)newDesign.getModule().isValid());
        SessionHandleTest.assertEquals((int)1, (int)this.getDesignCount());
        newDesign.saveAs(String.valueOf(outputPath) + "newdesign.xml");
        newDesign.close();
        SessionHandleTest.assertFalse((boolean)newDesign.needsSave());
        SessionHandleTest.assertFalse((boolean)newDesign.getModule().isValid());
        SessionHandleTest.assertEquals((int)0, (int)this.getDesignCount());
        this.session = null;
        this.designHandle = null;
        this.session = this.designEngine.newSessionHandle(null);
        this.designHandle = this.session.openDesign(String.valueOf(outputPath) + "newdesign.xml");
        SessionHandleTest.assertNotNull((Object)this.designHandle);
        SessionHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)1, (int)this.getDesignCount());
        ReportDesignHandle anotherDesignHandle = this.session.openDesign(this.getResource("input/SessionHandleTest.xml").toString());
        SessionHandleTest.assertNotNull((Object)anotherDesignHandle);
        SessionHandleTest.assertTrue((boolean)anotherDesignHandle.needsSave());
        SessionHandleTest.assertTrue((boolean)anotherDesignHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)2, (int)this.getDesignCount());
        ModuleOption options = new ModuleOption();
        options.setProperty("blankCreation", (Object)Boolean.TRUE);
        String newFileName = this.getResource("input/SessionHandleTest.xml").toString();
        ReportDesignHandle simpleDesignHandle = this.session.createDesign(newFileName, options);
        newFileName = newFileName.replaceAll("SessionHandleTest.xml", "SessionHandleTest_golden.xml");
        this.save((ModuleHandle)simpleDesignHandle);
        SessionHandleTest.assertTrue((boolean)this.compareFile("SessionHandleTest_golden.xml"));
    }

    public void testOpenNonExistedFile() {
        try {
            this.designHandle = this.session.openDesign(String.valueOf(this.getResource("input/").toString()) + "NotExistedFile.xml");
            SessionHandleTest.fail();
        }
        catch (DesignFileException e) {
            SessionHandleTest.assertNull((Object)this.designHandle);
            SessionHandleTest.assertEquals((String)"Error.DesignFileException.SYNTAX_ERROR", (String)e.getErrorCode());
            SessionHandleTest.assertEquals((int)1, (int)e.getErrorList().size());
            ErrorDetail error = (ErrorDetail)e.getErrorList().get(0);
            SessionHandleTest.assertEquals((String)"Error.DesignParserException.FILE_NOT_FOUND", (String)error.getErrorCode());
        }
    }

    public void testOpenWithWrongTag() {
        this.designHandle = null;
        try {
            this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_1.xml").toString());
            SessionHandleTest.fail();
        }
        catch (DesignFileException e) {
            System.out.println((Object)e);
            SessionHandleTest.assertNull((Object)this.designHandle);
            SessionHandleTest.assertEquals((String)"Error.DesignFileException.SYNTAX_ERROR", (String)e.getErrorCode());
            SessionHandleTest.assertEquals((int)1, (int)e.getErrorList().size());
        }
    }

    public void testOpenWithUndefinedProperty() throws DesignFileException {
        this.designHandle = null;
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_7.xml").toString());
        List errors = this.designHandle.getErrorList();
        SessionHandleTest.assertEquals((int)3, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(0);
        SessionHandleTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(1);
        SessionHandleTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(2);
        SessionHandleTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)error.getErrorCode());
    }

    public void testOpenWithMissingStartingTagError() {
        try {
            this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_3.xml").toString());
            SessionHandleTest.fail();
        }
        catch (DesignFileException e) {
            System.out.println((Object)e);
            SessionHandleTest.assertNull((Object)this.designHandle);
            SessionHandleTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
            SessionHandleTest.assertEquals((int)2, (int)e.getErrorList().size());
        }
    }

    public void testOpenWithUnmatchedTagError() {
        this.designHandle = null;
        try {
            this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_4.xml").toString());
            SessionHandleTest.fail();
        }
        catch (DesignFileException e) {
            System.out.println((Object)e);
            SessionHandleTest.assertNull((Object)this.designHandle);
            SessionHandleTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
            SessionHandleTest.assertEquals((int)3, (int)e.getErrorList().size());
            ErrorDetail error = (ErrorDetail)e.getErrorList().get(0);
            SessionHandleTest.assertEquals((String)"wrong-tag", (String)error.getTagName());
            error = (ErrorDetail)e.getErrorList().get(1);
            ErrorDetail errorDetail = (ErrorDetail)e.getErrorList().get(2);
        }
    }

    public void testOpenWithInvalidAttrError() {
        this.designHandle = null;
        try {
            this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_6.xml").toString());
        }
        catch (DesignFileException designFileException) {
            SessionHandleTest.fail();
        }
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)0, (int)this.designHandle.getModule().getErrorList().size());
    }

    public void testOpenWithMissingEndingTagError() {
        this.designHandle = null;
        try {
            this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_5.xml").toString());
            SessionHandleTest.fail();
        }
        catch (DesignFileException e) {
            System.out.println((Object)e);
            SessionHandleTest.assertNull((Object)this.designHandle);
            SessionHandleTest.assertEquals((String)"Error.DesignFileException.INVALID_XML", (String)e.getErrorCode());
            SessionHandleTest.assertEquals((int)3, (int)e.getErrorList().size());
            ErrorDetail error = (ErrorDetail)e.getErrorList().get(0);
            SessionHandleTest.assertEquals((String)"body", (String)error.getTagName());
            error = (ErrorDetail)e.getErrorList().get(1);
            ErrorDetail errorDetail = (ErrorDetail)e.getErrorList().get(2);
        }
    }

    public void testOpenWithSemanticError() throws Exception {
        this.designHandle = null;
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_2.xml").toString());
        SessionHandleTest.assertEquals((int)3, (int)this.designHandle.getModule().getErrorList().size());
        ErrorDetail error = (ErrorDetail)this.designHandle.getModule().getErrorList().get(0);
        SessionHandleTest.assertEquals((String)"Error.DesignFileException.SEMANTIC_ERROR", (String)error.getType());
        SessionHandleTest.assertEquals((String)"Error.SemanticError.MISSING_MASTER_PAGE", (String)error.getErrorCode());
        SessionHandleTest.assertEquals((String)"ReportDesign", (String)error.getElement().getElementName());
        SessionHandleTest.assertEquals(null, (String)error.getElement().getName());
        error = (ErrorDetail)this.designHandle.getErrorList().get(1);
        SessionHandleTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)error.getErrorCode());
        error = (ErrorDetail)this.designHandle.getErrorList().get(2);
        SessionHandleTest.assertEquals((String)"Error.DesignParserException.UNDEFINED_PROPERTY", (String)error.getErrorCode());
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)1, (int)this.getDesignCount());
        this.designHandle.getModule().close();
        SessionHandleTest.assertFalse((boolean)this.designHandle.getModule().isValid());
        SessionHandleTest.assertEquals((int)0, (int)this.getDesignCount());
        this.designHandle = null;
    }

    public void testOpenWithBOM() throws Exception {
        this.designHandle = null;
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_UTF8BOM.xml").toString());
        SessionHandleTest.assertNotNull((Object)this.designHandle);
        this.designHandle = null;
        try {
            this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_INVALIDBOM.xml").toString());
        }
        catch (DesignFileException e) {
            List errors = e.getErrorList();
            SessionHandleTest.assertEquals((int)1, (int)errors.size());
            SessionHandleTest.assertEquals((String)"Error.DesignParserException.UNSUPPORTED_ENCODING", (String)((ErrorDetail)errors.get(0)).getErrorCode());
        }
        SessionHandleTest.assertNull((Object)this.designHandle);
    }

    public void testSessionProperties() throws Exception {
        this.session.setApplicationUnits("mm");
        SessionHandleTest.assertEquals((String)"mm", (String)this.session.getApplicationUnits());
        this.session.setColorFormat(4);
        SessionHandleTest.assertEquals((int)4, (int)this.session.getColorFormat());
        IResourceLocator testLocator = new IResourceLocator(){

            public URL findResource(ModuleHandle moduleHandle, String filename, int type) {
                return null;
            }

            public URL findResource(ModuleHandle moduleHandle, String fileName, int type, Map appContext) {
                return null;
            }
        };
        this.session.setResourceLocator(testLocator);
        SessionHandleTest.assertEquals((Object)testLocator, (Object)this.session.getResourceLocator());
    }

    public void testDefaultValue() throws Exception {
        this.session.setDefaultValue("borderBottomColor", (Object)"#00ffff");
        this.session.setDefaultValue("borderTopColor", (Object)"#ff0000");
        this.session.setDefaultValue("borderLeftColor", (Object)"#0000ff");
        SessionHandleTest.assertEquals((String)"65535", (String)this.session.getDefaultValue("borderBottomColor").toString());
        SessionHandleTest.assertEquals((String)"16711680", (String)this.session.getDefaultValue("borderTopColor").toString());
        SessionHandleTest.assertEquals((String)"255", (String)this.session.getDefaultValue("borderLeftColor").toString());
    }

    public void testOpenWithStream() throws Exception {
        this.openDesign("SessionHandleTest.xml");
        URL url = this.getResource("input/SessionHandleTest.xml");
        URL parentUrl = this.getResource("input/");
        SessionHandleTest.assertEquals((String)parentUrl.toString(), (String)this.designHandle.getSystemId().toExternalForm());
        url = this.getResource("input/SessionHandleTest_Stream.xml");
        InputStream is = url.openStream();
        this.designHandle = this.session.openDesign(parentUrl, is);
        is.close();
        this.design = (ReportDesign)this.designHandle.getModule();
        SessionHandleTest.assertNull((Object)this.design.getFileName());
        this.testSystemIdAndFileName(this.designHandle, url, parentUrl);
        this.openDesign("SessionHandleTest_Stream.xml");
        url = this.getResource("input/SessionHandleTest_Stream.xml");
        is = url.openStream();
        this.testSystemIdAndFileName(this.designHandle, url, parentUrl);
        this.openDesign(url.toExternalForm(), is);
        SessionHandleTest.assertEquals((String)url.toExternalForm(), (String)this.design.getFileName());
        this.testSystemIdAndFileName(this.designHandle, url, parentUrl);
        is.close();
    }

    private void testSystemIdAndFileName(ReportDesignHandle designHandle, URL url, URL parentUrl) throws Exception {
        SessionHandleTest.assertEquals((String)parentUrl.toString(), (String)designHandle.getSystemId().toString());
        List libraries = designHandle.getLibraries();
        SessionHandleTest.assertEquals((int)2, (int)libraries.size());
        LibraryHandle libHandle = (LibraryHandle)libraries.get(0);
        SessionHandleTest.assertTrue((boolean)libHandle.isValid());
        SessionHandleTest.assertEquals((String)parentUrl.toString(), (String)libHandle.getSystemId().toString());
        libHandle = (LibraryHandle)libraries.get(1);
        SessionHandleTest.assertTrue((boolean)libHandle.isValid());
        URL tmpUrl = this.getResource("/org/eclipse/birt/report/model/library/input/");
        SessionHandleTest.assertTrue((boolean)tmpUrl.sameFile(libHandle.getSystemId()));
    }

    public void testOpenModule() throws DesignFileException {
        this.openModule("SessionHandleTest_8.xml");
        SessionHandleTest.assertTrue((boolean)(this.moduleHandle instanceof ReportDesignHandle));
        this.openModule("SessionHandleTest_9.xml");
        SessionHandleTest.assertTrue((boolean)(this.moduleHandle instanceof LibraryHandle));
    }

    public void testOpenWithNull() throws DesignFileException, IOException {
        try {
            this.session.openDesign(null);
            SessionHandleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.session.openDesign(null, null);
            SessionHandleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.session.openModule(null);
            SessionHandleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            this.session.openLibrary(null, null);
            SessionHandleTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private int getDesignCount() {
        int count = 0;
        Iterator iter = ApiTestUtil.getDesignSession((SessionHandle)this.session).getDesignIterator();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    public void testFireResourceChange() throws DesignFileException {
        this.libraryHandle = this.session.openLibrary(this.getResource("input/Library_1.xml").toString());
        MockupLibraryExplorer libListener = new MockupLibraryExplorer();
        this.libraryHandle.addResourceChangeListener((IResourceChangeListener)libListener);
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_10.xml").toString());
        this.designHandle.addResourceChangeListener((IResourceChangeListener)new MockupLayoutListener());
        List libs = ((Module)this.designHandle.getElement()).getLibraries();
        SessionHandleTest.assertEquals((int)2, (int)libs.size());
        Library instance1 = (Library)libs.get(0);
        Library instance2 = (Library)libs.get(1);
        this.session.fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(this.getResource("input/Library_1.xml").toExternalForm()));
        SessionHandleTest.assertEquals((String)"refresh", (String)libListener.getStatus());
        SessionHandleTest.assertNotSame((Object)instance1, ((Module)this.designHandle.getElement()).getLibraries().get(0));
        SessionHandleTest.assertSame((Object)instance2, ((Module)this.designHandle.getElement()).getLibraries().get(1));
        this.session.fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(this.getResource("input/Grandson.xml").toExternalForm()));
        SessionHandleTest.assertNotSame((Object)instance2, ((Module)this.designHandle.getElement()).getLibraries().get(1));
    }

    public void testParserSemanticCheckControl() throws Exception {
        ModuleOption options = new ModuleOption();
        options.setSemanticCheck(false);
        options.setMarkLineNumber(true);
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_11.xml").toString(), options);
        SessionHandleTest.assertTrue((boolean)options.markLineNumber());
        SessionHandleTest.assertEquals((int)0, (int)this.designHandle.getModule().getAllErrors().size());
        SessionHandleTest.assertEquals((int)0, (int)this.designHandle.getLibrary("lib").getModule().getAllErrors().size());
        this.designHandle.close();
        options = null;
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_11.xml").toString(), options);
        SessionHandleTest.assertEquals((int)1, (int)this.designHandle.getModule().getAllErrors().size());
        SessionHandleTest.assertEquals((int)1, (int)this.designHandle.getLibrary("lib").getModule().getAllErrors().size());
    }

    public void testGetDefaultTOCStyle() throws Exception {
        StyleHandle styleHandle = this.session.getDefaultTOCStyle("TOC-level-0");
        SessionHandleTest.assertNotNull((Object)styleHandle);
        SessionHandleTest.assertEquals((String)"12pt", (String)styleHandle.getFontSize().getStringValue());
        try {
            styleHandle.setCanShrink(false);
            SessionHandleTest.fail();
        }
        catch (IllegalOperationException e) {
            SessionHandleTest.assertEquals((String)"The module is read-only and operation is forbidden.", (String)e.getMessage());
        }
    }

    public void testOpenForSimpleParser() throws Exception {
        ModuleOption options = new ModuleOption();
        options.setProperty("readOnlyModuleProperties", (Object)Boolean.TRUE);
        this.designHandle = this.session.openDesign(this.getResource("input/SessionHandleTest_10.xml").toString(), options);
        SessionHandleTest.assertTrue((boolean)this.designHandle.getModule().isReadOnly());
        SessionHandleTest.assertEquals((String)"Eclipse BIRT Designer Version 2.1.0.qualifier Build <@BUILD@>", (String)this.designHandle.getCreatedBy());
        SessionHandleTest.assertEquals((int)0, (int)this.designHandle.getMasterPages().getCount());
        SessionHandleTest.assertEquals((int)0, (int)this.designHandle.getLibraries().size());
        SessionHandleTest.assertEquals((int)0, (int)this.designHandle.getModule().getErrorList().size());
    }

    class MockupLayoutListener
    implements IResourceChangeListener {
        private String status = null;

        MockupLayoutListener() {
        }

        public void resourceChanged(ModuleHandle targetElement, ResourceChangeEvent ev) {
            this.status = "reload";
            try {
                targetElement.reloadLibrary(ev.getChangedResourcePath());
            }
            catch (SemanticException semanticException) {
                SessionHandleTest.fail();
            }
            catch (DesignFileException designFileException) {
                SessionHandleTest.fail();
            }
        }

        public String getStatus() {
            return this.status;
        }
    }

    class MockupLibraryExplorer
    implements IResourceChangeListener {
        private String status = null;

        MockupLibraryExplorer() {
        }

        public void resourceChanged(ModuleHandle targetElement, ResourceChangeEvent ev) {
            this.status = "refresh";
        }

        public String getStatus() {
            return this.status;
        }
    }
}

