/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.SearchKey;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StructureFactoryTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.designHandle = new SessionHandle(ULocale.getDefault()).createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    public void testLiteralString() throws SemanticException {
        OdaDataSetHandle dataSet = this.designHandle.getElementFactory().newOdaDataSet("dataset", null);
        OdaDataSetParameter setParameter = StructureFactory.createOdaDataSetParameter();
        setParameter.setName("param1");
        setParameter.setNativeName("");
        OdaDataSetParameterHandle paramHandle = (OdaDataSetParameterHandle)dataSet.getPropertyHandle("parameters").addItem((IStructure)setParameter);
        StructureFactoryTest.assertEquals((String)"param1", (String)paramHandle.getName());
        StructureFactoryTest.assertEquals((String)"", (String)paramHandle.getNativeName());
        OdaResultSetColumn column = StructureFactory.createOdaResultSetColumn();
        column.setNativeName("");
        column.setColumnName("column1");
        OdaResultSetColumnHandle columnHandle = (OdaResultSetColumnHandle)dataSet.getPropertyHandle("resultSet").addItem((IStructure)column);
        StructureFactoryTest.assertEquals((String)"column1", (String)columnHandle.getColumnName());
        StructureFactoryTest.assertEquals((String)"", (String)columnHandle.getNativeName());
    }

    public void testNewStructure() {
        ComputedColumn computedColumn = StructureFactory.createComputedColumn();
        StructureFactoryTest.assertNotNull((Object)computedColumn);
        ConfigVariable configVar = StructureFactory.createConfigVar();
        StructureFactoryTest.assertNotNull((Object)configVar);
        EmbeddedImage embeddedImage = StructureFactory.createEmbeddedImage();
        StructureFactoryTest.assertNotNull((Object)embeddedImage);
        FilterCondition filterCondition = StructureFactory.createFilterCond();
        StructureFactoryTest.assertNotNull((Object)filterCondition);
        HideRule hide = StructureFactory.createHideRule();
        StructureFactoryTest.assertNotNull((Object)hide);
        IncludeScript includeScript = StructureFactory.createIncludeScript();
        StructureFactoryTest.assertNotNull((Object)includeScript);
        IncludedLibrary includeLibrary = StructureFactory.createIncludeLibrary();
        StructureFactoryTest.assertNotNull((Object)includeLibrary);
        ParamBinding paramBinding = StructureFactory.createParamBinding();
        StructureFactoryTest.assertNotNull((Object)paramBinding);
        PropertyMask propertyMask = StructureFactory.createPropertyMask();
        StructureFactoryTest.assertNotNull((Object)propertyMask);
        ResultSetColumn resultSetColumn = StructureFactory.createResultSetColumn();
        StructureFactoryTest.assertNotNull((Object)resultSetColumn);
        SearchKey searchKey = StructureFactory.createSearchKey();
        StructureFactoryTest.assertNotNull((Object)searchKey);
        SelectionChoice selectionChoice = StructureFactory.createSelectionChoice();
        StructureFactoryTest.assertNotNull((Object)selectionChoice);
        SortKey sortKey = StructureFactory.createSortKey();
        StructureFactoryTest.assertNotNull((Object)sortKey);
        ColumnHint columnHint = StructureFactory.createColumnHint();
        StructureFactoryTest.assertNotNull((Object)columnHint);
        HighlightRule highlightRule = StructureFactory.createHighlightRule();
        StructureFactoryTest.assertNotNull((Object)highlightRule);
        MapRule mapRule = StructureFactory.createMapRule();
        StructureFactoryTest.assertNotNull((Object)mapRule);
        TOC toc = StructureFactory.createTOC();
        StructureFactoryTest.assertNotNull((Object)toc);
        toc = StructureFactory.createTOC((String)"toc");
        StructureFactoryTest.assertNotNull((Object)toc);
    }

    public void testNewBoundDataColumns() throws SemanticException {
        TextItemHandle textHandle = this.designHandle.getElementFactory().newTextItem("text1");
        this.designHandle.getBody().add((DesignElementHandle)textHandle);
        ComputedColumn column1 = StructureFactory.newComputedColumn((DesignElementHandle)textHandle, (String)"new_column");
        StructureFactoryTest.assertEquals((String)"new_column", (String)column1.getName());
        column1.setExpression("new expression");
        textHandle.addColumnBinding(column1, false);
        column1 = StructureFactory.newComputedColumn((DesignElementHandle)textHandle, (String)"new_column");
        StructureFactoryTest.assertEquals((String)"new_column_1", (String)column1.getName());
        column1.setExpression("new expression1");
        textHandle.addColumnBinding(column1, false);
        column1 = StructureFactory.newComputedColumn((DesignElementHandle)textHandle, (String)"new_column");
        StructureFactoryTest.assertEquals((String)"new_column_2", (String)column1.getName());
    }
}

