/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.TranslationHandle;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class TranslationHandleTest
extends BaseTestCase {
    private static final String INPUT_FILE = "TranslationHandleTest.xml";
    private static final String GOLDEN_FILE = "TranslationHandleTest.golden.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(INPUT_FILE);
    }

    public void testGetSet() throws CustomMsgException {
        List translations = this.designHandle.getTranslations();
        TranslationHandleTest.assertTrue((translations.size() == 4 ? 1 : 0) != 0);
        TranslationHandle transHandle = (TranslationHandle)translations.get(0);
        TranslationHandleTest.assertEquals((String)"text default", (String)transHandle.getText());
        TranslationHandleTest.assertEquals(null, (String)transHandle.getLocale());
        TranslationHandleTest.assertEquals((String)"ResourceKey.testKey1", (String)transHandle.getResourceKey());
        try {
            transHandle.setLocale("en");
            TranslationHandleTest.fail();
        }
        catch (CustomMsgException e) {
            TranslationHandleTest.assertEquals((String)"Error.CustomMsgException.DUPLICATE_LOCALE", (String)e.getErrorCode());
        }
        transHandle.setLocale("en_AF");
        TranslationHandleTest.assertEquals((String)"en_AF", (String)transHandle.getLocale());
        transHandle.setText("text for AF");
        TranslationHandleTest.assertEquals((String)"text for AF", (String)transHandle.getText());
        transHandle = (TranslationHandle)translations.get(1);
        TranslationHandleTest.assertEquals((String)"text en", (String)transHandle.getText());
        TranslationHandleTest.assertEquals((String)"en", (String)transHandle.getLocale());
        TranslationHandleTest.assertEquals((String)"ResourceKey.testKey1", (String)transHandle.getResourceKey());
    }

    public void testWriter() throws Exception {
        List translations = this.designHandle.getTranslations();
        TranslationHandle transHandle = (TranslationHandle)translations.get(0);
        transHandle.setLocale("en_AF");
        transHandle.setText("text for AF");
        this.designHandle.addTranslation("ResourceKey.testKey2", "en", "ABC");
        this.designHandle.addTranslation("ResourceKey.testKey2", null, "DEFAULT");
        this.save();
        TranslationHandleTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE));
    }
}

