/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.metadata.ChoicePropertyType;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyType;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class UserPropertyHandleTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("UserPropertyHandleTest.xml");
    }

    public void testConstructor() throws Exception {
        UserPropertyDefn upd = new UserPropertyDefn();
        UserPropertyDefnHandle handle1 = new UserPropertyDefnHandle((DesignElementHandle)this.designHandle.findMasterPage("My Page"), upd);
        UserPropertyHandleTest.assertNotNull((Object)handle1);
        upd.setName("newName");
        this.designHandle.findMasterPage("My Page").addUserPropertyDefn(upd);
        UserPropertyDefnHandle handle2 = new UserPropertyDefnHandle((DesignElementHandle)this.designHandle.findMasterPage("My Page"), "newName");
        UserPropertyHandleTest.assertNotNull((Object)handle2);
    }

    public void testSetPropDefn() throws SemanticException, IOException, UserPropertyException, PropertyValueException, MetaDataException {
        MasterPageHandle pageHandle = this.designHandle.findMasterPage("My Page");
        UserPropertyDefnHandle updHandle = pageHandle.getUserPropertyDefnHandle("myProp1");
        UserPropertyHandleTest.assertNotNull((Object)updHandle);
        UserPropertyDefn upd = new UserPropertyDefn();
        try {
            updHandle.setUserPropertyDefn(upd);
            UserPropertyHandleTest.fail();
        }
        catch (UserPropertyException e) {
            UserPropertyHandleTest.assertEquals((String)"Error.UserPropertyException.NAME_REQUIRED", (String)e.getErrorCode());
        }
        upd.setName("new upd");
        UserPropertyHandleTest.assertEquals((int)0, (int)upd.getTypeCode());
        updHandle.setUserPropertyDefn(upd);
        this.designHandle.getCommandStack().undo();
        StructPropertyType propType = new StructPropertyType();
        upd.setType((PropertyType)propType);
        try {
            updHandle.setUserPropertyDefn(upd);
            UserPropertyHandleTest.fail();
        }
        catch (UserPropertyException upe) {
            UserPropertyHandleTest.assertEquals((String)"Error.UserPropertyException.INVALID_TYPE", (String)upe.getErrorCode());
        }
        UserChoice[] set = new UserChoice[3];
        set[0] = new UserChoice("newOne", "one resourcekey");
        set[0].setValue((Object)"one");
        set[1] = new UserChoice("newTwo", "two resourcekey");
        set[1].setValue((Object)"two");
        set[2] = new UserChoice("newThree", "three resourcekey");
        set[2].setValue((Object)"three");
        upd.setChoices(set);
        propType = new ChoicePropertyType();
        upd.setType((PropertyType)propType);
    }

    public void testGetters() throws SemanticException {
        MasterPageHandle pageHandle = this.designHandle.findMasterPage("My Page");
        UserPropertyDefnHandle updHandle = pageHandle.getUserPropertyDefnHandle("myProp1");
        UserPropertyHandleTest.assertNotNull((Object)updHandle);
        UserPropertyHandleTest.assertEquals((Object)pageHandle.getElement(), (Object)updHandle.getElement());
        UserPropertyHandleTest.assertEquals((Object)this.design, (Object)updHandle.getModule());
        UserPropertyHandleTest.assertEquals((String)"myProp1", (String)updHandle.getName());
        UserPropertyDefn copy = updHandle.getCopy();
        UserPropertyHandleTest.assertEquals((String)updHandle.getDisplayName(), (String)copy.getDisplayName());
        UserPropertyHandleTest.assertEquals((String)updHandle.getDefn().getName(), (String)copy.getName());
        UserPropertyHandleTest.assertEquals((int)updHandle.getDefn().getTypeCode(), (int)copy.getType().getTypeCode());
    }
}

