/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ContentCommandTest
extends BaseTestCase {
    private DesignElement container;
    private MasterPageHandle containerHandle;
    ElementFactory factory = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.designHandle = this.sessionHandle.createDesign("myDesign");
        this.design = (ReportDesign)this.designHandle.getModule();
        this.factory = new ElementFactory((Module)this.design);
        this.containerHandle = this.factory.newGraphicMasterPage("Master page1");
        this.designHandle.getMasterPages().add((DesignElementHandle)this.containerHandle);
        this.container = this.containerHandle.getElement();
    }

    public void testAdd() throws Exception {
        Cell cell = new Cell();
        Label child = new Label();
        Label label = new Label();
        this.containerHandle.getSlot(0).add(label.getHandle((Module)this.design));
        cell.getHandle((Module)this.design).getSlot(0).add(child.getHandle((Module)this.design));
        ContentCommandTest.assertNull((Object)label.getHandle((Module)this.design).getSlot(0));
        try {
            SimpleMasterPageHandle pageHandle = this.designHandle.getElementFactory().newSimpleMasterPage("simplepage");
            this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
            ContentCommand command = new ContentCommand((Module)this.design, new ContainerContext(pageHandle.getElement(), 0));
            command.add((DesignElement)new TextItem());
            command = new ContentCommand((Module)this.design, new ContainerContext(pageHandle.getElement(), 0));
            command.add((DesignElement)new TextItem());
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.SLOT_IS_FULL", (String)e.getErrorCode());
        }
        try {
            this.containerHandle.getSlot(0).add(new TableItem().getHandle((Module)this.design));
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
        }
        try {
            ContentCommand command = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)new FreeForm(), 999));
            command.add((DesignElement)new Label());
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.SLOT_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testAddElementIntoCompoundSlot() throws ContentException, NameException {
        LabelHandle labelWithoutName = this.factory.newLabel(null);
        LabelHandle label = this.factory.newLabel("label1");
        try {
            this.designHandle.getComponents().add((DesignElementHandle)labelWithoutName);
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.CONTENT_NAME_REQUIRED", (String)e.getErrorCode());
        }
        this.designHandle.getComponents().add((DesignElementHandle)label);
    }

    public void testRemove() throws Exception {
        ContentCommand command;
        try {
            command = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)new Label(), 0));
            command.remove((DesignElement)new Label());
            ContentCommandTest.fail();
        }
        catch (SemanticException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.NOT_CONTAINER", (String)e.getErrorCode());
        }
        try {
            command = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)new FreeForm(), 0));
            command.remove((DesignElement)new Label());
            ContentCommandTest.fail();
        }
        catch (SemanticException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.CONTENT_NOT_FOUND", (String)e.getErrorCode());
        }
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style1");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        FreeFormHandle form = this.designHandle.getElementFactory().newFreeForm("form2");
        this.designHandle.getBody().add((DesignElementHandle)form);
        form.setStyle(style);
        ContentCommandTest.assertNotNull((Object)form.getStyle());
        ContentCommand command2 = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)this.design, 0));
        command2.remove(style.getElement());
        ContentCommandTest.assertNull((Object)form.getStyle());
        TableHandle table = this.designHandle.getElementFactory().newTableItem("table1");
        this.designHandle.getBody().add((DesignElementHandle)table);
        OdaDataSetHandle dataSet = this.designHandle.getElementFactory().newOdaDataSet("dataSet1");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        table.setDataSet((DataSetHandle)dataSet);
        command2 = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)this.design, 3));
        command2.remove(dataSet.getElement());
        ContentCommandTest.assertNull((Object)table.getDataSet());
    }

    public void testNormalCaseUndoAndRedo() throws Exception {
        FreeFormHandle contentHandle = this.factory.newFreeForm(null);
        ActivityStack as = this.design.getActivityStack();
        this.containerHandle.getSlot(0).add((DesignElementHandle)contentHandle);
        DesignElement obj = this.container.getSlot(0).getContent(0);
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)obj);
        ContentCommandTest.assertEquals((Object)this.container, (Object)contentHandle.getContainer());
        ContentCommandTest.assertFalse((boolean)as.canRedo());
        ContentCommandTest.assertTrue((boolean)as.canUndo());
        as.undo();
        ContentCommandTest.assertEquals((int)0, (int)this.container.getSlot(0).getCount());
        ContentCommandTest.assertTrue((boolean)as.canRedo());
        as.redo();
        obj = this.container.getSlot(0).getContent(0);
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)obj);
        this.containerHandle.getSlot(0).dropAndClear(0);
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 0 ? 1 : 0) != 0);
        ContentCommandTest.assertNull((Object)contentHandle.getContainer());
        ContentCommandTest.assertFalse((boolean)as.canRedo());
        ContentCommandTest.assertTrue((boolean)as.canUndo());
        as.undo();
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 1 ? 1 : 0) != 0);
        FreeForm content2 = new FreeForm();
        this.containerHandle.getSlot(0).add(content2.getHandle((Module)this.design), 0);
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 2 ? 1 : 0) != 0);
        ContentCommandTest.assertEquals((Object)content2, (Object)this.container.getSlot(0).getContent(0));
        FreeForm content3 = new FreeForm();
        this.containerHandle.getSlot(0).add(content3.getHandle((Module)this.design), 10);
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 3 ? 1 : 0) != 0);
        ContentCommandTest.assertEquals((Object)content3, (Object)this.container.getSlot(0).getContent(2));
        FreeForm content4 = new FreeForm();
        this.containerHandle.getSlot(0).add(content4.getHandle((Module)this.design), 1);
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 4 ? 1 : 0) != 0);
        ContentCommandTest.assertEquals((Object)content2, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)content4, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)this.container.getSlot(0).getContent(2));
        ContentCommandTest.assertEquals((Object)content3, (Object)this.container.getSlot(0).getContent(3));
    }

    public void testUndoRedoAfterRemove() throws Exception {
        FreeForm content = new FreeForm();
        FreeForm parent = new FreeForm();
        parent.setName("parent");
        content.setName("innerContainer");
        Style style = new Style("style");
        ActivityStack as = this.design.getActivityStack();
        try {
            ContentCommand command = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)new Label(), 0));
            command.add((DesignElement)content);
            ContentCommandTest.fail();
        }
        catch (SemanticException e) {
            ContentCommandTest.assertTrue((boolean)(e instanceof ContentException));
            ContentException ex = (ContentException)((Object)e);
            ContentCommandTest.assertEquals((String)"Error.ContentException.NOT_CONTAINER", (String)ex.getErrorCode());
        }
        this.containerHandle.getSlot(0).add(content.getHandle((Module)this.design));
        content.setStyle((StyleElement)style);
        content.setExtendsElement((DesignElement)parent);
        DesignElement obj = this.container.getSlot(0).getContent(0);
        ContentCommandTest.assertEquals((Object)content, (Object)obj);
        ContentCommandTest.assertEquals((Object)style, (Object)content.getStyle());
        ContentCommandTest.assertNotNull((Object)content.getExtendsElement());
        this.containerHandle.getSlot(0).dropAndClear(0);
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 0 ? 1 : 0) != 0);
        ContentCommandTest.assertNull((Object)content.getStyle());
        ContentCommandTest.assertNull((Object)content.getExtendsElement());
        ContentCommandTest.assertEquals((int)0, (int)style.getClientList().size());
        ContentCommandTest.assertEquals((int)0, (int)parent.getSlot(0).getCount());
        ContentCommandTest.assertEquals((int)0, (int)parent.getDerived().size());
        ContentCommandTest.assertFalse((boolean)as.canRedo());
        ContentCommandTest.assertTrue((boolean)as.canUndo());
        as.undo();
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 1 ? 1 : 0) != 0);
        ContentCommandTest.assertEquals((Object)style, (Object)content.getStyle());
        ContentCommandTest.assertEquals((Object)content, (Object)((BackRef)style.getClientList().get(0)).getElement());
        ContentCommandTest.assertEquals((Object)parent, (Object)content.getExtendsElement());
        ContentCommandTest.assertEquals((Object)content, parent.getDescendents().get(0));
        ContentCommandTest.assertTrue((boolean)as.canRedo());
        ContentCommandTest.assertTrue((boolean)as.canUndo());
        as.undo();
        ContentCommandTest.assertTrue((this.container.getSlot(0).getCount() == 0 ? 1 : 0) != 0);
        ContentCommandTest.assertTrue((boolean)as.canRedo());
    }

    public void testOtherMoveException() {
        GraphicMasterPage toContainer = new GraphicMasterPage();
        FreeForm content = new FreeForm();
        Label label = new Label();
        try {
            ContentCommand command = new ContentCommand((Module)this.design, new ContainerContext((DesignElement)new Label(), 0));
            command.move((DesignElement)content, new ContainerContext((DesignElement)toContainer, 0));
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.NOT_CONTAINER", (String)e.getErrorCode());
        }
        try {
            this.containerHandle.getSlot(0).move(content.getHandle((Module)this.design), label.getHandle((Module)this.design), 0);
            ContentCommandTest.fail();
        }
        catch (ContentException e1) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.NOT_CONTAINER", (String)e1.getErrorCode());
        }
        try {
            this.containerHandle.getSlot(0).move(content.getHandle((Module)this.design), toContainer.getHandle((Module)this.design), 0);
            ContentCommandTest.fail();
        }
        catch (ContentException e2) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.CONTENT_NOT_FOUND", (String)e2.getErrorCode());
        }
    }

    public void testMovePosition() throws Exception {
        Label A = new Label();
        A.setName("A");
        Label B = new Label();
        B.setName("B");
        Label C = new Label();
        C.setName("C");
        ActivityStack as = this.design.getActivityStack();
        this.containerHandle.getSlot(0).add(A.getHandle((Module)this.design));
        this.containerHandle.getSlot(0).add(B.getHandle((Module)this.design));
        this.containerHandle.getSlot(0).add(C.getHandle((Module)this.design));
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
        this.containerHandle.getSlot(0).shift(A.getHandle((Module)this.design), 0);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
        this.containerHandle.getSlot(0).shift(A.getHandle((Module)this.design), 1);
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
        this.containerHandle.getSlot(0).shift(A.getHandle((Module)this.design), 2);
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(2));
        as.undo();
        this.containerHandle.getSlot(0).shift(A.getHandle((Module)this.design), 3);
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(2));
        as.undo();
        this.containerHandle.getSlot(0).shift(B.getHandle((Module)this.design), 0);
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
        as.undo();
        this.containerHandle.getSlot(0).shift(B.getHandle((Module)this.design), 1);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
        this.containerHandle.getSlot(0).shift(B.getHandle((Module)this.design), 2);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(2));
        this.containerHandle.getSlot(0).shift(B.getHandle((Module)this.design), 3);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(2));
        as.undo();
        this.containerHandle.getSlot(0).shift(C.getHandle((Module)this.design), 0);
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(2));
        as.undo();
        this.containerHandle.getSlot(0).shift(C.getHandle((Module)this.design), 1);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(2));
        as.undo();
        as.redo();
        as.undo();
        this.containerHandle.getSlot(0).shift(C.getHandle((Module)this.design), 2);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
        this.containerHandle.getSlot(0).shift(C.getHandle((Module)this.design), 3);
        ContentCommandTest.assertEquals((Object)A, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)B, (Object)this.container.getSlot(0).getContent(1));
        ContentCommandTest.assertEquals((Object)C, (Object)this.container.getSlot(0).getContent(2));
    }

    public void testMove() throws Exception {
        FreeForm toContainer = new FreeForm();
        this.designHandle.getBody().add((DesignElement)toContainer);
        GraphicMasterPage page = new GraphicMasterPage("test_page");
        GraphicMasterPageHandle pageHandle = page.handle((Module)this.design);
        this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
        Label label1 = new Label();
        Label label2 = new Label();
        SlotHandle sHandle = pageHandle.getContent();
        sHandle.add(label1.getHandle((Module)this.design));
        sHandle.move((DesignElementHandle)label1.handle((Module)this.design), (DesignElementHandle)toContainer.handle((Module)this.design), 0);
        ContentCommandTest.assertEquals((int)sHandle.getCount(), (int)0);
        ContentCommandTest.assertEquals((int)1, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        sHandle.add(label2.getHandle((Module)this.design));
        ContentCommandTest.assertEquals((int)sHandle.getCount(), (int)1);
        sHandle.move((DesignElementHandle)label2.handle((Module)this.design), (DesignElementHandle)toContainer.handle((Module)this.design), 0, 0);
        ContentCommandTest.assertEquals((int)sHandle.getCount(), (int)0);
        ContentCommandTest.assertEquals((int)2, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        ContentCommandTest.assertEquals((Object)label2, (Object)toContainer.handle((Module)this.design).getReportItems().get(0).getElement());
        this.design.getActivityStack().undo();
        ContentCommandTest.assertEquals((int)1, (int)sHandle.getCount());
        ContentCommandTest.assertEquals((int)1, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        this.design.getActivityStack().redo();
        ContentCommandTest.assertEquals((int)sHandle.getCount(), (int)0);
        ContentCommandTest.assertEquals((int)2, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        ContentCommandTest.assertEquals((Object)label2, (Object)toContainer.handle((Module)this.design).getReportItems().get(0).getElement());
        Label label3 = new Label();
        sHandle.add(label3.getHandle((Module)this.design));
        sHandle.move((DesignElementHandle)label3.handle((Module)this.design), (DesignElementHandle)toContainer.handle((Module)this.design), 0, 10);
        ContentCommandTest.assertEquals((int)3, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        ContentCommandTest.assertEquals((Object)label3, (Object)toContainer.handle((Module)this.design).getReportItems().get(2).getElement());
        Label label4 = new Label();
        sHandle.add(label4.getHandle((Module)this.design));
        sHandle.move((DesignElementHandle)label4.handle((Module)this.design), (DesignElementHandle)toContainer.handle((Module)this.design), 0, 12);
        ContentCommandTest.assertEquals((int)4, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        ContentCommandTest.assertEquals((Object)label4, (Object)toContainer.handle((Module)this.design).getReportItems().get(3).getElement());
        Label label5 = new Label();
        sHandle.add(label5.getHandle((Module)this.design));
        MyContentListener listener = new MyContentListener();
        label5.addListener((Listener)listener);
        sHandle.move((DesignElementHandle)label5.handle((Module)this.design), (DesignElementHandle)toContainer.handle((Module)this.design), 0, 1);
        ContentCommandTest.assertEquals((int)5, (int)toContainer.handle((Module)this.design).getReportItems().getCount());
        ContentCommandTest.assertEquals((Object)label5, (Object)toContainer.handle((Module)this.design).getReportItems().get(1).getElement());
        label5.getHandle((Module)this.design).setProperty("helpText", (Object)"helptext");
        ContentCommandTest.assertNotNull((Object)listener.event);
        ContentCommandTest.assertEquals((int)5, (int)listener.recieveChangeEvent);
        this.libraryHandle = this.sessionHandle.createLibrary();
        ElementFactory factory = this.libraryHandle.getElementFactory();
        ThemeHandle newTheme = factory.newTheme("testTheme");
        this.libraryHandle.getThemes().add((DesignElementHandle)newTheme);
        SharedStyleHandle style = factory.newStyle("style");
        newTheme.addElement((DesignElementHandle)style, 0);
        style = factory.newStyle("style_1");
        newTheme.addElement((DesignElementHandle)style, 0);
        style = factory.newStyle("table");
        newTheme.addElement((DesignElementHandle)style, 0);
        TableHandle table = factory.newTableItem("testTable");
        this.libraryHandle.getComponents().add((DesignElementHandle)table);
        listener = new MyContentListener();
        table.addListener((Listener)listener);
        style.moveTo(0);
        ContentCommandTest.assertNull((Object)listener.event);
        newTheme = factory.newTheme("them_one");
        this.libraryHandle.getThemes().add((DesignElementHandle)newTheme);
        this.libraryHandle.setTheme(newTheme);
        style.moveTo((DesignElementHandle)newTheme, 0);
        ContentCommandTest.assertNotNull((Object)listener.event);
    }

    public void testMoveWrongType() throws Exception {
        SharedStyleHandle styleHandle = this.factory.newStyle("style1");
        this.designHandle.getStyles().add((DesignElementHandle)styleHandle);
        try {
            this.designHandle.getStyles().move((DesignElementHandle)styleHandle, (DesignElementHandle)this.designHandle, 6);
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.WRONG_TYPE", (String)e.getErrorCode());
        }
        this.designHandle.getMasterPages().add((DesignElementHandle)this.factory.newSimpleMasterPage("page2"));
        ContentCommandTest.assertEquals((int)2, (int)this.designHandle.getMasterPages().getCount());
        ContentCommandTest.assertNotNull((Object)this.designHandle.findMasterPage("page2"));
    }

    public void testMoveSamePosition() throws Exception {
        Label label = new Label();
        FreeForm content = new FreeForm();
        try {
            this.containerHandle.getSlot(0).shift(label.getHandle((Module)this.design), 2);
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.CONTENT_NOT_FOUND", (String)e.getErrorCode());
        }
        this.containerHandle.getSlot(0).add(label.getHandle((Module)this.design));
        this.containerHandle.getSlot(0).add(content.getHandle((Module)this.design));
        this.containerHandle.getSlot(0).add(new Label().getHandle((Module)this.design));
        this.containerHandle.getSlot(0).shift(label.getHandle((Module)this.design), 3);
        ContentCommandTest.assertEquals((Object)label, (Object)this.container.getSlot(0).getContent(2));
        ContentCommandTest.assertEquals((Object)content, (Object)this.container.getSlot(0).getContent(0));
    }

    public void testCircularContent() throws Exception {
        FreeForm content = new FreeForm();
        FreeForm middContainer = new FreeForm();
        FreeForm topContainer = new FreeForm();
        FreeFormHandle topHandle = (FreeFormHandle)topContainer.getHandle((Module)this.design);
        topHandle.getSlot(0).add(content.getHandle((Module)this.design));
        try {
            content.getHandle((Module)this.design).getSlot(0).add(topContainer.getHandle((Module)this.design));
            ContentCommandTest.fail();
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.RECURSIVE", (String)e.getErrorCode());
        }
        middContainer.getHandle((Module)this.design).getSlot(0).add(topContainer.getHandle((Module)this.design));
        try {
            content.getHandle((Module)this.design).getSlot(0).add(middContainer.getHandle((Module)this.design));
        }
        catch (ContentException e) {
            ContentCommandTest.assertEquals((String)"Error.ContentException.RECURSIVE", (String)e.getErrorCode());
        }
    }

    public void testReferencAfterDeletion() throws Exception {
        Label A = new Label();
        A.setName("A");
        SlotHandle containerHandle = this.designHandle.getComponents();
        ContentCommandTest.assertNotNull((Object)containerHandle);
        containerHandle.add(A.getHandle((Module)this.design));
        Label B = new Label();
        B.getHandle((Module)this.design).setName("B");
        Label C = new Label();
        C.getHandle((Module)this.design).setName("C");
        Style style = new Style();
        style.getHandle((Module)this.design).setName("style");
        A.setExtendsElement((DesignElement)B);
        C.setExtendsElement((DesignElement)A);
        A.setStyle((StyleElement)style);
        ContentCommandTest.assertEquals((Object)A, (Object)containerHandle.get(0));
        ContentCommandTest.assertEquals((Object)B, (Object)A.getExtendsElement());
        ContentCommandTest.assertEquals((Object)C, A.getDerived().get(0));
        ContentCommandTest.assertEquals((Object)A, (Object)C.getExtendsElement());
        ContentCommandTest.assertEquals((Object)style, (Object)A.getStyle());
        try {
            containerHandle.dropAndClear(A.getHandle((Module)this.design));
            ContentCommandTest.fail();
        }
        catch (Exception exception) {}
        ContentCommandTest.assertEquals((Object)A, (Object)C.getExtendsElement());
        ContentCommandTest.assertEquals((Object)A, B.getDerived().get(0));
        ContentCommandTest.assertEquals((int)1, (int)style.getClientList().size());
        ContentCommandTest.assertNotNull((Object)A.getStyle());
        ContentCommandTest.assertNotNull((Object)A.getExtendsElement());
    }

    public void testElementReferenceAfterDeletionAndDetachment() throws Exception {
        this.createDataSourceAndDataSet();
        DataSourceHandle dataSourceHandle = this.designHandle.findDataSource("dataSource");
        DataSetHandle dataSetHandle = this.designHandle.findDataSet("dataSet");
        dataSourceHandle.dropAndClear();
        ContentCommandTest.assertEquals(null, (String)dataSetHandle.getDataSourceName());
        ContentCommandTest.assertEquals(null, (Object)dataSetHandle.getDataSource());
        Iterator iter = dataSourceHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)false, (boolean)iter.hasNext());
        this.designHandle.getCommandStack().undo();
        ContentCommandTest.assertEquals((String)dataSourceHandle.getName(), (String)dataSetHandle.getDataSourceName());
        ContentCommandTest.assertEquals((Object)dataSourceHandle, (Object)dataSetHandle.getDataSource());
        iter = dataSourceHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)true, (boolean)iter.hasNext());
        this.createDataSourceAndDataSet();
        dataSourceHandle = this.designHandle.findDataSource("dataSource");
        dataSetHandle = this.designHandle.findDataSet("dataSet");
        dataSourceHandle.drop();
        ContentCommandTest.assertEquals((String)dataSourceHandle.getName(), (String)dataSetHandle.getDataSourceName());
        ContentCommandTest.assertEquals(null, (Object)dataSetHandle.getDataSource());
        iter = dataSourceHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)false, (boolean)iter.hasNext());
        this.designHandle.getCommandStack().undo();
        iter = dataSourceHandle.clientsIterator();
        ContentCommandTest.assertEquals((Object)dataSetHandle, iter.next());
        ContentCommandTest.assertEquals((String)dataSourceHandle.getName(), (String)dataSetHandle.getDataSourceName());
        ContentCommandTest.assertEquals((Object)dataSourceHandle, (Object)dataSetHandle.getDataSource());
    }

    private void createDataSourceAndDataSet() throws Exception {
        this.designHandle = this.createDesign();
        ScriptDataSourceHandle dataSourceHandle = this.designHandle.getElementFactory().newScriptDataSource("dataSource");
        ScriptDataSetHandle dataSetHandle = this.designHandle.getElementFactory().newScriptDataSet("dataSet");
        this.designHandle.getDataSources().add((DesignElementHandle)dataSourceHandle);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        dataSetHandle.setDataSource(dataSourceHandle.getName());
    }

    public void testStyleReferenceAfterDeletionAndDetachment() throws Exception {
        this.createStyleAndLabel();
        SharedStyleHandle styleHandle = this.designHandle.findStyle("style");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        styleHandle.dropAndClear();
        ContentCommandTest.assertEquals(null, (Object)labelHandle.getStyle());
        ContentCommandTest.assertEquals(null, (String)labelHandle.getStringProperty("style"));
        Iterator iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)false, (boolean)iter.hasNext());
        this.designHandle.getCommandStack().undo();
        ContentCommandTest.assertEquals((String)styleHandle.getName(), (String)labelHandle.getStringProperty("style"));
        ContentCommandTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)true, (boolean)iter.hasNext());
        this.createStyleAndLabel();
        styleHandle = this.designHandle.findStyle("style");
        labelHandle = (LabelHandle)this.designHandle.findElement("label");
        styleHandle.drop();
        ContentCommandTest.assertEquals(null, (Object)labelHandle.getStyle());
        ContentCommandTest.assertEquals((String)styleHandle.getName(), (String)labelHandle.getStringProperty("style"));
        iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)false, (boolean)iter.hasNext());
        this.designHandle.getCommandStack().undo();
        ContentCommandTest.assertEquals((String)styleHandle.getName(), (String)labelHandle.getStringProperty("style"));
        ContentCommandTest.assertEquals((Object)styleHandle, (Object)labelHandle.getStyle());
        iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((boolean)true, (boolean)iter.hasNext());
    }

    private void createStyleAndLabel() throws Exception {
        this.designHandle = this.createDesign();
        SharedStyleHandle styleHandle = this.designHandle.getElementFactory().newStyle("style");
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("label");
        this.designHandle.getStyles().add((DesignElementHandle)styleHandle);
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        labelHandle.setStyle(styleHandle);
    }

    public void testRemoveContainerFromContainer() throws Exception {
        FreeForm cont = new FreeForm();
        FreeForm otherCont = new FreeForm();
        Label label = new Label();
        Style style = new Style();
        cont.getHandle((Module)this.design).getSlot(0).add(otherCont.getHandle((Module)this.design));
        otherCont.getHandle((Module)this.design).getSlot(0).add(label.getHandle((Module)this.design));
        this.containerHandle.getSlot(0).add(cont.getHandle((Module)this.design));
        ContentCommandTest.assertEquals((Object)cont, (Object)this.container.getSlot(0).getContent(0));
        ContentCommandTest.assertEquals((Object)otherCont, (Object)cont.getSlot(0).getContent(0));
        this.containerHandle.getSlot(0).dropAndClear(cont.getHandle((Module)this.design));
        ContentCommandTest.assertEquals((int)0, (int)this.container.getSlot(0).getCount());
        ContentCommandTest.assertEquals((int)0, (int)cont.getSlot(0).getCount());
        ContentCommandTest.assertEquals((int)0, (int)otherCont.getSlot(0).getCount());
        ContentCommandTest.assertNull((Object)label.getContainer());
        ContentCommandTest.assertEquals((int)0, (int)style.getClientList().size());
    }

    public void testSendNotifications() throws SemanticException {
        MyContentListener containerListener = new MyContentListener();
        this.designHandle.addListener((Listener)containerListener);
        FreeFormHandle contentHandle = this.designHandle.getElementFactory().newFreeForm("Form1");
        FreeFormHandle contentHandle2 = this.designHandle.getElementFactory().newFreeForm("Form2");
        this.designHandle.getBody().add((DesignElementHandle)contentHandle);
        ContentCommandTest.assertEquals((int)1, (int)containerListener.action);
        ContentCommandTest.assertTrue((boolean)(containerListener.event instanceof ContentEvent));
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)((ContentEvent)containerListener.event).getContent());
        this.designHandle.getBody().add((DesignElementHandle)contentHandle2);
        ContentCommandTest.assertEquals((int)1, (int)containerListener.action);
        ContentCommandTest.assertTrue((boolean)(containerListener.event instanceof ContentEvent));
        ContentCommandTest.assertEquals((Object)contentHandle2.getElement(), (Object)((ContentEvent)containerListener.event).getContent());
        this.designHandle.getBody().shift((DesignElementHandle)contentHandle, 2);
        ContentCommandTest.assertEquals((int)3, (int)containerListener.action);
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)((ContentEvent)containerListener.event).getContent());
        contentHandle.moveTo((DesignElementHandle)this.designHandle, 5);
        ContentCommandTest.assertEquals((int)4, (int)containerListener.action);
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)((ContentEvent)containerListener.event).getContent());
        MyContentListener contentListener = new MyContentListener();
        contentHandle.addListener((Listener)contentListener);
        this.designHandle.getComponents().dropAndClear((DesignElementHandle)contentHandle);
        ContentCommandTest.assertEquals((int)2, (int)containerListener.action);
        ContentCommandTest.assertNull((Object)contentListener.event);
        ContentCommandTest.assertEquals((Object)contentHandle.getElement(), (Object)((ContentEvent)containerListener.event).getContent());
        ContentCommandTest.assertTrue((boolean)(containerListener.event instanceof ContentEvent));
        ContentCommandTest.assertEquals((int)containerListener.action, (int)2);
        ContentCommandTest.assertTrue((containerListener.content == contentHandle.getElement() ? 1 : 0) != 0);
    }

    public void testSendNotificationBeforeDeletion() throws SemanticException {
        OdaDataSetHandle dataSet = this.factory.newOdaDataSet("dataSet", null);
        OdaDataSourceHandle dataSource = this.factory.newOdaDataSource("dataSource", null);
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        this.designHandle.getDataSources().add((DesignElementHandle)dataSource);
        dataSet.setDataSource("dataSource");
        MyContentListener contentListener = new MyContentListener();
        dataSet.addListener((Listener)contentListener);
        this.designHandle.getDataSets().drop((DesignElementHandle)dataSet);
        ContentCommandTest.assertEquals((int)0, (int)contentListener.recieveChangeEvent);
        ContentCommandTest.assertTrue((boolean)(contentListener.event instanceof ElementDeletedEvent));
        dataSet.removeListener((Listener)contentListener);
        contentListener = new MyContentListener();
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        this.designHandle.getDataSources().drop((DesignElementHandle)dataSource);
        dataSet.addListener((Listener)contentListener);
        this.designHandle.getDataSets().drop((DesignElementHandle)dataSet);
        ContentCommandTest.assertEquals((int)0, (int)contentListener.recieveChangeEvent);
        ContentCommandTest.assertTrue((boolean)(contentListener.event instanceof ElementDeletedEvent));
    }

    public void testAddCompoundElement() throws Exception {
        CascadingParameterGroup cascadingGroup = new CascadingParameterGroup("cas1");
        ScalarParameter param1 = new ScalarParameter("param1");
        cascadingGroup.add((DesignElement)param1, 0);
        ScalarParameter param2 = new ScalarParameter("param2");
        cascadingGroup.add((DesignElement)param2, 0);
        this.testCopyAndPasteCompoundElement(cascadingGroup);
    }

    public void testAddCompoundElementFromHandle() throws Exception {
        CascadingParameterGroupHandle cascadingGroupHandle = this.factory.newCascadingParameterGroup("cas1");
        cascadingGroupHandle.getParameters().add((DesignElementHandle)this.designHandle.getElementFactory().newScalarParameter("param1"));
        cascadingGroupHandle.getParameters().add((DesignElementHandle)this.designHandle.getElementFactory().newScalarParameter("param2"));
        this.testCopyAndPasteCompoundElement((CascadingParameterGroup)cascadingGroupHandle.getElement());
    }

    private void testCopyAndPasteCompoundElement(CascadingParameterGroup cacascadingGroup) throws Exception {
        CascadingParameterGroupHandle cascadingGroupHandle = (CascadingParameterGroupHandle)cacascadingGroup.getHandle((Module)this.design);
        this.designHandle.getParameters().add((DesignElementHandle)cascadingGroupHandle);
        IDesignElement clonedCas = cascadingGroupHandle.copy();
        CascadingParameterGroupHandle clonedCasHandle = (CascadingParameterGroupHandle)clonedCas.getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)clonedCasHandle);
        this.designHandle.getParameters().paste((DesignElementHandle)clonedCasHandle);
        NameSpace ns = this.design.getNameHelper().getNameSpace(2);
        ContentCommandTest.assertEquals((String)"param11", (String)clonedCasHandle.getParameters().get(0).getName());
        ContentCommandTest.assertEquals((String)"param21", (String)clonedCasHandle.getParameters().get(1).getName());
        ContentCommandTest.assertTrue((boolean)ns.contains(clonedCasHandle.getParameters().get(0).getName()));
        ContentCommandTest.assertTrue((boolean)ns.contains(clonedCasHandle.getParameters().get(1).getName()));
        clonedCas = cascadingGroupHandle.copy();
        clonedCasHandle = (CascadingParameterGroupHandle)clonedCas.getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)clonedCasHandle);
        this.designHandle.getParameters().paste((DesignElementHandle)clonedCasHandle);
        ns = this.design.getNameHelper().getNameSpace(2);
        ContentCommandTest.assertEquals((String)"param12", (String)clonedCasHandle.getParameters().get(0).getName());
        ContentCommandTest.assertEquals((String)"param22", (String)clonedCasHandle.getParameters().get(1).getName());
        ContentCommandTest.assertTrue((boolean)ns.contains(clonedCasHandle.getParameters().get(0).getName()));
        ContentCommandTest.assertTrue((boolean)ns.contains(clonedCasHandle.getParameters().get(1).getName()));
    }

    public void testGroupUniqueName() throws Exception {
        MyGroupListener groupListener = new MyGroupListener();
        TableHandle tableHandle = this.factory.newTableItem("table1");
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        TableGroupHandle groupHandle = this.factory.newTableGroup();
        groupHandle.addListener((Listener)groupListener);
        ContentCommand command = new ContentCommand((Module)this.design, new ContainerContext(tableHandle.getElement(), 1));
        command.add(groupHandle.getElement());
        ContentCommandTest.assertEquals((int)5, (int)groupListener.action);
        ContentCommandTest.assertNotNull((Object)groupListener);
        ContentCommandTest.assertEquals((String)"groupName", (String)groupListener.name);
    }

    public void testTemplateDefinition() throws Exception {
        SlotHandle templateDefinitions = this.designHandle.getSlot(8);
        ContentCommandTest.assertEquals((int)0, (int)templateDefinitions.getCount());
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        this.designHandle.getBody().add((DesignElementHandle)label);
        ContentCommandTest.assertEquals((Object)this.designHandle, (Object)label.getRoot());
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)label.createTemplateElement("templateLabel");
        ContentCommandTest.assertEquals((int)1, (int)templateDefinitions.getCount());
        label = this.designHandle.getElementFactory().newLabel("label1");
        templateLabel.transformToReportItem((ReportItemHandle)label);
        ContentCommandTest.assertEquals((Object)this.designHandle, (Object)label.getRoot());
        ContentCommandTest.assertNotNull((Object)label.getElement().getTemplateParameterElement((Module)this.design));
        ContentCommandTest.assertEquals((int)1, (int)templateDefinitions.getCount());
        label.drop();
        ContentCommandTest.assertNull((Object)label.getRoot());
        ContentCommandTest.assertEquals((int)0, (int)templateDefinitions.getCount());
    }

    public void testElementProperty() throws Exception {
        this.openDesign("ContentCommandTest.xml");
        ExtendedItemHandle outExtendedItem = (ExtendedItemHandle)this.designHandle.findElement("testBox");
        ExtendedItemHandle innerExtendedItem = (ExtendedItemHandle)this.designHandle.findElement("detailBox");
        TableHandle innerTable = (TableHandle)this.designHandle.findElement("testTable");
        CommandStack stack = this.designHandle.getCommandStack();
        outExtendedItem.drop();
        ContentCommandTest.assertNull((Object)outExtendedItem.getContainer());
        ContentCommandTest.assertNull((Object)innerTable.getContainer());
        ContentCommandTest.assertNull((Object)innerExtendedItem.getContainer());
        ContentCommandTest.assertNull((Object)this.designHandle.findElement(outExtendedItem.getName()));
        ContentCommandTest.assertNull((Object)this.designHandle.findElement(innerTable.getName()));
        ContentCommandTest.assertNull((Object)this.designHandle.findElement(innerExtendedItem.getName()));
        ContentCommandTest.assertNull((Object)this.designHandle.getElementByID(outExtendedItem.getID()));
        ContentCommandTest.assertNull((Object)this.designHandle.getElementByID(innerTable.getID()));
        ContentCommandTest.assertNull((Object)this.designHandle.getElementByID(innerExtendedItem.getID()));
        stack.undo();
        ContentCommandTest.assertNotNull((Object)outExtendedItem.getContainer());
        ContentCommandTest.assertNotNull((Object)innerTable.getContainer());
        ContentCommandTest.assertNotNull((Object)innerExtendedItem.getContainer());
        ContentCommandTest.assertEquals((Object)outExtendedItem, (Object)this.designHandle.findElement(outExtendedItem.getName()));
        ContentCommandTest.assertEquals((Object)innerTable, (Object)this.designHandle.findElement(innerTable.getName()));
        ContentCommandTest.assertEquals((Object)innerExtendedItem, (Object)this.designHandle.findElement(innerExtendedItem.getName()));
        ContentCommandTest.assertEquals((Object)outExtendedItem, (Object)this.designHandle.getElementByID(outExtendedItem.getID()));
        ContentCommandTest.assertEquals((Object)innerTable, (Object)this.designHandle.getElementByID(innerTable.getID()));
        ContentCommandTest.assertEquals((Object)innerExtendedItem, (Object)this.designHandle.getElementByID(innerExtendedItem.getID()));
    }

    public void testRemoveReferencableElement() throws Exception {
        this.openDesign("ContentCommandTest_1.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("Customer Cube");
        List conditions = cube.getListProperty("dimensionConditions");
        int i = 0;
        while (i < conditions.size()) {
            DimensionCondition dimensionCond = (DimensionCondition)conditions.get(i);
            List joinConditions = (List)dimensionCond.getProperty((Module)this.design, "joinConditions");
            int j = 0;
            while (j < joinConditions.size()) {
                DimensionJoinCondition dimensionJoinCond = (DimensionJoinCondition)joinConditions.get(j);
                dimensionJoinCond.getProperty((Module)this.design, "level");
                ++j;
            }
            ++i;
        }
        cube.getDimension("Region").dropAndClear();
        this.save();
        ContentCommandTest.assertTrue((boolean)this.compareFile("ContentCommandTest_golden.xml"));
    }

    public void testRemoveTemplateParameterDefinition() throws Exception {
        this.openDesign("TemplatePrarmeterDefinitionTest.xml");
        ActivityStack as = this.design.getActivityStack();
        DesignElementHandle handle = this.designHandle.getElementByID(356L);
        handle.dropAndClear();
        as.undo();
        this.save();
        ContentCommandTest.assertTrue((boolean)this.compareFile("TemplatePrarmeterDefinitionTest_golden.xml"));
    }

    public void testCopyAndPaste() throws Exception {
        this.openDesign("ContentCommandTest_2.xml");
        SharedStyleHandle styleHandle = this.designHandle.findStyle("NewStyle");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.getElementByID(7L);
        Iterator iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((Object)labelHandle, iter.next());
        ContentCommandTest.assertFalse((boolean)iter.hasNext());
        IDesignElement copiedLabel = labelHandle.copy();
        DesignElementHandle copiedLableHandle = copiedLabel.getHandle((Module)this.design);
        this.designHandle.getBody().paste(copiedLableHandle);
        iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((Object)labelHandle, iter.next());
        ContentCommandTest.assertEquals((Object)copiedLableHandle, iter.next());
        ContentCommandTest.assertFalse((boolean)iter.hasNext());
        ActivityStack as = this.design.getActivityStack();
        as.undo();
        iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((Object)labelHandle, iter.next());
        ContentCommandTest.assertFalse((boolean)iter.hasNext());
        as.redo();
        iter = styleHandle.clientsIterator();
        ContentCommandTest.assertEquals((Object)labelHandle, iter.next());
        ContentCommandTest.assertFalse((boolean)iter.hasNext());
    }

    class MyContentListener
    implements Listener {
        static final int NA = 0;
        static final int ADDED = 1;
        static final int REMOVED = 2;
        static final int SHIFTED = 3;
        static final int MOVED = 4;
        static final int CHANGE = 5;
        NotificationEvent event = null;
        int action = 0;
        int recieveChangeEvent = 0;
        IDesignElement content = null;

        MyContentListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 0) {
                this.event = ev;
                int newAcion = ((ContentEvent)ev).getAction();
                this.content = ((ContentEvent)ev).getContent();
                if (this.action == 2 && newAcion == 1) {
                    this.action = 4;
                } else {
                    switch (newAcion) {
                        case 1: {
                            this.action = 1;
                            break;
                        }
                        case 2: {
                            this.action = 2;
                            break;
                        }
                        case 3: {
                            this.action = 3;
                        }
                    }
                }
            } else if (ev.getEventType() == 1) {
                this.event = ev;
            } else if (ev.getEventType() == 5) {
                this.event = ev;
                this.recieveChangeEvent = 5;
            } else if (ev.getEventType() == 6) {
                this.event = ev;
            }
        }
    }

    class MyGroupListener
    implements Listener {
        int action = -1;
        PropertyEvent event = null;
        String name = null;

        MyGroupListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev instanceof PropertyEvent) {
                this.event = (PropertyEvent)ev;
                this.action = this.event.getEventType();
                this.name = this.event.getPropertyName();
            }
        }
    }
}

