/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ContentExceptionTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        table.setName("customerTable");
        this.os = new ByteArrayOutputStream();
        TableRow row = new TableRow();
        ContentException error = new ContentException((DesignElement)table, 4, "Error.ContentException.SLOT_NOT_FOUND");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, (DesignElement)row, "Error.ContentException.WRONG_TYPE");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, (DesignElement)row, "Error.ContentException.CONTENT_NOT_FOUND");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, "Error.ContentException.NOT_CONTAINER");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, "Error.ContentException.SLOT_IS_FULL");
        error = new ContentException((DesignElement)row, 4, (DesignElement)table, "Error.ContentException.RECURSIVE");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, "Error.ContentException.HAS_NO_CONTAINER");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, "Error.ContentException.MOVE_FORBIDDEN");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, "Error.ContentException.HAS_DESCENDENTS");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, (DesignElement)row, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, (DesignElement)row, "Error.ContentException.CONTENT_NAME_REQUIRED");
        this.print(error);
        error = new ContentException((DesignElement)table, 4, (DesignElement)new TemplateReportItem("test"), "Error.ContentException.INVALID_TEMPLATE_ELEMENT");
        this.print(error);
        this.os.close();
        ContentExceptionTest.assertTrue((boolean)this.compareFile("ContentExceptionError.golden.txt"));
    }

    private void print(ContentException error) {
        block3: {
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }
}

