/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CustomMsgEvent;
import org.eclipse.birt.report.model.api.command.CustomMsgException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.command.CustomMsgCommand;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CustomMsgCommandTest
extends BaseTestCase {
    CustomMsgCommand command = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("CustomMsgCommandTest.xml");
        this.command = new CustomMsgCommand((Module)this.design);
    }

    public void testAddTranslation() throws CustomMsgException {
        CustomMsgCommandTest.assertEquals((int)6, (int)this.design.getTranslations().size());
        String resourceKey = "ResourceKey.Element1.Title";
        String locale = "zh_CN";
        String text = "New element";
        this.command.addTranslation(resourceKey, locale, text);
        CustomMsgCommandTest.assertNotNull((Object)this.design.findTranslation(resourceKey, locale));
        CustomMsgCommandTest.assertEquals((int)7, (int)this.design.getTranslations().size());
        try {
            this.command.addTranslation(resourceKey, locale, text);
            CustomMsgCommandTest.fail();
        }
        catch (CustomMsgException e) {
            CustomMsgCommandTest.assertEquals((String)"Error.CustomMsgException.DUPLICATE_LOCALE", (String)e.getErrorCode());
        }
        resourceKey = "";
        locale = "en";
        try {
            this.command.addTranslation(resourceKey, locale, text);
            CustomMsgCommandTest.fail();
        }
        catch (CustomMsgException e) {
            CustomMsgCommandTest.assertEquals((String)"Error.CustomMsgException.RESOURCE_KEY_REQUIRED", (String)e.getErrorCode());
        }
    }

    public void testDropTranslation() throws CustomMsgException {
        CustomMsgCommandTest.assertEquals((int)6, (int)this.design.getTranslations().size());
        String resourceKey = "ResourceKey.ReportDesign.Title";
        String locale = null;
        this.command.dropTranslation(resourceKey, locale);
        CustomMsgCommandTest.assertEquals((int)5, (int)this.design.getTranslations().size());
        CustomMsgCommandTest.assertNull((Object)this.design.findTranslation(resourceKey, locale));
        try {
            this.command.dropTranslation(null, locale);
            CustomMsgCommandTest.fail();
        }
        catch (CustomMsgException e) {
            CustomMsgCommandTest.assertEquals((String)"Error.CustomMsgException.TRANSLATION_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testSetULocale() throws CustomMsgException {
        Translation translation = this.design.findTranslation("ResourceKey.ReportDesign.Title", "zh_CN");
        CustomMsgCommandTest.assertNotNull((Object)translation);
        this.command.setLocale(translation, "fr");
        CustomMsgCommandTest.assertEquals((String)"fr", (String)translation.getLocale());
        try {
            this.command.setLocale(translation, "en");
            CustomMsgCommandTest.fail();
        }
        catch (CustomMsgException e) {
            CustomMsgCommandTest.assertEquals((String)"Error.CustomMsgException.DUPLICATE_LOCALE", (String)e.getErrorCode());
        }
    }

    public void testSetText() throws CustomMsgException {
        String resourceKey = "ResourceKey.ReportDesign.Title";
        String locale = "zh_CN";
        String oldText = "zh_CN:\u7b80\u5355\u62a5\u8868.";
        String newText = "new Text";
        Translation translation = this.design.findTranslation(resourceKey, locale);
        CustomMsgCommandTest.assertEquals((String)oldText, (String)translation.getText());
        this.command.setText(translation, newText);
        translation = this.design.findTranslation(resourceKey, locale);
        CustomMsgCommandTest.assertEquals((String)newText, (String)translation.getText());
        try {
            this.command.setText(new Translation("none-exsit-resourceKey", "zh_CN"), newText);
            CustomMsgCommandTest.fail();
        }
        catch (CustomMsgException e) {
            CustomMsgCommandTest.assertEquals((String)"Error.CustomMsgException.TRANSLATION_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testWriter() throws Exception {
        this.save();
        CustomMsgCommandTest.assertTrue((boolean)this.compareFile("CustomMsgCommandTest_golden.xml"));
    }

    public void testNotification() throws Exception {
        String resourceKey = "ResourceKey.Element1.TestKey";
        String locale = "zh_CN";
        String text = "New element";
        MyCustomMsgListener listener = new MyCustomMsgListener();
        this.design.addListener((Listener)listener);
        this.command.addTranslation(resourceKey, locale, text);
        CustomMsgCommandTest.assertEquals((int)1, (int)listener.action);
        this.command.dropTranslation(resourceKey, locale);
        CustomMsgCommandTest.assertEquals((int)2, (int)listener.action);
    }

    class MyCustomMsgListener
    implements Listener {
        static final int NA = 0;
        static final int ADDED = 1;
        static final int REMOVED = 2;
        CustomMsgEvent event = null;
        int action = 0;

        MyCustomMsgListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            CustomMsgEvent event = (CustomMsgEvent)ev;
            switch (event.getAction()) {
                case 0: {
                    this.event = event;
                    this.action = 1;
                    break;
                }
                case 1: {
                    this.event = event;
                    this.action = 2;
                    break;
                }
            }
        }
    }
}

