/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleCommandTest
extends BaseTestCase {
    SharedStyleHandle style;
    private static final String fileName = "StyleCommandTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(fileName);
        StyleCommandTest.assertNotNull((Object)this.design);
        StyleCommandTest.assertNotNull((Object)this.designHandle);
        this.style = this.designHandle.findStyle("My-Style");
    }

    public void testSetStyle() throws Exception {
        ScalarParameter param = new ScalarParameter();
        try {
            param.getHandle((Module)this.design).setStyleName("helloStyle");
            StyleCommandTest.fail();
        }
        catch (StyleException e) {
            StyleCommandTest.assertEquals((String)"Error.StyleException.FORBIDDEN", (String)e.getErrorCode());
        }
        Label label = new Label();
        try {
            label.getHandle((Module)this.design).setStyleName("worldStyle");
            StyleCommandTest.fail();
        }
        catch (StyleException e) {
            StyleCommandTest.assertEquals((String)"Error.StyleException.NOT_FOUND", (String)e.getErrorCode());
        }
        label.getHandle((Module)this.design).setStyleName(this.style.getName());
        StyleCommandTest.assertEquals((String)this.style.getName(), (String)label.getStyleName());
        Label newLabel = new Label();
        this.setStyleMethod((DesignElement)newLabel);
    }

    private void setStyleMethod(DesignElement element) throws StyleException, Exception {
        ActivityStack cs = (ActivityStack)this.designHandle.getCommandStack();
        cs.flush();
        element.getHandle((Module)this.design).setStyle(this.style);
        StyleCommandTest.assertEquals((Object)this.style.getElement(), (Object)element.getStyle());
        this.undoOperate(element, cs);
        this.redoOperate(element, cs);
        element.getHandle((Module)this.design).setStyle(null);
        StyleCommandTest.assertNull((Object)element.getStyle());
    }

    public void testNotification() throws Exception {
        SharedStyleHandle style1 = this.designHandle.findStyle("Style1");
        StyleCommandTest.assertNull((Object)style1.getProperty("highlightRules"));
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        this.designHandle.getBody().add((DesignElementHandle)label);
        MyStyleListener listener = new MyStyleListener();
        label.addListener((Listener)listener);
        label.setStyle(style1);
        StyleCommandTest.assertTrue((boolean)listener.styleChanged);
        label.removeListener((Listener)listener);
    }

    private void undoOperate(DesignElement labelElement, ActivityStack cs) {
        StyleCommandTest.assertTrue((boolean)cs.canUndo());
        StyleCommandTest.assertFalse((boolean)cs.canRedo());
        cs.undo();
        StyleCommandTest.assertNull((Object)labelElement.getStyle());
        StyleCommandTest.assertFalse((boolean)cs.canUndo());
        StyleCommandTest.assertTrue((boolean)cs.canRedo());
        cs.redo();
        cs.undo();
    }

    private void redoOperate(DesignElement labelElement, ActivityStack cs) {
        StyleCommandTest.assertFalse((boolean)cs.canUndo());
        StyleCommandTest.assertTrue((boolean)cs.canRedo());
        cs.redo();
        StyleCommandTest.assertEquals((Object)this.style.getElement(), (Object)labelElement.getStyle());
        StyleCommandTest.assertFalse((boolean)cs.canRedo());
        StyleCommandTest.assertTrue((boolean)cs.canUndo());
        cs.undo();
        cs.redo();
    }

    public void testSetStyleElement() throws Exception {
        Label label = new Label();
        this.setStyleMethod((DesignElement)label);
    }

    public void testExtendsAndClients() throws Exception {
        Label label = new Label();
        label.setName("newLabel");
        this.designHandle.getComponents().add(label.getHandle((Module)this.design));
        StyleCommandTest.assertEquals((int)((StyleElement)this.style.getElement()).getClientList().size(), (int)0);
        label.getHandle((Module)this.design).setStyle(this.style);
        StyleCommandTest.assertEquals((int)((StyleElement)this.style.getElement()).getClientList().size(), (int)1);
        this.style.setName("new_style");
        StyleCommandTest.assertEquals((String)"new_style", (String)label.getStyleName());
        label.getHandle((Module)this.design).setStyle(null);
        StyleCommandTest.assertEquals((int)((StyleElement)this.style.getElement()).getClientList().size(), (int)0);
        String styleName = "new-named-style";
        this.style = this.designHandle.getElementFactory().newStyle(styleName);
        this.designHandle.getSlot(0).add((DesignElementHandle)this.style);
        label.getHandle((Module)this.design).setStyle(this.style);
        Label label1 = new Label();
        label.getHandle((Module)this.design).setName("label");
        label1.getHandle((Module)this.design).setExtendsElement((DesignElement)label);
        StyleCommandTest.assertNull((Object)label1.getHandle((Module)this.design).getStyle());
        label1.getHandle((Module)this.design).setStyle(this.style);
        StyleCommandTest.assertEquals((int)((StyleElement)this.style.getElement()).getClientList().size(), (int)2);
        StyleCommandTest.assertEquals((String)styleName, (String)label1.getStyleName());
        Style tmpStyle = new Style();
        styleName = "another-new-style";
        tmpStyle.getHandle((Module)this.design).setName(styleName);
        this.designHandle.getSlot(0).add(tmpStyle.getHandle((Module)this.design));
        label.getHandle((Module)this.design).setStyleElement((StyleElement)tmpStyle);
        StyleCommandTest.assertEquals((String)styleName, (String)label.getStyleName());
        StyleCommandTest.assertEquals((String)"new-named-style", (String)label1.getStyleName());
    }

    class MyStyleListener
    implements Listener {
        boolean styleChanged = false;

        MyStyleListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.styleChanged = true;
        }
    }
}

