/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleExceptionTest
extends BaseTestCase {
    public void testErrorMessages() throws Exception {
        TableItem table = new TableItem();
        this.os = new ByteArrayOutputStream();
        table.setName("customerTable");
        StyleException error = new StyleException((DesignElement)table, "style1", "Error.StyleException.FORBIDDEN");
        this.print(error);
        error = new StyleException((DesignElement)table, "style1", "Error.StyleException.NOT_FOUND");
        this.print(error);
        this.os.close();
        StyleExceptionTest.assertTrue((boolean)this.compareFile("StyleExceptionError.golden.txt"));
    }

    private void print(StyleException error) {
        block3: {
            String code = error.getErrorCode();
            try {
                this.os.write(code.getBytes());
                int i = code.length();
                while (i < 60) {
                    this.os.write(32);
                    ++i;
                }
                this.os.write(error.getMessage().getBytes());
                this.os.write(10);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testModelException() {
        SemanticException e = new SemanticException((DesignElement)new Label(), "test error code");
        StyleExceptionTest.assertEquals((String)"org.eclipse.birt.report.model", (String)e.getPluginId());
    }
}

