/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DesignElementCopyPropertyToTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testCopyPropertiesTo() throws Exception {
        this.openDesign("DesignElementCopyPropertyToTest.xml");
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("grid1");
        DesignElementCopyPropertyToTest.assertNotNull((Object)gridHandle);
        GridHandle newGridHandle = this.designHandle.getElementFactory().newGridItem("newGrid");
        gridHandle.copyPropertyTo("style", (DesignElementHandle)newGridHandle);
        Object obj = newGridHandle.getProperty("style");
        DesignElementCopyPropertyToTest.assertNotNull((Object)obj);
        DesignElementCopyPropertyToTest.assertEquals((String)"style1", (String)((String)obj));
        DesignElementCopyPropertyToTest.assertEquals((String)"style1", (String)newGridHandle.getStyle().getName());
        gridHandle.copyPropertyTo("dataSet", (DesignElementHandle)newGridHandle);
        DesignElementCopyPropertyToTest.assertEquals((String)"MyDataSet", (String)newGridHandle.getDataSet().getName());
        gridHandle.copyPropertyTo("x", (DesignElementHandle)newGridHandle);
        DesignElementCopyPropertyToTest.assertEquals((String)"12mm", (String)newGridHandle.getX().getStringValue());
        gridHandle.copyPropertyTo("paramBindings", (DesignElementHandle)newGridHandle);
        PropertyHandle propHandle = newGridHandle.getPropertyHandle("paramBindings");
        Iterator iter = propHandle.iterator();
        DesignElementCopyPropertyToTest.assertEquals((String)"param1", (String)((ParamBindingHandle)iter.next()).getParamName());
        DesignElementCopyPropertyToTest.assertEquals((String)"param2", (String)((ParamBindingHandle)iter.next()).getParamName());
        DesignElementCopyPropertyToTest.assertEquals(null, iter.next());
        this.designHandle.getBody().add((DesignElementHandle)newGridHandle);
        DesignElementCopyPropertyToTest.assertEquals((String)"style1", (String)newGridHandle.getStyle().getName());
        DesignElementCopyPropertyToTest.assertEquals((String)"MyDataSet", (String)newGridHandle.getDataSet().getName());
        DesignElementCopyPropertyToTest.assertEquals((String)"12mm", (String)newGridHandle.getX().getStringValue());
    }

    public void testCopyingForbiddenProperty() throws Exception {
        this.openDesign("DesignElementCopyPropertyToTest.xml");
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("grid1");
        DesignElementCopyPropertyToTest.assertNotNull((Object)gridHandle);
        GridHandle newGridHandle = this.designHandle.getElementFactory().newGridItem("newGrid");
        try {
            gridHandle.copyPropertyTo("name", (DesignElementHandle)newGridHandle);
            DesignElementCopyPropertyToTest.fail();
        }
        catch (SemanticException e) {
            DesignElementCopyPropertyToTest.assertEquals((String)"Error.SemanticError.PROPERTY_COPY_FORBIDDEN", (String)e.getErrorCode());
            DesignElementCopyPropertyToTest.assertEquals((String)"newGrid", (String)newGridHandle.getName());
        }
        try {
            gridHandle.copyPropertyTo("extends", (DesignElementHandle)newGridHandle);
            DesignElementCopyPropertyToTest.fail();
        }
        catch (SemanticException e) {
            DesignElementCopyPropertyToTest.assertEquals((String)"Error.SemanticError.PROPERTY_COPY_FORBIDDEN", (String)e.getErrorCode());
            DesignElementCopyPropertyToTest.assertEquals(null, (Object)newGridHandle.getExtends());
        }
    }
}

