/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyStructureCloneTest
extends BaseTestCase {
    private static final String INPUT_FILE = "PropertyStructureCloneTest.xml";
    private static final String GOLDEN_FILE = "PropertyStructureCloneTest_golden.xml";
    private static final String GOLDEN_FILE1 = "PropertyStructureCloneTest1_golden.xml";

    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(INPUT_FILE);
    }

    public void testCopy() throws Exception {
        ImageHandle image1 = (ImageHandle)this.designHandle.findElement("Image1");
        ActionHandle actionHandle = image1.getActionHandle();
        Action action = (Action)actionHandle.getStructure();
        PropertyStructureCloneTest.assertNotNull((Object)action);
        ImageHandle image2 = (ImageHandle)this.designHandle.findElement("Image2");
        image2.setAction((Action)action.copy());
        actionHandle.setURI("www.sina.com.cn\\abc.jsp");
        actionHandle.setLinkType("hyperlink");
        this.save();
        PropertyStructureCloneTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE));
    }

    public void testCopy2() throws Exception {
        ImageHandle image1 = (ImageHandle)this.designHandle.findElement("Image1");
        ActionHandle actionHandle = image1.getActionHandle();
        Action action = (Action)actionHandle.getStructure();
        PropertyStructureCloneTest.assertNotNull((Object)action);
        ImageHandle image2 = (ImageHandle)this.designHandle.findElement("Image2");
        image2.setAction((Action)action.copy());
        MemberHandle paramsHandle = actionHandle.getParamBindings();
        ParamBindingHandle param1 = (ParamBindingHandle)paramsHandle.getAt(0);
        param1.setExpression("new Expression");
        this.save();
        PropertyStructureCloneTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE1));
    }
}

