/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import com.ibm.icu.util.ULocale;
import java.net.URLDecoder;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportDesignTest
extends BaseTestCase {
    private String fileName = "ReportDesignTest.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testMakeUniqueName() throws DesignFileException {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        ElementFactory elementFactory = new ElementFactory((Module)this.design);
        OdaDataSetHandle dataSetHandle = elementFactory.newOdaDataSet(null);
        ReportDesignTest.assertEquals((String)"NewOdaDataSet", (String)dataSetHandle.getElement().getName());
        dataSetHandle = elementFactory.newOdaDataSet("firstDataSet");
        ReportDesignTest.assertEquals((String)"firstDataSet1", (String)dataSetHandle.getElement().getName());
        dataSetHandle = elementFactory.newOdaDataSet("firstDataSet10");
        ReportDesignTest.assertEquals((String)"firstDataSet10", (String)dataSetHandle.getElement().getName());
    }

    public void testIsFileExist() throws Exception {
        this.openDesign(this.fileName);
        String base = this.designHandle.getBase();
        ReportDesignTest.assertNull((Object)base);
        ReportDesignTest.assertTrue((boolean)this.design.isFileExist("ReportDesignTest.xml", 1));
        base = this.getResource("input/ReportDesignTest.xml").getFile();
        base = URLDecoder.decode(base, "UTF-8");
        this.design.setFileName(base);
        ReportDesignTest.assertTrue((boolean)this.design.isFileExist("./ReportDesignTest.xml", 1));
        ReportDesignTest.assertFalse((boolean)this.design.isFileExist("1.jpg", 1));
    }
}

