/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleGroupElementHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportItemExtensionTest
extends BaseTestCase {
    String fileName = "ExtensionTest.xml";
    String goldenFileName_1 = "ExtensionTest_golden_1.xml";
    String goldenFileName_2 = "ExtensionTest_golden_2.xml";
    String goldenFileName_3 = "ExtensionTest_golden_3.xml";
    String checkFileName = "ExtensionTest_1.xml";
    String fileName_2 = "ExtensionTest_2.xml";
    String fileName_3 = "ExtensionTest_3.xml";
    String fileName_4 = "ExtensionTest_4.xml";
    String fileName_5 = "ExtensionTest_5.xml";
    String fileName_6 = "ExtensionTest_6.xml";
    String fileName_7 = "ExtensionTest_7.xml";
    String fileName_8 = "ExtensionTest_8.xml";
    String fileName_9 = "ExtensionTest_9.xml";
    String fileName_10 = "ExtensionTest_10.xml";
    protected static final String TESTING_MATRIX_NAME = "TestingMatrix";
    protected static final String TESTING_BOX_NAME = "TestingBox";
    private static final String TESTING_TABLE_NAME = "TestingTable";

    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
    }

    public void testExtensionMeta() throws Exception {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ReportItemExtensionTest.assertTrue((dd.getExtensions().size() >= 2 ? 1 : 0) != 0);
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(TESTING_MATRIX_NAME);
        ReportItemExtensionTest.assertNotNull((Object)extDefn);
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)extDefn.getDisplayName());
        ReportItemExtensionTest.assertEquals((Object)"Element.TestingMatrix", (Object)extDefn.getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)extDefn.getName());
        ReportItemExtensionTest.assertEquals((int)2, (int)extDefn.getNameOption());
        ReportItemExtensionTest.assertEquals((boolean)true, (boolean)extDefn.allowsUserProperties());
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)extDefn.getName());
        List propList = extDefn.getProperties();
        ReportItemExtensionTest.assertNotNull((Object)extDefn.getProperty("extensionName"));
        ElementPropertyDefn prop = (ElementPropertyDefn)propList.get(0);
        ReportItemExtensionTest.assertEquals((Object)prop, (Object)extDefn.getProperty("test1"));
        ReportItemExtensionTest.assertEquals((String)"test1", (String)prop.getName());
        ReportItemExtensionTest.assertEquals((String)"Test1", (String)prop.getDisplayName());
        ReportItemExtensionTest.assertEquals((int)0, (int)prop.getTypeCode());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.isList());
        ReportItemExtensionTest.assertEquals(null, (String)prop.getGroupName());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getChoices());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getStructDefn());
        ReportItemExtensionTest.assertEquals((Object)"default test&\"<", (Object)prop.getDefault());
        ReportItemExtensionTest.assertEquals((boolean)true, (boolean)prop.canInherit());
        prop = (ElementPropertyDefn)propList.get(1);
        ReportItemExtensionTest.assertEquals((Object)prop, (Object)extDefn.getProperty("test2"));
        ReportItemExtensionTest.assertEquals((String)"test2", (String)prop.getName());
        ReportItemExtensionTest.assertEquals((String)"Test2", (String)prop.getDisplayName());
        ReportItemExtensionTest.assertEquals((int)2, (int)prop.getTypeCode());
        ReportItemExtensionTest.assertTrue((boolean)extDefn.isPropertyVisible("test2"));
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.isList());
        ReportItemExtensionTest.assertEquals(null, (String)prop.getGroupName());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getChoices());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getStructDefn());
        ReportItemExtensionTest.assertEquals((Object)new Integer("90"), (Object)prop.getDefault());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.canInherit());
        prop = (ElementPropertyDefn)propList.get(2);
        ReportItemExtensionTest.assertEquals((Object)prop, (Object)extDefn.getProperty("test3"));
        ReportItemExtensionTest.assertEquals((String)"test3", (String)prop.getName());
        ReportItemExtensionTest.assertEquals((String)"Test3", (String)prop.getDisplayName());
        ReportItemExtensionTest.assertEquals((int)12, (int)prop.getTypeCode());
        ReportItemExtensionTest.assertFalse((boolean)extDefn.isPropertyVisible(prop.getName()));
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.isList());
        ReportItemExtensionTest.assertEquals(null, (String)prop.getGroupName());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getChoices());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getStructDefn());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getDefault());
        ReportItemExtensionTest.assertEquals((boolean)true, (boolean)prop.canInherit());
        ReportItemExtensionTest.assertNull((Object)prop.validateValue((Module)this.design, (Object)""));
        ReportItemExtensionTest.assertNull((Object)prop.validateValue((Module)this.design, (Object)"  "));
        ReportItemExtensionTest.assertEquals((String)"test", (String)prop.validateValue((Module)this.design, (Object)" test ").toString());
        prop = (ElementPropertyDefn)propList.get(3);
        ReportItemExtensionTest.assertEquals((Object)prop, (Object)extDefn.getProperty("test5"));
        ReportItemExtensionTest.assertEquals((String)"test5", (String)prop.getName());
        ReportItemExtensionTest.assertEquals((String)"Test5", (String)prop.getDisplayName());
        ReportItemExtensionTest.assertEquals((int)5, (int)prop.getTypeCode());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.isList());
        ReportItemExtensionTest.assertEquals(null, (String)prop.getGroupName());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getStructDefn());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getDefault());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.canInherit());
        IChoiceSet choiceSet = prop.getChoices();
        ReportItemExtensionTest.assertEquals((int)3, (int)choiceSet.getChoices().length);
        IChoice[] choices = choiceSet.getChoices();
        ReportItemExtensionTest.assertEquals((String)"choice1", (String)choices[0].getName());
        ReportItemExtensionTest.assertEquals((Object)"one", (Object)choices[0].getValue());
        ReportItemExtensionTest.assertEquals((String)"Choices.test5.choice1", (String)choices[0].getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"Choice One", (String)choices[0].getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"choice2", (String)choices[1].getName());
        ReportItemExtensionTest.assertEquals((Object)"two", (Object)choices[1].getValue());
        ReportItemExtensionTest.assertEquals((String)"Choices.test5.choice2", (String)choices[1].getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"Choice Two", (String)choices[1].getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"choice3", (String)choices[2].getName());
        ReportItemExtensionTest.assertEquals((Object)"three", (Object)choices[2].getValue());
        ReportItemExtensionTest.assertEquals((String)"Choices.test5.choice3", (String)choices[2].getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"choice3", (String)choices[2].getDisplayName());
        prop = (ElementPropertyDefn)extDefn.getProperty("test6");
        ReportItemExtensionTest.assertEquals((String)"Group 1", (String)prop.getGroupName());
        prop = (ElementPropertyDefn)extDefn.getProperty("test7");
        ReportItemExtensionTest.assertEquals((String)"Group 1", (String)prop.getGroupName());
        List methods = extDefn.getMethods();
        ElementPropertyDefn methodProp = (ElementPropertyDefn)methods.get(0);
        IMethodInfo method = methodProp.getMethodInfo();
        ReportItemExtensionTest.assertNotNull((Object)method);
        ReportItemExtensionTest.assertEquals((String)"afterCloseDoc", (String)method.getName());
        ReportItemExtensionTest.assertEquals((String)"Element.TestingMatrix.afterCloseDoc", (String)method.getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"Element.TestingMatrix.afterCloseDoc.toolTip", (String)method.getToolTipKey());
        ReportItemExtensionTest.assertEquals((String)"string", (String)method.getReturnType());
        Iterator iter = method.argumentListIterator();
        ArgumentInfoList argumentList = (ArgumentInfoList)iter.next();
        IArgumentInfo arg = argumentList.getArgument("reportContext");
        ReportItemExtensionTest.assertNotNull((Object)arg);
        ReportItemExtensionTest.assertEquals((String)"Element.TestingMatrix.afterCloseDoc.reportContext", (String)arg.getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"IReportContext", (String)arg.getType());
        arg = argumentList.getArgument("object");
        ReportItemExtensionTest.assertNotNull((Object)arg);
        ReportItemExtensionTest.assertEquals((String)"Element.TestingMatrix.afterCloseDoc.object", (String)arg.getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"Object", (String)arg.getType());
    }

    public void testExtension() throws Exception {
        this.openDesign(this.fileName);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        try {
            extendedHandle.setProperty("extensionName", (Object)TESTING_MATRIX_NAME);
            ReportItemExtensionTest.fail();
        }
        catch (PropertyValueException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.PropertyValueException.EXTENSION_SETTING_FORBIDDEN", (String)e.getErrorCode());
        }
        ReportItemExtensionTest.assertNotNull((Object)((ExtendedItem)extendedHandle.getElement()).getExtendedElement());
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)extendedHandle.getExtensionName());
        ReportItemExtensionTest.assertEquals((double)1.2, (double)extendedHandle.getX().getMeasure(), (double)0.0);
        ReportItemExtensionTest.assertEquals((Object)"2in", (Object)extendedHandle.getProperty("test1"));
        ReportItemExtensionTest.assertEquals((int)22, (int)extendedHandle.getIntProperty("test2"));
        ReportItemExtensionTest.assertEquals((Object)"type=bar,xScale=2,yScale=3,lineStyle=normal,script=internalScript", (Object)extendedHandle.getProperty("test3"));
        ReportItemExtensionTest.assertNull((Object)extendedHandle.getProperty("test4"));
        ReportItemExtensionTest.assertEquals((Object)"choice1", (Object)extendedHandle.getProperty("test5"));
        ReportItemExtensionTest.assertEquals((Object)"script of afterCloseDoc", (Object)extendedHandle.getProperty("afterCloseDoc"));
        Iterator iter1 = extendedHandle.filtersIterator();
        FilterConditionHandle filter = (FilterConditionHandle)iter1.next();
        ReportItemExtensionTest.assertEquals((String)"lt", (String)filter.getOperator());
        ReportItemExtensionTest.assertEquals((String)"filter expression", (String)filter.getExpr());
        ReportItemExtensionTest.assertEquals((String)"value1 expression", (String)filter.getValue1());
        filter = (FilterConditionHandle)iter1.next();
        ReportItemExtensionTest.assertEquals((String)"ge", (String)filter.getOperator());
        ReportItemExtensionTest.assertEquals((String)"expr", (String)filter.getExpr());
        ReportItemExtensionTest.assertEquals((String)"value1 expr", (String)filter.getValue1());
        ReportItemExtensionTest.assertNull(iter1.next());
        extendedHandle.setProperty("y", (Object)"11.2in");
        extendedHandle.setProperty("test5", (Object)"choice2");
        try {
            extendedHandle.setProperty("test5", (Object)"wrong choice");
            ReportItemExtensionTest.fail();
        }
        catch (SemanticException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
        }
        filter.setExpr("new expr");
        filter.setValue2("new value 2");
        extendedHandle.loadExtendedElement();
        ReportItemExtensionTest.assertNotNull((Object)((ExtendedItem)extendedHandle.getElement()).getExtendedElement());
        ReportItemExtensionTest.assertEquals((Object)"type=bar,xScale=2,yScale=3,lineStyle=normal,script=internalScript", (Object)extendedHandle.getProperty("test3"));
        ReportItemExtensionTest.assertEquals((Object)"type=bar,xScale=2,yScale=3,lineStyle=normal,script=internalScript", (Object)((ExtendedItem)extendedHandle.getElement()).getProperty((Module)this.design, "test3"));
        extendedHandle.setProperty("afterCloseDoc", (Object)"new script of afterCloseDoc");
        this.save();
        ReportItemExtensionTest.assertTrue((boolean)this.compareFile(this.goldenFileName_1));
        this.openDesign(this.checkFileName);
        extendedHandle = null;
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((double)1.2, (double)extendedHandle.getX().getMeasure(), (double)0.0);
        ReportItemExtensionTest.assertEquals((Object)"2in", (Object)extendedHandle.getProperty("test1"));
        ReportItemExtensionTest.assertEquals((int)22, (int)extendedHandle.getIntProperty("test2"));
        ReportItemExtensionTest.assertEquals((Object)"type=bar,xScale=2,yScale=3,lineStyle=normal", (Object)extendedHandle.getProperty("test3"));
        extendedHandle.loadExtendedElement();
        extendedHandle.setProperty("test1", null);
        this.save();
        ReportItemExtensionTest.assertTrue((boolean)this.compareFile(this.goldenFileName_2));
    }

    public void testExtends() throws Exception {
        this.openDesign(this.fileName);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ExtendedItem parent = (ExtendedItem)extendedHandle.getElementFactory().newExtendedItem("parent", TESTING_BOX_NAME).getElement();
        try {
            this.designHandle.addElement((DesignElementHandle)parent.handle((Module)this.design), 6);
            extendedHandle.setExtends((DesignElementHandle)parent.handle((Module)this.design));
            ReportItemExtensionTest.fail();
        }
        catch (ExtendsException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.WrongTypeException.WRONG_TYPE", (String)e.getErrorCode());
        }
        ExtendedItemHandle child = this.designHandle.getElementFactory().newExtendedItem("child", TESTING_MATRIX_NAME);
        ReportItemExtensionTest.assertNotNull((Object)child);
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)child.getExtensionName());
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)extendedHandle.getExtensionName());
        parent = (ExtendedItem)extendedHandle.getElementFactory().newExtendedItem("new parent", TESTING_MATRIX_NAME).getElement();
        this.designHandle.addElement((DesignElementHandle)parent.handle((Module)this.design), 5);
        child.setExtends((DesignElementHandle)parent.handle((Module)this.design));
        try {
            this.openDesign(this.fileName_2);
            ReportItemExtensionTest.fail();
        }
        catch (DesignFileException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.DesignFileException.SYNTAX_ERROR", (String)e.getErrorCode());
            List errors = e.getErrorList();
            ReportItemExtensionTest.assertEquals((int)2, (int)errors.size());
            ReportItemExtensionTest.assertEquals((String)"Error.WrongTypeException.WRONG_TYPE", (String)((ErrorDetail)errors.get(0)).getErrorCode());
            ReportItemExtensionTest.assertEquals((String)"Error.SemanticError.MISSING_EXTENSION", (String)((ErrorDetail)errors.get(1)).getErrorCode());
        }
    }

    public void testGetProperty() throws Exception {
        this.openDesign(this.fileName_3);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((double)1.2, (double)extendedHandle.getX().getMeasure(), (double)0.0);
        ReportItemExtensionTest.assertEquals((double)2.4, (double)extendedHandle.getY().getMeasure(), (double)0.0);
        ReportItemExtensionTest.assertEquals((Object)"parent value", (Object)extendedHandle.getProperty("test1"));
        ReportItemExtensionTest.assertEquals(null, (Object)extendedHandle.getElement().getLocalProperty((Module)this.design, "test1"));
        ExtendedItemHandle parent = (ExtendedItemHandle)this.designHandle.findElement("parent");
        ReportItemExtensionTest.assertEquals((Object)parent, (Object)extendedHandle.getExtends());
        ReportItemExtensionTest.assertEquals((Object)"choice2", (Object)parent.getProperty("test5"));
        ReportItemExtensionTest.assertEquals((Object)"choice1", (Object)extendedHandle.getProperty("test5"));
    }

    public void testStyleProperty() throws Exception {
        this.openDesign(this.fileName_3);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((String)"white", (String)extendedHandle.getStringProperty("backgroundColor"));
        ReportItemExtensionTest.assertEquals((String)"blue", (String)extendedHandle.getStringProperty("color"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)extendedHandle.getStringProperty("fontVariant"));
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("style extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle.getDefn().getProperty("fontFamily"));
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle.getElement().getProperty((Module)this.design, "fontFamily"));
        ReportItemExtensionTest.assertEquals((String)"fantasy", (String)extendedHandle.getStringProperty("fontFamily"));
        ReportItemExtensionTest.assertEquals((String)"red", (String)extendedHandle.getStringProperty("color"));
        ReportItemExtensionTest.assertEquals((String)"larger", (String)extendedHandle.getStringProperty("fontSize"));
        ReportItemExtensionTest.assertEquals((String)"italic", (String)extendedHandle.getStringProperty("fontStyle"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)extendedHandle.getStringProperty("fontVariant"));
        ReportItemExtensionTest.assertEquals((String)"bold", (String)extendedHandle.getStringProperty("fontWeight"));
        ReportItemExtensionTest.assertEquals((String)"line-through", (String)extendedHandle.getStringProperty("textLineThrough"));
        ReportItemExtensionTest.assertEquals((String)"overline", (String)extendedHandle.getStringProperty("textOverline"));
        ReportItemExtensionTest.assertEquals((String)"underline", (String)extendedHandle.getStringProperty("textUnderline"));
        ReportItemExtensionTest.assertEquals((String)"dotted", (String)extendedHandle.getStringProperty("borderTopStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)extendedHandle.getStringProperty("borderTopWidth"));
        ReportItemExtensionTest.assertEquals((String)"blue", (String)extendedHandle.getStringProperty("borderTopColor"));
        ReportItemExtensionTest.assertEquals((String)"dashed", (String)extendedHandle.getStringProperty("borderLeftStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)extendedHandle.getStringProperty("borderLeftWidth"));
        ReportItemExtensionTest.assertEquals((String)"green", (String)extendedHandle.getStringProperty("borderLeftColor"));
        ReportItemExtensionTest.assertEquals((String)"solid", (String)extendedHandle.getStringProperty("borderBottomStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)extendedHandle.getStringProperty("borderBottomWidth"));
        ReportItemExtensionTest.assertEquals((String)"red", (String)extendedHandle.getStringProperty("borderBottomColor"));
        ReportItemExtensionTest.assertEquals((String)"double", (String)extendedHandle.getStringProperty("borderRightStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)extendedHandle.getStringProperty("borderRightWidth"));
        ReportItemExtensionTest.assertEquals((String)"maroon", (String)extendedHandle.getStringProperty("borderRightColor"));
        ReportItemExtensionTest.assertEquals((String)"1mm", (String)extendedHandle.getStringProperty("paddingTop"));
        ReportItemExtensionTest.assertEquals((String)"2mm", (String)extendedHandle.getStringProperty("paddingLeft"));
        ReportItemExtensionTest.assertEquals((String)"3mm", (String)extendedHandle.getStringProperty("paddingRight"));
        ReportItemExtensionTest.assertEquals((String)"4mm", (String)extendedHandle.getStringProperty("paddingBottom"));
        ReportItemExtensionTest.assertEquals((String)"scroll", (String)extendedHandle.getStringProperty("backgroundAttachment"));
        ReportItemExtensionTest.assertEquals((String)"red", (String)extendedHandle.getStringProperty("backgroundColor"));
        ReportItemExtensionTest.assertEquals((String)"file", (String)extendedHandle.getStringProperty("backgroundImage"));
        ReportItemExtensionTest.assertEquals((String)"center", (String)extendedHandle.getStringProperty("backgroundPositionX"));
        ReportItemExtensionTest.assertEquals((String)"top", (String)extendedHandle.getStringProperty("backgroundPositionY"));
        ReportItemExtensionTest.assertEquals((String)"repeat", (String)extendedHandle.getStringProperty("backgroundRepeat"));
        ReportItemExtensionTest.assertEquals((String)"right", (String)extendedHandle.getStringProperty("textAlign"));
        ReportItemExtensionTest.assertEquals((String)"5mm", (String)extendedHandle.getStringProperty("textIndent"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)extendedHandle.getStringProperty("letterSpacing"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)extendedHandle.getStringProperty("lineHeight"));
        ReportItemExtensionTest.assertEquals((String)"19", (String)extendedHandle.getStringProperty("orphans"));
        ReportItemExtensionTest.assertEquals((String)"uppercase", (String)extendedHandle.getStringProperty("textTransform"));
        ReportItemExtensionTest.assertEquals((String)"middle", (String)extendedHandle.getStringProperty("verticalAlign"));
        ReportItemExtensionTest.assertEquals((String)"nowrap", (String)extendedHandle.getStringProperty("whiteSpace"));
        ReportItemExtensionTest.assertEquals((String)"12", (String)extendedHandle.getStringProperty("widows"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)extendedHandle.getStringProperty("wordSpacing"));
        ReportItemExtensionTest.assertEquals((String)"inline", (String)extendedHandle.getStringProperty("display"));
        ReportItemExtensionTest.assertEquals((String)"My Page", (String)extendedHandle.getStringProperty("masterPage"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("pageBreakAfter"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("pageBreakBefore"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("pageBreakInside"));
        ReportItemExtensionTest.assertEquals((String)"true", (String)extendedHandle.getStringProperty("showIfBlank"));
        ReportItemExtensionTest.assertEquals((String)"true", (String)extendedHandle.getStringProperty("canShrink"));
        ReportItemExtensionTest.assertEquals((String)"right", (String)extendedHandle.getStringProperty("numberAlign"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("marginTop"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("marginLeft"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("marginRight"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)extendedHandle.getStringProperty("marginBottom"));
        List mapRules = (List)extendedHandle.getProperty("mapRules");
        ReportItemExtensionTest.assertEquals((int)5, (int)mapRules.size());
        ReportItemExtensionTest.assertEquals((String)"eq", (String)((MapRule)mapRules.get(0)).getOperator());
        ReportItemExtensionTest.assertEquals((String)"Closed", (String)((MapRule)mapRules.get(0)).getDisplay());
        ReportItemExtensionTest.assertEquals((String)"\"X\"", (String)((MapRule)mapRules.get(0)).getValue1());
        ReportItemExtensionTest.assertEquals((String)"is-true", (String)((MapRule)mapRules.get(1)).getOperator());
        ReportItemExtensionTest.assertEquals((String)"Open", (String)((MapRule)mapRules.get(1)).getDisplay());
        ReportItemExtensionTest.assertEquals((String)"like", (String)((MapRule)mapRules.get(2)).getOperator());
        ReportItemExtensionTest.assertEquals((String)"Unknown", (String)((MapRule)mapRules.get(2)).getDisplay());
        NameSpace ns = this.design.getNameHelper().getNameSpace(0);
        ReportItemExtensionTest.assertEquals((int)3, (int)ns.getCount());
        StyleHandle sh = extendedHandle.getPrivateStyle();
        Iterator iter = sh.mapRulesIterator();
        ReportItemExtensionTest.assertNotNull(iter.next());
        ReportItemExtensionTest.assertNotNull(iter.next());
        ReportItemExtensionTest.assertNotNull(iter.next());
        ArrayList<ExtendedItemHandle> list = new ArrayList<ExtendedItemHandle>();
        list.add(extendedHandle);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, list);
        ReportItemExtensionTest.assertEquals((String)"center", (String)groupHandle.getStringProperty("backgroundPositionX"));
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("predefined style item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((Object)"blue", (Object)extendedHandle.getProperty("color"));
        this.designHandle.getStyles().drop(2);
        ReportItemExtensionTest.assertEquals((Object)"black", (Object)extendedHandle.getProperty("color"));
        this.save();
        ReportItemExtensionTest.assertTrue((boolean)this.compareFile(this.goldenFileName_3));
    }

    public void testStylePropertiesFromGroupElementHandle() throws DesignFileException {
        this.openDesign(this.fileName_3);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ArrayList<ExtendedItemHandle> list = new ArrayList<ExtendedItemHandle>();
        list.add(extendedHandle);
        SimpleGroupElementHandle groupHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, list);
        ReportItemExtensionTest.assertEquals((String)"white", (String)groupHandle.getStringProperty("backgroundColor"));
        ReportItemExtensionTest.assertEquals((String)"blue", (String)groupHandle.getStringProperty("color"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)groupHandle.getStringProperty("fontVariant"));
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("style extended item");
        list.clear();
        list.add(extendedHandle);
        groupHandle = new SimpleGroupElementHandle((ModuleHandle)this.designHandle, list);
        ReportItemExtensionTest.assertEquals((String)"fantasy", (String)groupHandle.getStringProperty("fontFamily"));
        ReportItemExtensionTest.assertEquals((String)"red", (String)groupHandle.getStringProperty("color"));
        ReportItemExtensionTest.assertEquals((String)"larger", (String)groupHandle.getStringProperty("fontSize"));
        ReportItemExtensionTest.assertEquals((String)"italic", (String)groupHandle.getStringProperty("fontStyle"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)groupHandle.getStringProperty("fontVariant"));
        ReportItemExtensionTest.assertEquals((String)"bold", (String)groupHandle.getStringProperty("fontWeight"));
        ReportItemExtensionTest.assertEquals((String)"line-through", (String)groupHandle.getStringProperty("textLineThrough"));
        ReportItemExtensionTest.assertEquals((String)"overline", (String)groupHandle.getStringProperty("textOverline"));
        ReportItemExtensionTest.assertEquals((String)"underline", (String)groupHandle.getStringProperty("textUnderline"));
        ReportItemExtensionTest.assertEquals((String)"dotted", (String)groupHandle.getStringProperty("borderTopStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)groupHandle.getStringProperty("borderTopWidth"));
        ReportItemExtensionTest.assertEquals((String)"blue", (String)groupHandle.getStringProperty("borderTopColor"));
        ReportItemExtensionTest.assertEquals((String)"dashed", (String)groupHandle.getStringProperty("borderLeftStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)groupHandle.getStringProperty("borderLeftWidth"));
        ReportItemExtensionTest.assertEquals((String)"green", (String)groupHandle.getStringProperty("borderLeftColor"));
        ReportItemExtensionTest.assertEquals((String)"solid", (String)groupHandle.getStringProperty("borderBottomStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)groupHandle.getStringProperty("borderBottomWidth"));
        ReportItemExtensionTest.assertEquals((String)"red", (String)groupHandle.getStringProperty("borderBottomColor"));
        ReportItemExtensionTest.assertEquals((String)"double", (String)groupHandle.getStringProperty("borderRightStyle"));
        ReportItemExtensionTest.assertEquals((String)"thin", (String)groupHandle.getStringProperty("borderRightWidth"));
        ReportItemExtensionTest.assertEquals((String)"maroon", (String)groupHandle.getStringProperty("borderRightColor"));
        ReportItemExtensionTest.assertEquals((String)"1mm", (String)groupHandle.getStringProperty("paddingTop"));
        ReportItemExtensionTest.assertEquals((String)"2mm", (String)groupHandle.getStringProperty("paddingLeft"));
        ReportItemExtensionTest.assertEquals((String)"3mm", (String)groupHandle.getStringProperty("paddingRight"));
        ReportItemExtensionTest.assertEquals((String)"4mm", (String)groupHandle.getStringProperty("paddingBottom"));
        ReportItemExtensionTest.assertEquals((String)"scroll", (String)groupHandle.getStringProperty("backgroundAttachment"));
        ReportItemExtensionTest.assertEquals((String)"red", (String)groupHandle.getStringProperty("backgroundColor"));
        ReportItemExtensionTest.assertEquals((String)"file", (String)groupHandle.getStringProperty("backgroundImage"));
        ReportItemExtensionTest.assertEquals((String)"center", (String)groupHandle.getStringProperty("backgroundPositionX"));
        ReportItemExtensionTest.assertEquals((String)"top", (String)groupHandle.getStringProperty("backgroundPositionY"));
        ReportItemExtensionTest.assertEquals((String)"repeat", (String)groupHandle.getStringProperty("backgroundRepeat"));
        ReportItemExtensionTest.assertEquals((String)"right", (String)groupHandle.getStringProperty("textAlign"));
        ReportItemExtensionTest.assertEquals((String)"5mm", (String)groupHandle.getStringProperty("textIndent"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)groupHandle.getStringProperty("letterSpacing"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)groupHandle.getStringProperty("lineHeight"));
        ReportItemExtensionTest.assertEquals((String)"19", (String)groupHandle.getStringProperty("orphans"));
        ReportItemExtensionTest.assertEquals((String)"uppercase", (String)groupHandle.getStringProperty("textTransform"));
        ReportItemExtensionTest.assertEquals((String)"middle", (String)groupHandle.getStringProperty("verticalAlign"));
        ReportItemExtensionTest.assertEquals((String)"nowrap", (String)groupHandle.getStringProperty("whiteSpace"));
        ReportItemExtensionTest.assertEquals((String)"12", (String)groupHandle.getStringProperty("widows"));
        ReportItemExtensionTest.assertEquals((String)"normal", (String)groupHandle.getStringProperty("wordSpacing"));
        ReportItemExtensionTest.assertEquals((String)"inline", (String)groupHandle.getStringProperty("display"));
        ReportItemExtensionTest.assertEquals((String)"My Page", (String)groupHandle.getStringProperty("masterPage"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("pageBreakAfter"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("pageBreakBefore"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("pageBreakInside"));
        ReportItemExtensionTest.assertEquals((String)"true", (String)groupHandle.getStringProperty("showIfBlank"));
        ReportItemExtensionTest.assertEquals((String)"true", (String)groupHandle.getStringProperty("canShrink"));
        ReportItemExtensionTest.assertEquals((String)"right", (String)groupHandle.getStringProperty("numberAlign"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("marginTop"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("marginLeft"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("marginRight"));
        ReportItemExtensionTest.assertEquals((String)"auto", (String)groupHandle.getStringProperty("marginBottom"));
        GroupPropertyHandle groupPropertyHandle = groupHandle.getPropertyHandle("mapRules");
        ReportItemExtensionTest.assertNotNull((Object)groupPropertyHandle);
    }

    public void testExtendedCommand() throws Exception {
        this.openDesign(this.fileName);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        extendedHandle.loadExtendedElement();
        extendedHandle.setProperty("company", (Object)"new value");
        ReportItemExtensionTest.assertTrue((boolean)extendedHandle.getStringProperty("company").endsWith("execute"));
        ActivityStack stack = this.design.getActivityStack();
        stack.undo();
        ReportItemExtensionTest.assertTrue((boolean)extendedHandle.getStringProperty("company").endsWith("undo"));
        stack.redo();
        ReportItemExtensionTest.assertTrue((boolean)extendedHandle.getStringProperty("company").endsWith("redo"));
    }

    public void testDynamicPropertyList() throws DesignFileException, SemanticException {
        this.openDesign(this.fileName, ULocale.ENGLISH);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        HashSet<String> set = new HashSet<String>();
        Iterator iter = extendedHandle.getPropertyIterator();
        while (iter.hasNext()) {
            set.add(((PropertyHandle)iter.next()).getDefn().getName());
        }
        ReportItemExtensionTest.assertTrue((boolean)set.contains("x"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("y"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("test1"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("test2"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("test3"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("test5"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("test6"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("test7"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("type"));
        ReportItemExtensionTest.assertFalse((boolean)set.contains("radius"));
        ReportItemExtensionTest.assertFalse((boolean)set.contains("pieWidth"));
        ReportItemExtensionTest.assertFalse((boolean)set.contains("pieHeight"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("xScale"));
        ReportItemExtensionTest.assertTrue((boolean)set.contains("yScale"));
        extendedHandle.loadExtendedElement();
        ExtendedItem extendedItem = (ExtendedItem)extendedHandle.getElement();
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("type"));
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("xScale"));
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("yScale"));
        ReportItemExtensionTest.assertNull((Object)extendedItem.getPropertyDefn("radius"));
        ReportItemExtensionTest.assertNull((Object)extendedItem.getPropertyDefn("pieWidth"));
        ReportItemExtensionTest.assertNull((Object)extendedItem.getPropertyDefn("pieHeight"));
        ReportItemExtensionTest.assertEquals((String)"Type", (String)extendedItem.getPropertyDefn("type").getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"X Scale", (String)extendedItem.getPropertyDefn("xScale").getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"Y Scale", (String)extendedItem.getPropertyDefn("yScale").getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"Thin", (String)extendedItem.getPropertyDefn("lineStyle").getChoices().getChoices()[0].getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"Normal", (String)extendedItem.getPropertyDefn("lineStyle").getChoices().getChoices()[1].getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"Thick", (String)extendedItem.getPropertyDefn("lineStyle").getChoices().getChoices()[2].getDisplayName());
        extendedHandle.setProperty("type", (Object)"pie");
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("type"));
        ReportItemExtensionTest.assertNull((Object)extendedItem.getPropertyDefn("xScale"));
        ReportItemExtensionTest.assertNull((Object)extendedItem.getPropertyDefn("yScale"));
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("radius"));
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("pieWidth"));
        ReportItemExtensionTest.assertNotNull((Object)extendedItem.getPropertyDefn("pieHeight"));
        ReportItemExtensionTest.assertEquals((int)8, (int)extendedHandle.getMethods().size());
        List methods = extendedHandle.getMethods();
        ReportItemExtensionTest.assertEquals((String)"afterCloseDoc", (String)((ElementPropertyDefn)methods.get(0)).getName());
        ReportItemExtensionTest.assertNotNull((Object)((ElementPropertyDefn)methods.get(0)).getMethodInfo());
        ReportItemExtensionTest.assertEquals((String)"test8", (String)((ElementPropertyDefn)methods.get(1)).getName());
        ReportItemExtensionTest.assertNotNull((Object)((ElementPropertyDefn)methods.get(1)).getMethodInfo());
        ReportItemExtensionTest.assertEquals((String)"onPrepare", (String)((ElementPropertyDefn)methods.get(2)).getName());
        ReportItemExtensionTest.assertEquals((String)"onCreate", (String)((ElementPropertyDefn)methods.get(3)).getName());
        ReportItemExtensionTest.assertEquals((String)"onRender", (String)((ElementPropertyDefn)methods.get(4)).getName());
        ReportItemExtensionTest.assertEquals((String)"onPageBreak", (String)((ElementPropertyDefn)methods.get(5)).getName());
        ReportItemExtensionTest.assertEquals((String)"firstMethod", (String)((ElementPropertyDefn)methods.get(6)).getName());
        ReportItemExtensionTest.assertEquals((String)"sencondMethod", (String)((ElementPropertyDefn)methods.get(7)).getName());
        ReportItemExtensionTest.assertNotNull((Object)((ElementPropertyDefn)methods.get(7)).getMethodInfo());
        try {
            extendedHandle.setProperty("xScale", (Object)"4");
            ReportItemExtensionTest.fail();
        }
        catch (SemanticException e) {
            ReportItemExtensionTest.assertTrue((boolean)(e instanceof PropertyNameException));
        }
    }

    public void testTestingBox() {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(TESTING_BOX_NAME);
        ReportItemExtensionTest.assertNotNull((Object)extDefn);
        ReportItemExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)extDefn.getDisplayName());
        ReportItemExtensionTest.assertEquals(null, (Object)extDefn.getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)extDefn.getName());
        ReportItemExtensionTest.assertEquals((int)2, (int)extDefn.getNameOption());
        ReportItemExtensionTest.assertEquals((boolean)true, (boolean)extDefn.allowsUserProperties());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)extDefn.hasStyle());
        List propList = extDefn.getProperties();
        ElementPropertyDefn prop = (ElementPropertyDefn)extDefn.getProperty("usage");
        ReportItemExtensionTest.assertEquals((Object)prop, (Object)extDefn.getProperty("usage"));
        ReportItemExtensionTest.assertEquals((String)"usage", (String)prop.getName());
        ReportItemExtensionTest.assertEquals((String)"usage", (String)prop.getDisplayName());
        ReportItemExtensionTest.assertEquals((int)0, (int)prop.getTypeCode());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.isList());
        ReportItemExtensionTest.assertEquals(null, (String)prop.getGroupName());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getChoices());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getStructDefn());
        ReportItemExtensionTest.assertEquals((Object)"paper", (Object)prop.getDefault());
        ReportItemExtensionTest.assertEquals((boolean)true, (boolean)prop.canInherit());
        prop = (ElementPropertyDefn)propList.get(1);
        ReportItemExtensionTest.assertEquals((Object)prop, (Object)extDefn.getProperty("shape"));
        ReportItemExtensionTest.assertEquals((String)"shape", (String)prop.getName());
        ReportItemExtensionTest.assertEquals((String)"shape", (String)prop.getDisplayName());
        ReportItemExtensionTest.assertEquals((int)5, (int)prop.getTypeCode());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.isList());
        ReportItemExtensionTest.assertEquals(null, (String)prop.getGroupName());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getStructDefn());
        ReportItemExtensionTest.assertEquals(null, (Object)prop.getDefault());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)prop.canInherit());
        IChoiceSet choiceSet = prop.getChoices();
        ReportItemExtensionTest.assertEquals((int)3, (int)choiceSet.getChoices().length);
        IChoice[] choices = choiceSet.getChoices();
        ReportItemExtensionTest.assertEquals((String)"cube", (String)choices[0].getName());
        ReportItemExtensionTest.assertEquals((Object)"cube", (Object)choices[0].getValue());
        ReportItemExtensionTest.assertEquals((String)"Choices.shape.cube", (String)choices[0].getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"cube", (String)choices[0].getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"sphere", (String)choices[1].getName());
        ReportItemExtensionTest.assertEquals((Object)"sphere", (Object)choices[1].getValue());
        ReportItemExtensionTest.assertEquals((String)"Choices.shape.sphere", (String)choices[1].getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"sphere", (String)choices[1].getDisplayName());
        ReportItemExtensionTest.assertEquals((String)"cubiod", (String)choices[2].getName());
        ReportItemExtensionTest.assertEquals((Object)"cubiod", (Object)choices[2].getValue());
        ReportItemExtensionTest.assertEquals((String)"Choices.shape.cubiod", (String)choices[2].getDisplayNameKey());
        ReportItemExtensionTest.assertEquals((String)"cubiod", (String)choices[2].getDisplayName());
    }

    public void testExtendedItemNotAllowedInMasterpage() throws Exception {
        this.createDesign();
        SimpleMasterPageHandle masterPageHandle = this.designHandle.getElementFactory().newSimpleMasterPage("master page");
        this.designHandle.getMasterPages().add((DesignElementHandle)masterPageHandle);
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.getElementFactory().newElement(TESTING_BOX_NAME, "box1");
        ReportItemExtensionTest.assertFalse((boolean)masterPageHandle.canContain(masterPageHandle.getPageHeader().getSlotID(), (DesignElementHandle)itemHandle));
    }

    public void testAddExtendedItem() throws Exception {
        this.createDesign();
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.getElementFactory().newElement(TESTING_BOX_NAME, "box1");
        this.designHandle.getBody().add((DesignElementHandle)itemHandle);
        ReportItemExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)itemHandle.getDefn().getName());
        ReportItemExtensionTest.assertEquals((String)TESTING_BOX_NAME, (String)((ExtendedItem)itemHandle.getElement()).getExtDefn().getName());
        ReportItemExtensionTest.assertEquals((boolean)false, (boolean)((ExtendedItem)itemHandle.getElement()).getExtDefn().hasStyle());
        itemHandle.setProperty("usage", (Object)"toy");
        this.save();
        ReportItemExtensionTest.assertTrue((boolean)this.compareFile("TestingBox_golden_1.xml"));
    }

    public void testAddExtendedItem2() throws Exception {
        this.openDesign(this.fileName_7);
        DesignElementHandle baseMatrixHandle = this.designHandle.getComponents().get(0);
        ReportItemExtensionTest.assertNotNull((Object)baseMatrixHandle);
        ReportItemExtensionTest.assertEquals((String)"baseMatrix", (String)baseMatrixHandle.getName());
        DesignElementHandle newMatrixHandle = this.designHandle.getElementFactory().newElementFrom(baseMatrixHandle, "myMatrix");
        this.designHandle.getBody().add(newMatrixHandle);
        this.save();
        ReportItemExtensionTest.assertTrue((boolean)this.compareFile("TestAddExtendedItem_golden_2.xml"));
    }

    public void testClone() throws Exception {
        this.openDesign(this.fileName);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        extendedHandle.loadExtendedElement();
        ExtendedItemHandle clonedHandle = (ExtendedItemHandle)extendedHandle.copy().getHandle((Module)this.design);
        ReportItemExtensionTest.assertNotNull((Object)clonedHandle);
        ReportItemExtensionTest.assertNotNull((Object)((ExtendedItem)clonedHandle.getElement()).getExtendedElement());
        clonedHandle.loadExtendedElement();
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)clonedHandle.getExtensionName());
        ReportItemExtensionTest.assertEquals((double)1.2, (double)clonedHandle.getX().getMeasure(), (double)0.0);
        ReportItemExtensionTest.assertEquals((Object)"2in", (Object)clonedHandle.getProperty("test1"));
        ReportItemExtensionTest.assertEquals((int)22, (int)clonedHandle.getIntProperty("test2"));
        ReportItemExtensionTest.assertEquals((Object)"type=bar,xScale=2,yScale=3,lineStyle=normal,script=internalScript", (Object)clonedHandle.getProperty("test3"));
        ReportItemExtensionTest.assertNull((Object)clonedHandle.getProperty("test4"));
        ReportItemExtensionTest.assertEquals((Object)"choice1", (Object)clonedHandle.getProperty("test5"));
        ReportItemExtensionTest.assertEquals((Object)"bar", (Object)clonedHandle.getProperty("type"));
        ReportItemExtensionTest.assertEquals(null, (Object)clonedHandle.getProperty("radius"));
        ReportItemExtensionTest.assertEquals(null, (Object)clonedHandle.getProperty("pieWidth"));
        ReportItemExtensionTest.assertEquals(null, (Object)clonedHandle.getProperty("pieHeight"));
        ReportItemExtensionTest.assertEquals((int)2, (int)clonedHandle.getIntProperty("xScale"));
        ReportItemExtensionTest.assertEquals((int)3, (int)clonedHandle.getIntProperty("yScale"));
        ReportItemExtensionTest.assertEquals(null, (Object)clonedHandle.getProperty("company"));
        ReportItemExtensionTest.assertEquals((Object)"normal", (Object)clonedHandle.getProperty("lineStyle"));
    }

    public void testNotification() throws Exception {
        this.openDesign(this.fileName_3);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        MyListener containerListener = new MyListener();
        extendedHandle.addListener((Listener)containerListener);
        extendedHandle.loadExtendedElement();
        extendedHandle.setProperty("type", (Object)"pie");
        ReportItemExtensionTest.assertEquals((int)2, (int)containerListener.action);
        extendedHandle.setProperty("test1", (Object)"new");
        ReportItemExtensionTest.assertEquals((int)1, (int)containerListener.action);
        extendedHandle.setProperty("test3", null);
        extendedHandle.getElement().validateWithContents((Module)this.design);
        ReportItemExtensionTest.assertEquals((Object)"blue", (Object)extendedHandle.getProperty("color"));
        String selectorName = ((ExtendedItem)extendedHandle.getElement()).getExtDefn().getSelector();
        SharedStyleHandle selector = this.designHandle.findNativeStyle(selectorName);
        selector.getColor().setStringValue("teal");
        ReportItemExtensionTest.assertEquals((int)3, (int)containerListener.action);
    }

    public void testChoiceProperty() throws Exception {
        ExtendedItemHandle itemHandle = this.insertExtendedItem("matrix1", TESTING_MATRIX_NAME);
        itemHandle.setProperty("test5", (Object)"choice2");
        ReportItemExtensionTest.assertEquals((Object)"choice2", (Object)itemHandle.getProperty("test5"));
        try {
            itemHandle.setProperty("test5", (Object)"wrongChoice");
            ReportItemExtensionTest.fail();
        }
        catch (SemanticException e) {
            ReportItemExtensionTest.assertTrue((boolean)(e instanceof PropertyValueException));
            ReportItemExtensionTest.assertEquals((Object)"choice2", (Object)itemHandle.getProperty("test5"));
        }
    }

    public void testChoiceDynamicProperty() throws Exception {
        ExtendedItemHandle itemHandle = this.insertExtendedItem("matrix1", TESTING_MATRIX_NAME);
        itemHandle.setProperty("lineStyle", (Object)"thin");
        ReportItemExtensionTest.assertEquals((Object)"thin", (Object)itemHandle.getProperty("lineStyle"));
        try {
            itemHandle.setProperty("lineStyle", (Object)"wrongChoice");
            ReportItemExtensionTest.fail();
        }
        catch (SemanticException e) {
            ReportItemExtensionTest.assertTrue((boolean)(e instanceof PropertyValueException));
            ReportItemExtensionTest.assertEquals((Object)"thin", (Object)itemHandle.getProperty("lineStyle"));
        }
    }

    public void testExtensionPropertyInvisible() throws Exception {
        ExtendedItemHandle itemHandle = this.insertExtendedItem("matrix1", TESTING_MATRIX_NAME);
        PropertyHandle prop = itemHandle.getPropertyHandle("bookmark");
        ReportItemExtensionTest.assertFalse((boolean)prop.isVisible());
        prop = itemHandle.getPropertyHandle("test3");
        ReportItemExtensionTest.assertFalse((boolean)prop.isVisible());
        prop = itemHandle.getPropertyHandle("dataSet");
        ReportItemExtensionTest.assertTrue((boolean)prop.isVisible());
        itemHandle = this.insertExtendedItem("testTable1", TESTING_TABLE_NAME);
        ReportItemExtensionTest.assertNotNull((Object)itemHandle.getPropertyDefn("extensionName"));
        prop = itemHandle.getPropertyHandle("extensionName");
        ReportItemExtensionTest.assertFalse((boolean)prop.isVisible());
        prop = itemHandle.getPropertyHandle("cube");
        ReportItemExtensionTest.assertTrue((boolean)prop.isVisible());
    }

    public void testOpenDesignFileWithWrongExtension() throws DesignFileException, SemanticException {
        this.openDesign(this.fileName_4);
        List list = this.designHandle.getErrorList();
        ReportItemExtensionTest.assertEquals((int)1, (int)list.size());
        int i = 0;
        ReportItemExtensionTest.assertEquals((String)"Error.SemanticError.EXTENSION_NOT_FOUND", (String)((ErrorDetail)list.get(i++)).getErrorCode());
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        try {
            itemHandle.getReportItem();
            ReportItemExtensionTest.fail();
        }
        catch (ExtendedElementException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.SemanticError.EXTENSION_NOT_FOUND", (String)e.getErrorCode());
        }
        this.testExtendedItemWithoutExtension(itemHandle);
    }

    private void testExtendedItemWithoutExtension(ExtendedItemHandle itemHandle) throws SemanticException {
        itemHandle.setStringProperty("y", "12.5cm");
        try {
            itemHandle.setStringProperty("test2", "the value of undefined property");
            ReportItemExtensionTest.fail();
        }
        catch (PropertyNameException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.PropertyNameException.PROPERTY_NOT_VALID", (String)e.getErrorCode());
        }
        ReportItemExtensionTest.assertEquals((String)"12.5cm", (String)itemHandle.getStringProperty("y"));
        ReportItemExtensionTest.assertNull((Object)itemHandle.getStringProperty("test2"));
        IElementDefn elementDefn = itemHandle.getDefn();
        ReportItemExtensionTest.assertEquals((Object)elementDefn, (Object)MetaDataDictionary.getInstance().getElement("ExtendedItem"));
        ExtendedItem element = (ExtendedItem)itemHandle.getElement();
        ReportItemExtensionTest.assertNull((Object)element.getExtDefn());
        ReportItemExtensionTest.assertFalse((boolean)element.isExtensionXMLProperty("y"));
        ReportItemExtensionTest.assertFalse((boolean)element.isExtensionXMLProperty("test3"));
    }

    public void testOpenDesignFileWithoutExtension() throws DesignFileException, SemanticException {
        this.openDesign(this.fileName_5);
        List list = this.designHandle.getErrorList();
        ReportItemExtensionTest.assertEquals((int)1, (int)list.size());
        int i = 0;
        ReportItemExtensionTest.assertEquals((String)"Error.SemanticError.MISSING_EXTENSION", (String)((ErrorDetail)list.get(i++)).getErrorCode());
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        try {
            itemHandle.getReportItem();
            ReportItemExtensionTest.fail();
        }
        catch (ExtendedElementException e) {
            ReportItemExtensionTest.assertEquals((String)"Error.SemanticError.MISSING_EXTENSION", (String)e.getErrorCode());
        }
        this.testExtendedItemWithoutExtension(itemHandle);
    }

    private ExtendedItemHandle insertExtendedItem(String name, String extensionName) throws Exception {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.designHandle = this.sessionHandle.createDesign();
        ExtendedItemHandle itemHandle = this.designHandle.getElementFactory().newExtendedItem(name, extensionName);
        this.designHandle.getBody().add((DesignElementHandle)itemHandle);
        return itemHandle;
    }

    public void testLoadExtendedElement() throws Exception {
        this.openDesign(this.fileName);
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((Object)"bar", (Object)extendedHandle.getProperty("type"));
        this.designHandle.close();
        this.openDesign(this.fileName);
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((String)"bar", (String)extendedHandle.getStringProperty("type"));
        this.designHandle.close();
        this.openDesign(this.fileName);
        extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("right extended item");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        extendedHandle.setProperty("type", (Object)"pie");
        ReportItemExtensionTest.assertEquals((Object)"pie", (Object)extendedHandle.getProperty("type"));
        extendedHandle.loadExtendedElement();
        ReportItemExtensionTest.assertEquals((Object)"pie", (Object)extendedHandle.getProperty("type"));
        extendedHandle.setProperty("type", (Object)"bar");
        ReportItemExtensionTest.assertEquals((Object)"bar", (Object)extendedHandle.getProperty("type"));
    }

    public void testTheSlotDefn() throws DesignFileException {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        IElementDefn elementDefn = dd.getElement("FreeForm");
        ReportItemExtensionTest.assertNotNull((Object)elementDefn);
        SlotDefn slotDefn = (SlotDefn)elementDefn.getSlot(0);
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(TESTING_MATRIX_NAME);
        ReportItemExtensionTest.assertTrue((boolean)slotDefn.getContentExtendedElements().contains(extDefn));
        ReportItemExtensionTest.assertFalse((boolean)slotDefn.getContentElements().contains(extDefn));
        extDefn = (ExtensionElementDefn)dd.getExtension(TESTING_BOX_NAME);
        ReportItemExtensionTest.assertTrue((boolean)slotDefn.getContentExtendedElements().contains(extDefn));
        ReportItemExtensionTest.assertFalse((boolean)slotDefn.getContentElements().contains(extDefn));
        ElementDefn extendedItemDefn = (ElementDefn)dd.getElement("ExtendedItem");
        ReportItemExtensionTest.assertFalse((boolean)slotDefn.getContentExtendedElements().contains(extendedItemDefn));
        ReportItemExtensionTest.assertTrue((boolean)slotDefn.getContentElements().contains(extendedItemDefn));
        this.openDesign("ExtensionTest_5.xml");
        FreeFormHandle freeForm = this.designHandle.getElementFactory().newFreeForm("MyForm");
        ReportItemExtensionTest.assertTrue((boolean)freeForm.canContain(0, TESTING_MATRIX_NAME));
        ReportItemExtensionTest.assertTrue((boolean)freeForm.canContain(0, TESTING_BOX_NAME));
        ReportItemExtensionTest.assertFalse((boolean)freeForm.canContain(0, "wrongExtension"));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.fileName_6);
        ReportItemExtensionTest.assertEquals((int)2, (int)this.design.getErrorList().size());
        ReportItemExtensionTest.assertEquals((String)"org.eclipse.birt.report.model.api.extension.ExtendedElementException", (String)((ErrorDetail)this.design.getErrorList().get(0)).getExceptionName());
        ReportItemExtensionTest.assertEquals((String)"org.eclipse.birt.report.model.api.extension.ExtendedElementException", (String)((ErrorDetail)this.design.getErrorList().get(1)).getExceptionName());
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.findElement("parent");
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        extendedHandle.moveTo((DesignElementHandle)this.designHandle, 6);
        this.designHandle.checkReport();
        ReportItemExtensionTest.assertEquals((int)2, (int)this.design.getErrorList().size());
        ReportItemExtensionTest.assertEquals((String)"org.eclipse.birt.report.model.api.extension.ExtendedElementException", (String)((ErrorDetail)this.design.getErrorList().get(0)).getExceptionName());
        ReportItemExtensionTest.assertEquals((String)"org.eclipse.birt.report.model.api.extension.ExtendedElementException", (String)((ErrorDetail)this.design.getErrorList().get(1)).getExceptionName());
    }

    public void testCreateExtension() throws Exception {
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        ExtendedItemHandle elementHandle = this.designHandle.getElementFactory().newExtendedItem(null, TESTING_MATRIX_NAME);
        ReportItemExtensionTest.assertNotNull((Object)elementHandle.getName());
        this.libraryHandle = session.createLibrary();
        elementHandle = this.libraryHandle.getElementFactory().newExtendedItem(null, TESTING_MATRIX_NAME);
        ReportItemExtensionTest.assertEquals((String)"NewTestingMatrix", (String)elementHandle.getName());
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)MetaDataDictionary.getInstance().getExtension(TESTING_MATRIX_NAME);
        IMessages msgs = extDefn.getReportItemFactory().getMessages();
        ReportItemExtensionTest.assertEquals((String)TESTING_MATRIX_NAME, (String)msgs.getMessage((String)extDefn.getDisplayNameKey(), ULocale.ENGLISH));
        elementHandle = this.libraryHandle.getElementFactory().newExtendedItem(null, TESTING_BOX_NAME);
        ReportItemExtensionTest.assertEquals((String)"NewTestingBox", (String)elementHandle.getName());
        extDefn = (PeerExtensionElementDefn)MetaDataDictionary.getInstance().getExtension(TESTING_BOX_NAME);
        ReportItemExtensionTest.assertNull((Object)extDefn.getReportItemFactory().getMessages());
    }

    public void testLocalizedMessage() throws Exception {
        this.openDesign(this.fileName_8, ULocale.ENGLISH);
        ReportItemExtensionTest.assertEquals((int)2, (int)this.design.getErrorList().size());
        ErrorDetail eDetail = (ErrorDetail)this.design.getErrorList().get(0);
        String localizedMessage = eDetail.getMessage();
        String expect = "Extended exception in TestingMatrix";
        ReportItemExtensionTest.assertEquals((String)expect, (String)localizedMessage);
        eDetail = (ErrorDetail)this.design.getErrorList().get(1);
        localizedMessage = eDetail.getMessage();
        expect = "local actuate";
        ReportItemExtensionTest.assertEquals((String)expect, (String)localizedMessage);
    }

    public void testChartValidation() throws DesignFileException {
        this.openDesign(this.fileName_9, ULocale.ENGLISH);
        ReportItemExtensionTest.assertEquals((int)2, (int)this.design.getErrorList().size());
        ErrorDetail eDetail = (ErrorDetail)this.design.getErrorList().get(0);
        String localizedMessage = eDetail.getMessage();
        String expect = "Extended exception in TestingMatrix";
        ReportItemExtensionTest.assertEquals((String)expect, (String)localizedMessage);
        eDetail = (ErrorDetail)this.design.getErrorList().get(1);
        localizedMessage = eDetail.getMessage();
        expect = "local actuate";
        ReportItemExtensionTest.assertEquals((String)expect, (String)localizedMessage);
    }

    public void testSelectorDisplayLabel() throws Exception {
        this.createDesign(ULocale.ENGLISH);
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("testing-matrix");
        ReportItemExtensionTest.assertEquals((String)"Testing Matrix", (String)style.getDisplayLabel());
    }

    public void testGetPropertyDefns() throws Exception {
        this.openDesign(this.fileName_10, ULocale.ENGLISH);
        ReportItemExtensionTest.assertNotNull((Object)this.designHandle);
        ExtendedItemHandle extendedItemHandle = (ExtendedItemHandle)this.designHandle.findElement("testMatrixItem");
        ReportItemExtensionTest.assertNotNull((Object)extendedItemHandle);
        ElementPropertyDefn defn = extendedItemHandle.getElement().getPropertyDefn("abc");
        ReportItemExtensionTest.assertNotNull((Object)defn);
        ReportItemExtensionTest.assertTrue((boolean)(defn instanceof UserPropertyDefn));
    }

    public void testAltTextProperty() throws Exception {
        this.openDesign("ExtensionTest_AltText.xml");
        ExtendedItemHandle extendedHandle = (ExtendedItemHandle)this.designHandle.getBody().get(0);
        ReportItemExtensionTest.assertNotNull((Object)extendedHandle);
        ReportItemExtensionTest.assertEquals((String)"chart is beautiful", (String)extendedHandle.getAltText());
        ReportItemExtensionTest.assertEquals((String)"chart id", (String)extendedHandle.getAltTextKey());
        extendedHandle.setAltText("chart alt text");
        extendedHandle.setAltTextKey("chart id 2");
        ReportItemExtensionTest.assertEquals((String)"chart alt text", (String)extendedHandle.getAltText());
        ReportItemExtensionTest.assertEquals((String)"chart id 2", (String)extendedHandle.getAltTextKey());
        this.save();
        ReportItemExtensionTest.assertTrue((boolean)this.compareFile("ExtensionTest_AltText_golden.xml"));
    }

    public void testExtensionDefaultStyle() throws SemanticException, DesignFileException {
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = session.createDesign();
        boolean findboxStyle = false;
        SlotHandle styles = this.designHandle.getStyles();
        StyleHandle boxDefaultStyle = null;
        assert (styles != null);
        int i = 0;
        while (i < styles.getCount()) {
            boxDefaultStyle = (StyleHandle)styles.get(i);
            if (boxDefaultStyle.getName().equals("BoxStyle")) {
                findboxStyle = true;
                break;
            }
            ++i;
        }
        ReportItemExtensionTest.assertTrue((boolean)findboxStyle);
        ExtendedItemHandle elementHandle = this.designHandle.getElementFactory().newExtendedItem(null, TESTING_BOX_NAME);
        ReportItemExtensionTest.assertNotNull((Object)elementHandle.getName());
        ReportItemExtensionTest.assertEquals((String)"BoxStyle", (String)boxDefaultStyle.getName());
        ReportItemExtensionTest.assertEquals((String)"#CCCCCC", (String)boxDefaultStyle.getColor().getStringValue());
        ReportItemExtensionTest.assertEquals((String)"solid", (String)boxDefaultStyle.getBorderBottomStyle());
        ReportItemExtensionTest.assertEquals((String)"1pt", (String)boxDefaultStyle.getBorderBottomWidth().getValue().toString());
        ReportItemExtensionTest.assertEquals((String)"10pt", (String)boxDefaultStyle.getMarginRight().getValue().toString());
        ReportItemExtensionTest.assertEquals((String)"Tahoma", (String)boxDefaultStyle.getFontFamilyHandle().getStringValue());
        ReportItemExtensionTest.assertEquals((String)"12pt", (String)boxDefaultStyle.getFontSize().getValue().toString());
    }

    class MyListener
    implements Listener {
        static final int NA = 0;
        static final int PROPERTY_EVENT = 1;
        static final int PROPERTY_LIST_EVENT = 2;
        static final int STYLE_EVENT = 3;
        int action = 0;

        MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            if (ev.getEventType() == 5) {
                this.action = 1;
            } else if (ev.getEventType() == 9) {
                this.action = 2;
            } else if (ev.getEventType() == 6) {
                this.action = 3;
            } else assert (false);
        }
    }
}

