/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.MessageConstants;
import org.eclipse.birt.report.model.i18n.ModelResourceHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class MessageFileTest
extends BaseTestCase {
    Properties props = new Properties();
    static final String DISPLAY_NAME_ID_ATTRIB = "displayNameID";
    static final String TOOL_TIP_ID_ATTRIB = "toolTipID";
    static final String TAG_ID_ATTRIB = "tagID";
    static final String ROM_FILE = "rom.def";
    static final String MESSAGE_FILE = "Messages.properties";
    static final String CHARSET = "8859_1";
    Map displayNameMap = new LinkedHashMap();
    Map toolTipMap = new LinkedHashMap();
    Map tagMap = new LinkedHashMap();

    protected void setUp() throws Exception {
        super.setUp();
        this.props.load(ModelResourceHandle.class.getResourceAsStream(MESSAGE_FILE));
        this.gatherDisplayNameIDs();
    }

    private void gatherDisplayNameIDs() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(ReportDesign.class.getResourceAsStream(ROM_FILE)));
        String line = null;
        int lineCount = 0;
        while ((line = br.readLine()) != null) {
            String tagId;
            String toolTipId;
            ++lineCount;
            String displayNameId = this.getResourceKey(line, DISPLAY_NAME_ID_ATTRIB);
            if (displayNameId != null) {
                this.displayNameMap.put(String.valueOf(lineCount), displayNameId);
            }
            if ((toolTipId = this.getResourceKey(line, TOOL_TIP_ID_ATTRIB)) != null) {
                this.toolTipMap.put(String.valueOf(lineCount), toolTipId);
            }
            if ((tagId = this.getResourceKey(line, TAG_ID_ATTRIB)) == null) continue;
            this.tagMap.put(String.valueOf(lineCount), tagId);
        }
        br.close();
    }

    private String getResourceKey(String line, String name) {
        int index1 = line.indexOf(name);
        if (index1 == -1) {
            return null;
        }
        int index2 = line.indexOf(61, index1);
        if (index2 == -1) {
            return null;
        }
        String str = line.substring(index1, index2);
        if (!name.equalsIgnoreCase(str.trim())) {
            return null;
        }
        int start = line.indexOf(34, index1);
        int end = line.indexOf(34, start + 1);
        String id = line.substring(start + 1, end);
        return id;
    }

    public void testRom() {
        boolean success = true;
        success = MessageFileTest.checkResourceKeyMap(this.displayNameMap, this.props);
        success &= MessageFileTest.checkResourceKeyMap(this.toolTipMap, this.props);
        MessageFileTest.assertTrue((boolean)(success &= MessageFileTest.checkResourceKeyMap(this.tagMap, this.props)));
    }

    private static boolean checkResourceKeyMap(Map map, Properties props) {
        boolean success = true;
        for (String lineNo : map.keySet()) {
            String resourceKey = (String)map.get(lineNo);
            if (props.containsKey(resourceKey)) continue;
            System.out.println("line " + lineNo + ":" + resourceKey + " not exist in message file");
            success = false;
        }
        return success;
    }

    public void testDuplicateMessages() throws IOException {
        boolean success = true;
        InputStream is = ModelResourceHandle.class.getResourceAsStream(MESSAGE_FILE);
        BufferedReader in = new BufferedReader(new InputStreamReader(is, CHARSET));
        Hashtable<String, String> collection = new Hashtable<String, String>();
        String line = in.readLine();
        int lineIndex = 1;
        while (line != null) {
            if (StringUtil.isBlank((String)line) || line.startsWith("#")) {
                line = in.readLine();
                ++lineIndex;
                continue;
            }
            String[] data = line.split("=");
            if (data.length != 2) {
                System.out.println("errors of i18n in line " + lineIndex);
                line = in.readLine();
                ++lineIndex;
                continue;
            }
            if (collection.containsKey(data[0])) {
                System.out.println("duplicate messages in line " + lineIndex);
                success = false;
            } else {
                collection.put(data[0], data[1]);
            }
            line = in.readLine();
            ++lineIndex;
        }
        MessageFileTest.assertTrue((boolean)success);
    }

    public void testMessageConstants() throws IllegalArgumentException, IllegalAccessException {
        int PUBLIC_FINAL_STATIC = 25;
        boolean success = true;
        Field[] fields = MessageConstants.class.getFields();
        String resourceKey = null;
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (PUBLIC_FINAL_STATIC == field.getModifiers() && !this.props.containsKey(resourceKey = (String)fields[i].get(null))) {
                System.out.println("ResourceKey: " + resourceKey + " not exist in message file.");
                success = false;
            }
            ++i;
        }
        MessageFileTest.assertTrue((boolean)success);
    }

    public void testDisplayNameOfTabularMeasureGroup() throws Exception {
        this.createDesign();
        TabularMeasureGroupHandle measureGroupHandle = this.designHandle.getElementFactory().newTabularMeasureGroup("");
        MessageFileTest.assertEquals((String)"Summary Field", (String)measureGroupHandle.getName());
        measureGroupHandle = this.designHandle.getElementFactory().newTabularMeasureGroup("");
        MessageFileTest.assertEquals((String)"Summary Field1", (String)measureGroupHandle.getName());
    }
}

