/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class PropertyLocalizationTest
extends BaseTestCase {
    PropertyType propertyType = null;
    List cases = new ArrayList();

    protected void setUp() throws Exception {
        super.setUp();
        this.prepareCases("input/input.txt");
    }

    private void prepareCases(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getResourceAStream(fileName)));
        String line = null;
        int lineNo = 0;
        while ((line = br.readLine()) != null) {
            ++lineNo;
            if (line.startsWith("#") || StringUtil.isBlank((String)line)) continue;
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 5) {
                throw new Exception("Invalid input, lineNo = " + lineNo + " tokens = " + st.countTokens());
            }
            String element = st.nextToken();
            String propName = st.nextToken();
            String locale = st.nextToken();
            String inputString = st.nextToken();
            if (inputString.startsWith("\\u")) {
                inputString = this.convertToUnicodeString(inputString);
            }
            String isOK = st.nextToken();
            Case newCase = new Case();
            DesignElement designElement = null;
            try {
                designElement = (DesignElement)Class.forName("org.eclipse.birt.report.model.elements." + element).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new Exception("Invalid element name, lineNo = " + lineNo, e);
            }
            if ("P".equalsIgnoreCase(isOK)) {
                newCase.isOK = true;
            } else if ("F".equalsIgnoreCase(isOK)) {
                newCase.isOK = false;
            } else {
                throw new Exception("Only P/F allowed for 'isOK' column, lineNo = " + lineNo);
            }
            int index = locale.indexOf(95);
            if (index != -1) {
                String language = locale.substring(0, index);
                String country = locale.substring(index + 1);
                newCase.locale = new ULocale(language, country);
            } else {
                newCase.locale = new ULocale(locale);
            }
            newCase.element = designElement;
            newCase.inputString = inputString;
            newCase.propName = propName;
            newCase.lineNo = lineNo;
            this.cases.add(newCase);
        }
    }

    private String convertToUnicodeString(String input) throws Exception {
        assert (input.length() % 6 == 0);
        assert (input.startsWith("\\u"));
        String output = "";
        String[] chars = input.split("\\\\u");
        int i = 0;
        while (i < chars.length) {
            if (chars[i].length() != 0) {
                output = String.valueOf(output) + this.convertToUnicodeChar(chars[i]);
            }
            ++i;
        }
        return output;
    }

    private String convertToUnicodeChar(String input) throws Exception {
        assert (input.length() == 4);
        byte[] bb = new byte[]{(byte)Integer.parseInt(input.substring(0, 2), 16), (byte)Integer.parseInt(input.substring(2, 4), 16)};
        return new String(bb, "UTF-16");
    }

    public void testSetStringProperty() throws DesignFileException {
        Case aCase = null;
        int i = 0;
        while (i < this.cases.size()) {
            aCase = (Case)this.cases.get(i);
            this.openDesign("PropertyLocalizationTest.xml", aCase.locale);
            MockupElementHandle elementHandle = new MockupElementHandle(this.design, aCase.element);
            if (aCase.isOK) {
                try {
                    elementHandle.setProperty(aCase.propName, aCase.inputString);
                }
                catch (SemanticException e) {
                    PropertyLocalizationTest.fail((String)("Case fail, lineNo : " + aCase.lineNo + "   " + e.toString()));
                }
            } else {
                try {
                    elementHandle.setProperty(aCase.propName, aCase.inputString);
                    PropertyLocalizationTest.fail((String)("Case fail, lineNo : " + aCase.lineNo));
                }
                catch (SemanticException semanticException) {}
            }
            ++i;
        }
    }

    public void testToDisplayStringInEn() throws Exception {
        this.openDesign("PropertyLocalizationTest.xml", ULocale.ENGLISH);
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(4);
        PropertyLocalizationTest.assertEquals((String)"Red", (String)this.propertyType.toDisplayString(null, null, (Object)"red"));
        PropertyLocalizationTest.assertEquals((String)"Blue", (String)this.propertyType.toDisplayString(null, null, (Object)"blue"));
        PropertyLocalizationTest.assertEquals((String)"RGB(255,0,0)", (String)this.propertyType.toDisplayString((Module)this.design, null, (Object)Integer.decode("#FF0000")));
        PropertyLocalizationTest.assertEquals((String)"RGB(254,220,186)", (String)this.propertyType.toDisplayString((Module)this.design, null, (Object)Integer.decode("#FEDCBA")));
        PropertyLocalizationTest.assertEquals((String)"My Color", (String)this.propertyType.toDisplayString((Module)this.design, null, (Object)"myColor1"));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(11);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = formatter.parse("1981-04-29 06:10:50");
        PropertyLocalizationTest.assertEquals((String)"4/29/81", (String)this.propertyType.toDisplayString(null, null, (Object)date));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(1);
        double d1 = 123456.78;
        BigDecimal number = new BigDecimal(d1);
        PropertyLocalizationTest.assertEquals((String)"123,456.78", (String)this.propertyType.toDisplayString(null, null, (Object)number));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(5);
        SystemPropertyDefn propDefn = new SystemPropertyDefn();
        propDefn.setDetails((Object)MetaDataDictionary.getInstance().getPropertyType(4).getChoices());
        PropertyLocalizationTest.assertEquals((String)"Red", (String)this.propertyType.toDisplayString(null, (PropertyDefn)propDefn, (Object)"red"));
        propDefn.setDetails((Object)MetaDataDictionary.getInstance().getChoiceSet("fontWeight"));
        PropertyLocalizationTest.assertEquals((String)"Bold", (String)this.propertyType.toDisplayString(null, (PropertyDefn)propDefn, (Object)"bold"));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(6);
        PropertyLocalizationTest.assertEquals((String)"true", (String)this.propertyType.toDisplayString(null, null, (Object)new Boolean(true)));
        PropertyLocalizationTest.assertEquals((String)"false", (String)this.propertyType.toDisplayString(null, null, (Object)new Boolean(false)));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(3);
        DimensionValue dimValue = new DimensionValue(123456.78, "cm");
        PropertyLocalizationTest.assertEquals((String)"123,456.78cm", (String)this.propertyType.toDisplayString(null, null, (Object)dimValue));
    }

    public void testToDisplayStringInTestingULocale() throws ParseException, DesignFileException {
        this.openDesign("PropertyLocalizationTest.xml", TEST_LOCALE);
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(4);
        PropertyLocalizationTest.assertEquals((String)"\u7ea2\u8272", (String)this.propertyType.toDisplayString(null, null, (Object)"red"));
        PropertyLocalizationTest.assertEquals((String)"\u84dd\u8272", (String)this.propertyType.toDisplayString(null, null, (Object)"blue"));
        PropertyLocalizationTest.assertEquals((String)"RGB(255,0,0)", (String)this.propertyType.toDisplayString((Module)this.design, null, (Object)Integer.decode("#FF0000")));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(6);
        PropertyLocalizationTest.assertEquals((String)"\u771f", (String)this.propertyType.toDisplayString(null, null, (Object)new Boolean(true)));
        PropertyLocalizationTest.assertEquals((String)"\u5047", (String)this.propertyType.toDisplayString(null, null, (Object)new Boolean(false)));
        ThreadResources.setLocale((ULocale)ULocale.CHINA);
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(11);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = formatter.parse("1981-04-29 06:10:50");
        PropertyLocalizationTest.assertEquals((String)"81-4-29", (String)this.propertyType.toDisplayString(null, null, (Object)date));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(1);
        double d = 123456.78;
        BigDecimal number = new BigDecimal(d);
        PropertyLocalizationTest.assertEquals((String)"123,456.78", (String)this.propertyType.toDisplayString(null, null, (Object)number));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(14);
        double d1 = 123456.78;
        Double number1 = new Double(d1);
        PropertyLocalizationTest.assertEquals((String)"123,456.78", (String)this.propertyType.toDisplayString(null, null, (Object)number1));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(3);
        DimensionValue dimValue = new DimensionValue(123456.78, "cm");
        PropertyLocalizationTest.assertEquals((String)"123,456.78cm", (String)this.propertyType.toDisplayString(null, null, (Object)dimValue));
        dimValue = new DimensionValue(123456.78, "mm");
        PropertyLocalizationTest.assertEquals((String)"123,456.78mm", (String)this.propertyType.toDisplayString(null, null, (Object)dimValue));
    }

    public void testValidateInputStringInEn() throws PropertyValueException, DesignFileException {
        this.openDesign("PropertyLocalizationTest.xml", ULocale.ENGLISH);
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(4);
        PropertyLocalizationTest.assertEquals((Object)Integer.decode("#FF0000"), (Object)this.propertyType.validateInputString((Module)this.design, null, "RGB( 255, 0, 0 )"));
        PropertyLocalizationTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.propertyType.validateInputString((Module)this.design, null, "RGB( 400, 0, 300 )"));
        PropertyLocalizationTest.assertEquals((Object)Integer.decode("#FF0000"), (Object)this.propertyType.validateInputString((Module)this.design, null, "RGB( 255%, 0%, 0% )"));
        PropertyLocalizationTest.assertEquals((Object)Integer.decode("#FF00FF"), (Object)this.propertyType.validateInputString((Module)this.design, null, "RGB( 300%, 0%, 268% )"));
        PropertyLocalizationTest.assertEquals((Object)"red", (Object)this.propertyType.validateInputString((Module)this.design, null, "red"));
        try {
            this.propertyType.validateInputString((Module)this.design, null, "None-exist-color-name");
            PropertyLocalizationTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(11);
        Date date = (Date)this.propertyType.validateInputString((Module)this.design, null, "04/29/81");
        PropertyLocalizationTest.assertEquals((int)3, (int)date.getMonth());
        PropertyLocalizationTest.assertEquals((int)29, (int)date.getDate());
        PropertyLocalizationTest.assertEquals((int)81, (int)date.getYear());
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(5);
        UserPropertyDefn propDefn = new UserPropertyDefn();
        propDefn.setType(this.propertyType);
        propDefn.setDetails((Object)MetaDataDictionary.getInstance().getPropertyType(4).getChoices());
        PropertyLocalizationTest.assertEquals((Object)"red", (Object)this.propertyType.validateInputString(null, (PropertyDefn)propDefn, "red"));
        try {
            this.propertyType.validateInputString((Module)this.design, (PropertyDefn)propDefn, "None-exist-color-name");
            PropertyLocalizationTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
        propDefn.setDetails((Object)MetaDataDictionary.getInstance().getChoiceSet("fontWeight"));
        PropertyLocalizationTest.assertEquals((Object)"normal", (Object)this.propertyType.validateInputString(null, (PropertyDefn)propDefn, "normal"));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(6);
        PropertyLocalizationTest.assertEquals((Object)new Boolean(true), (Object)this.propertyType.validateInputString(null, null, "true"));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(14);
        double d1 = 123456.78;
        Double number1 = new Double(d1);
        PropertyLocalizationTest.assertEquals((String)"123,456.78", (String)this.propertyType.toDisplayString(null, null, (Object)number1));
    }

    public void testValidateInputStringInZH_CN() throws PropertyValueException {
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(4);
        PropertyLocalizationTest.assertEquals((Object)"red", (Object)this.propertyType.validateInputString(null, null, "\u7ea2\u8272"));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(5);
        UserPropertyDefn propDefn = new UserPropertyDefn();
        propDefn.setType(this.propertyType);
        propDefn.setDetails((Object)MetaDataDictionary.getInstance().getPropertyType(4).getChoices());
        PropertyLocalizationTest.assertEquals((Object)"red", (Object)this.propertyType.validateInputString(null, (PropertyDefn)propDefn, "\u7ea2\u8272"));
        propDefn.setDetails((Object)MetaDataDictionary.getInstance().getChoiceSet("fontWeight"));
        PropertyLocalizationTest.assertEquals((Object)"normal", (Object)this.propertyType.validateInputString(null, (PropertyDefn)propDefn, "\u6807\u51c6"));
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(6);
        PropertyLocalizationTest.assertEquals((Object)new Boolean(true), (Object)this.propertyType.validateInputString(null, null, "\u771f"));
        PropertyLocalizationTest.assertEquals((Object)new Boolean(false), (Object)this.propertyType.validateInputString(null, null, "\u5047"));
        ThreadResources.setLocale((ULocale)ULocale.CHINA);
        this.propertyType = MetaDataDictionary.getInstance().getPropertyType(11);
        Date date = (Date)this.propertyType.validateInputString(null, null, "81-4-29");
        PropertyLocalizationTest.assertEquals((int)3, (int)date.getMonth());
        PropertyLocalizationTest.assertEquals((int)29, (int)date.getDate());
        PropertyLocalizationTest.assertEquals((int)81, (int)date.getYear());
    }

    static class Case {
        DesignElement element = null;
        String propName = null;
        ULocale locale = null;
        String inputString = null;
        boolean isOK = false;
        int lineNo;

        Case() {
        }
    }

    static class MockupElementHandle
    extends DesignElementHandle {
        DesignElement element = null;

        MockupElementHandle(ReportDesign design, DesignElement element) {
            super((Module)design);
            this.element = element;
        }

        public DesignElement getElement() {
            return this.element;
        }
    }
}

