/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryChangeChartDataSetTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("DesignWithChartLibrary.xml");
    }

    public void testChangeTableDataSet() throws SemanticException {
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("NewTable");
        LibraryChangeChartDataSetTest.assertNotNull((Object)tableHandle);
        int count = this.getColumnBindingsCount(tableHandle.columnBindingsIterator());
        LibraryChangeChartDataSetTest.assertEquals((int)7, (int)count);
        DataSetHandle newDsHandle = (DataSetHandle)this.designHandle.getElementByID(6L);
        LibraryChangeChartDataSetTest.assertNotNull((Object)newDsHandle);
        try {
            tableHandle.setDataSet(newDsHandle);
        }
        catch (SemanticException e) {
            LibraryChangeChartDataSetTest.fail((String)("can't set data set " + e.getMessage()));
        }
        this.addColumnBindings((ReportItemHandle)tableHandle, newDsHandle);
        Iterator iterator = tableHandle.columnBindingsIterator();
        count = this.getColumnBindingsCount(iterator);
        LibraryChangeChartDataSetTest.assertEquals((int)5, (int)count);
    }

    private int getColumnBindingsCount(Iterator iterator) {
        int count = 0;
        while (iterator != null && iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) continue;
            ++count;
        }
        return count;
    }

    public void testChangeChartDataSet() throws SemanticException {
        ExtendedItemHandle itemHandle = (ExtendedItemHandle)this.designHandle.findElement("NewTestingMatrix");
        LibraryChangeChartDataSetTest.assertNotNull((Object)itemHandle);
        int count = this.getColumnBindingsCount(itemHandle.columnBindingsIterator());
        LibraryChangeChartDataSetTest.assertEquals((int)5, (int)count);
        DataSetHandle newDsHandle = (DataSetHandle)this.designHandle.getElementByID(7L);
        LibraryChangeChartDataSetTest.assertNotNull((Object)newDsHandle);
        try {
            itemHandle.setDataSet(newDsHandle);
        }
        catch (SemanticException e) {
            LibraryChangeChartDataSetTest.fail((String)("can't set data set " + e.getMessage()));
        }
        this.addColumnBindings((ReportItemHandle)itemHandle, newDsHandle);
        Iterator iterator = itemHandle.columnBindingsIterator();
        count = this.getColumnBindingsCount(iterator);
        LibraryChangeChartDataSetTest.assertEquals((int)7, (int)count);
    }

    private void addColumnBindings(ReportItemHandle itemHandle, DataSetHandle dsHandle) throws SemanticException {
        itemHandle.getColumnBindings().clearValue();
        CachedMetaDataHandle meta = dsHandle.getCachedMetaDataHandle();
        MemberHandle resultSet = meta.getResultSet();
        if (resultSet.getListValue() != null) {
            int i = 0;
            while (i < resultSet.getListValue().size()) {
                ResultSetColumnHandle resultSetColumn = (ResultSetColumnHandle)resultSet.getAt(i);
                ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)itemHandle, (String)resultSetColumn.getColumnName());
                column.setDataType(resultSetColumn.getDataType());
                column.setExpression("row[" + resultSetColumn.getColumnName() + "]");
                itemHandle.addColumnBinding(column, false);
                ++i;
            }
        }
    }
}

