/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryCompoundElementTest
extends BaseTestCase {
    private static final String INPUT1 = "DesignWithLibraryCompoundElement.xml";
    private static final String GOLDEN_FILE = "DesignWithLibraryCompoundElement_golden.xml";
    private static final String FILE_NAME = "DesignWithElementProperty.xml";
    private static final String GOLDEN_FILE_1 = "DesignWithElementProperty_golden.xml";

    public void testParser() throws Exception {
        this.openDesign(INPUT1, ULocale.ENGLISH);
        TableHandle bodyTable = (TableHandle)this.designHandle.findElement("table1");
        LibraryCompoundElementTest.assertEquals((String)"New Design Table", (String)bodyTable.getCaption());
        LibraryCompoundElementTest.assertEquals((String)"blue", (String)bodyTable.getStringProperty("color"));
        LibraryCompoundElementTest.assertEquals((String)"bolder", (String)bodyTable.getStringProperty("fontWeight"));
        TableRow row = (TableRow)bodyTable.getElement().getSlot(0).getContent(0);
        GroupHandle group1 = (GroupHandle)bodyTable.getGroups().get(0);
        LibraryCompoundElementTest.assertEquals((String)"libTable1Group1", (String)group1.getName());
        LibraryCompoundElementTest.assertEquals((String)"blue", (String)row.getStringProperty((Module)this.design, "color"));
        LibraryCompoundElementTest.assertEquals((String)"\"Arial\"", (String)row.getStringProperty((Module)this.design, "fontFamily"));
        LibraryCompoundElementTest.assertEquals((String)"20pt", (String)row.getStringProperty((Module)this.design, "height"));
        CellHandle bodyCell = (CellHandle)bodyTable.getDetail().get(1).getSlot(0).get(0);
        TableHandle bodyInnerTable = (TableHandle)bodyCell.getContent().get(0);
        RowHandle bodyInnerRow = (RowHandle)bodyInnerTable.getHeader().get(0);
        CellHandle bodyInnerCell = (CellHandle)bodyInnerRow.getCells().get(0);
        LibraryCompoundElementTest.assertEquals((Object)"lime", (Object)bodyInnerCell.getElement().getLocalProperty((Module)this.design, "color"));
        LibraryCompoundElementTest.assertEquals((Object)"\"Arial\"", (Object)bodyInnerCell.getProperty("fontFamily"));
        bodyCell = (CellHandle)bodyTable.getDetail().get(1).getSlot(0).get(1);
        LibraryCompoundElementTest.assertEquals((Object)"aqua", (Object)bodyCell.getProperty("color"));
        ListHandle list = (ListHandle)this.designHandle.findElement("list1");
        LabelHandle label = (LabelHandle)list.getDetail().get(0);
        LibraryCompoundElementTest.assertEquals((String)"base label in library", (String)label.getText());
    }

    public void testWriter() throws Exception {
        this.openDesign(INPUT1, ULocale.ENGLISH);
        TableHandle bodyTable = (TableHandle)this.designHandle.findElement("table1");
        LibraryCompoundElementTest.assertEquals((String)"New Design Table", (String)bodyTable.getCaption());
        RowHandle bodyRow = (RowHandle)bodyTable.getDetail().get(1);
        bodyRow.getPrivateStyle().getColor().setStringValue("fuchsia");
        bodyRow.getHeight().setAbsolute(1.1);
        bodyRow.setBookmark("http://www.eclipse.org/birt");
        CellHandle bodyCell = (CellHandle)bodyRow.getCells().get(0);
        bodyCell.getPrivateStyle().getColor().setStringValue("red");
        TableHandle bodyInnerTable = (TableHandle)bodyCell.getContent().get(0);
        bodyInnerTable.setName("New Table");
        bodyInnerTable.setStyleName("new_style");
        RowHandle bodyInnerRow = (RowHandle)bodyInnerTable.getHeader().get(0);
        CellHandle bodyInnerCell = (CellHandle)bodyInnerRow.getCells().get(0);
        bodyInnerCell.getPrivateStyle().getColor().setStringValue("navy");
        this.save();
        LibraryCompoundElementTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE));
    }

    public void testParserForElementProperty() throws Exception {
        this.openDesign(FILE_NAME);
        Library lib = this.design.getLibraryWithNamespace("lib");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("designCube");
        LibraryCompoundElementTest.assertEquals((Object)lib.findDataSet("firstDataSet"), (Object)cube.getDataSet().getElement());
        Iterator iter = cube.filtersIterator();
        FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
        LibraryCompoundElementTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        PropertyHandle propHandle = cube.getPropertyHandle("dimensions");
        LibraryCompoundElementTest.assertEquals((int)1, (int)propHandle.getContentCount());
        LibraryCompoundElementTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        DimensionHandle dimension = (DimensionHandle)propHandle.getContent(0);
        LibraryCompoundElementTest.assertEquals((Object)dimension, (Object)cube.getContent("dimensions", 0));
        LibraryCompoundElementTest.assertEquals((String)"testDimension", (String)dimension.getName());
        LibraryCompoundElementTest.assertTrue((boolean)dimension.isTimeType());
        propHandle = dimension.getPropertyHandle("hierarchies");
        LibraryCompoundElementTest.assertEquals((int)1, (int)propHandle.getContentCount());
        LibraryCompoundElementTest.assertEquals((int)1, (int)dimension.getContentCount("hierarchies"));
        TabularHierarchyHandle hierarchy = (TabularHierarchyHandle)propHandle.getContent(0);
        LibraryCompoundElementTest.assertEquals((Object)hierarchy, (Object)dimension.getContent("hierarchies", 0));
        LibraryCompoundElementTest.assertEquals((Object)hierarchy, (Object)dimension.getDefaultHierarchy());
        LibraryCompoundElementTest.assertEquals((String)"testHierarchy", (String)hierarchy.getName());
        LibraryCompoundElementTest.assertEquals((Object)lib.findDataSet("secondDataSet"), (Object)hierarchy.getDataSet().getElement());
        propHandle = cube.getPropertyHandle("dimensions");
        LibraryCompoundElementTest.assertEquals((int)1, (int)propHandle.getContentCount());
        LibraryCompoundElementTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        iter = hierarchy.filtersIterator();
        filterConditionHandle = (FilterConditionHandle)iter.next();
        LibraryCompoundElementTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        List primaryKeys = hierarchy.getPrimaryKeys();
        LibraryCompoundElementTest.assertEquals((int)3, (int)primaryKeys.size());
        LibraryCompoundElementTest.assertEquals((Object)"key", primaryKeys.get(0));
        LibraryCompoundElementTest.assertEquals((Object)"key2", primaryKeys.get(1));
        LibraryCompoundElementTest.assertEquals((Object)"key4", primaryKeys.get(2));
        propHandle = hierarchy.getPropertyHandle("levels");
        LibraryCompoundElementTest.assertEquals((int)1, (int)propHandle.getContentCount());
        LibraryCompoundElementTest.assertEquals((int)1, (int)hierarchy.getContentCount("levels"));
        TabularLevelHandle level = (TabularLevelHandle)propHandle.getContent(0);
        LibraryCompoundElementTest.assertEquals((Object)level, (Object)hierarchy.getContent("levels", 0));
        LibraryCompoundElementTest.assertEquals((String)"testLevel", (String)level.getName());
        LibraryCompoundElementTest.assertEquals((String)"column1", (String)level.getColumnName());
        LibraryCompoundElementTest.assertEquals((String)"integer", (String)level.getDataType());
        LibraryCompoundElementTest.assertEquals((String)"prefix", (String)level.getInterval());
        LibraryCompoundElementTest.assertEquals((double)3.0, (double)level.getIntervalRange(), (double)0.0);
        LibraryCompoundElementTest.assertEquals((String)"Jan", (String)level.getIntervalBase());
        LibraryCompoundElementTest.assertEquals((String)"dynamic", (String)level.getLevelType());
        iter = level.staticValuesIterator();
        RuleHandle rule = (RuleHandle)iter.next();
        LibraryCompoundElementTest.assertEquals((String)"rule expression", (String)rule.getRuleExpression());
        LibraryCompoundElementTest.assertEquals((String)"display expression", (String)rule.getDisplayExpression());
        rule = (RuleHandle)iter.next();
        LibraryCompoundElementTest.assertEquals((String)"rule expression2", (String)rule.getRuleExpression());
        LibraryCompoundElementTest.assertEquals((String)"display expression2", (String)rule.getDisplayExpression());
        iter = level.attributesIterator();
        LevelAttributeHandle attribute = (LevelAttributeHandle)iter.next();
        LibraryCompoundElementTest.assertEquals((String)"var1", (String)attribute.getName());
        LibraryCompoundElementTest.assertEquals((String)"string", (String)attribute.getDataType());
        attribute = (LevelAttributeHandle)iter.next();
        LibraryCompoundElementTest.assertEquals((String)"var2", (String)attribute.getName());
        LibraryCompoundElementTest.assertEquals((String)"integer", (String)attribute.getDataType());
        propHandle = cube.getPropertyHandle("measureGroups");
        LibraryCompoundElementTest.assertEquals((int)1, (int)propHandle.getContentCount());
        LibraryCompoundElementTest.assertEquals((int)1, (int)cube.getContentCount("measureGroups"));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)propHandle.getContent(0);
        LibraryCompoundElementTest.assertEquals((Object)measureGroup, (Object)cube.getContent("measureGroups", 0));
        LibraryCompoundElementTest.assertEquals((String)"testMeasureGroup", (String)measureGroup.getName());
        LibraryCompoundElementTest.assertEquals((Object)measureGroup, (Object)cube.getDefaultMeasureGroup());
        propHandle = measureGroup.getPropertyHandle("measures");
        MeasureHandle measure = (MeasureHandle)propHandle.getContent(0);
        LibraryCompoundElementTest.assertEquals((String)"testMeasure", (String)measure.getName());
        LibraryCompoundElementTest.assertEquals((String)"column", (String)measure.getMeasureExpression());
        LibraryCompoundElementTest.assertEquals((String)"min", (String)measure.getFunction());
        LibraryCompoundElementTest.assertFalse((boolean)measure.isCalculated());
    }

    public void testWriterForElementProperty() throws Exception {
        this.openDesign(FILE_NAME);
        LibraryHandle libHandle = this.designHandle.getLibrary("lib");
        DesignElementHandle childCube = this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libHandle.findCube("testCube"), "designChildCube");
        DesignElementHandle cubeHandle = this.designHandle.getCubes().get(0);
        try {
            cubeHandle.setProperty("dimensions", null);
            LibraryCompoundElementTest.fail();
        }
        catch (SemanticException e) {
            LibraryCompoundElementTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)e.getErrorCode());
        }
        cubeHandle.drop();
        this.designHandle.getCubes().add(childCube);
        this.save();
        LibraryCompoundElementTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE_1));
    }
}

