/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryWithCubeTest
extends BaseTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testLoadCube() throws Exception {
        this.openDesign("LibraryWithCubeTest.xml");
        CubeHandle cubeHandle = (CubeHandle)this.designHandle.getCubes().get(0);
        LibraryWithCubeTest.assertNotNull((Object)cubeHandle.getMeasure("QUANTITY_PRICE"));
        LibraryWithCubeTest.assertNotNull((Object)cubeHandle.getMeasure("QUANTITY"));
    }

    public void writeExtendedCube() throws Exception {
        this.openLibrary("LibraryWithCubeTest_Lib.xml");
        CubeHandle cubeHandle = (CubeHandle)this.libraryHandle.getAllCubes().get(0);
        this.openDesign("BlankLibraryWithCubeTest.xml");
        CubeHandle newCubeHandle = (CubeHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)cubeHandle, "extenedCube");
        this.designHandle.getCubes().add((DesignElementHandle)newCubeHandle);
        this.save();
        LibraryWithCubeTest.assertTrue((boolean)this.compareFile("LibraryWithCubeTest.xml"));
    }
}

