/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.BooleanPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class BooleanPropertyTypeTest
extends PropertyTypeTestCase {
    BooleanPropertyType type = new BooleanPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    public void testGetTypeCode() {
        BooleanPropertyTypeTest.assertEquals((int)6, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        BooleanPropertyTypeTest.assertEquals((String)"boolean", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        BooleanPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, this.propDefn, null));
        BooleanPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)" "));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)"true"));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)"false"));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)"\u771f"));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)"\u5047"));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)Boolean.TRUE));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)Boolean.FALSE));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new Integer(1)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new Integer(2)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new Integer(0)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new Double(1.0)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new Double(2.0)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new Double(0.0)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new BigDecimal(1.0)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new BigDecimal(2.0)));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)new BigDecimal(0.0)));
        try {
            this.type.validateValue((Module)this.design, this.propDefn, new Object());
            BooleanPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            BooleanPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateInputString() throws PropertyValueException {
        BooleanPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, this.propDefn, null));
        BooleanPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, this.propDefn, " "));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateInputString((Module)this.design, this.propDefn, "true"));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateInputString((Module)this.design, this.propDefn, "false"));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateInputString((Module)this.design, this.propDefn, "\u771f"));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateInputString((Module)this.design, this.propDefn, "\u5047"));
        try {
            this.type.validateInputString((Module)this.design, this.propDefn, "wrong-type-value");
            BooleanPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            BooleanPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateXml() throws PropertyValueException {
        BooleanPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, null));
        BooleanPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)" "));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.TRUE, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)"true"));
        BooleanPropertyTypeTest.assertEquals((Object)Boolean.FALSE, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)"false"));
        try {
            this.type.validateXml((Module)this.design, this.propDefn, (Object)"wrong-xml-value");
            BooleanPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            BooleanPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testToDouble() {
        BooleanPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, null), (double)1.0);
        BooleanPropertyTypeTest.assertEquals((double)1.0, (double)this.type.toDouble((Module)this.design, (Object)Boolean.TRUE), (double)1.0);
        BooleanPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, (Object)Boolean.FALSE), (double)1.0);
    }

    public void testToInteger() {
        BooleanPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, null));
        BooleanPropertyTypeTest.assertEquals((int)1, (int)this.type.toInteger((Module)this.design, (Object)Boolean.TRUE));
        BooleanPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, (Object)Boolean.FALSE));
    }

    public void testToXml() {
        BooleanPropertyTypeTest.assertEquals((String)"true", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)Boolean.TRUE));
        BooleanPropertyTypeTest.assertEquals((String)"false", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)Boolean.FALSE));
    }

    public void testToString() {
        BooleanPropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        BooleanPropertyTypeTest.assertEquals((String)"true", (String)this.type.toString((Module)this.design, this.propDefn, (Object)Boolean.TRUE));
        BooleanPropertyTypeTest.assertEquals((String)"false", (String)this.type.toString((Module)this.design, this.propDefn, (Object)Boolean.FALSE));
    }

    public void testToDisplayString() {
        BooleanPropertyTypeTest.assertEquals(null, (String)this.type.toDisplayString((Module)this.design, this.propDefn, null));
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        BooleanPropertyTypeTest.assertEquals((String)"true", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)Boolean.TRUE));
        ThreadResources.setLocale((ULocale)TEST_LOCALE);
        BooleanPropertyTypeTest.assertEquals((String)"\u771f", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)Boolean.TRUE));
    }

    public void testToNumber() {
        BooleanPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, null).doubleValue(), (double)1.0);
        BooleanPropertyTypeTest.assertEquals((double)1.0, (double)this.type.toNumber((Module)this.design, (Object)Boolean.TRUE).doubleValue(), (double)1.0);
        BooleanPropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, (Object)Boolean.FALSE).doubleValue(), (double)1.0);
    }

    public void testToBoolean() {
        BooleanPropertyTypeTest.assertEquals((boolean)false, (boolean)this.type.toBoolean((Module)this.design, null));
        BooleanPropertyTypeTest.assertEquals((boolean)true, (boolean)this.type.toBoolean((Module)this.design, (Object)Boolean.TRUE));
        BooleanPropertyTypeTest.assertEquals((boolean)false, (boolean)this.type.toBoolean((Module)this.design, (Object)Boolean.FALSE));
    }
}

