/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.DateTimePropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class DateTimePropertyTypeTest
extends PropertyTypeTestCase {
    DateTimePropertyType type = new DateTimePropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();
    Calendar calendar = Calendar.getInstance();

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetTypeCode() {
        DateTimePropertyTypeTest.assertEquals((int)11, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        DateTimePropertyTypeTest.assertEquals((String)"dateTime", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        DateTimePropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, this.propDefn, null));
        DateTimePropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)""));
        Date date = this.calendar.getTime();
        DateTimePropertyTypeTest.assertTrue((date == this.type.validateValue((Module)this.design, this.propDefn, (Object)date) ? 1 : 0) != 0);
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        Date value = (Date)this.type.validateValue((Module)this.design, this.propDefn, (Object)"08/25/2004");
        this.calendar.setTime(value);
        DateTimePropertyTypeTest.assertEquals((int)104, (int)(this.calendar.get(1) - 1900));
        DateTimePropertyTypeTest.assertEquals((int)7, (int)this.calendar.get(2));
        DateTimePropertyTypeTest.assertEquals((int)25, (int)this.calendar.get(5));
        ThreadResources.setLocale((ULocale)ULocale.CHINA);
        value = (Date)this.type.validateValue((Module)this.design, this.propDefn, (Object)"2004-08-25");
        DateTimePropertyTypeTest.assertEquals((int)104, (int)(this.calendar.get(1) - 1900));
        DateTimePropertyTypeTest.assertEquals((int)7, (int)this.calendar.get(2));
        DateTimePropertyTypeTest.assertEquals((int)25, (int)this.calendar.get(5));
        try {
            this.type.validateValue((Module)this.design, this.propDefn, (Object)"wrong-datetime-value");
            DateTimePropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DateTimePropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
        try {
            this.type.validateValue((Module)this.design, this.propDefn, new Object());
            DateTimePropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DateTimePropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateInputString() throws PropertyValueException {
        DateTimePropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, this.propDefn, null));
        DateTimePropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, this.propDefn, ""));
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        Date value = (Date)this.type.validateInputString((Module)this.design, this.propDefn, "08/25/2004");
        this.calendar.setTime(value);
        DateTimePropertyTypeTest.assertEquals((int)104, (int)(this.calendar.get(1) - 1900));
        DateTimePropertyTypeTest.assertEquals((int)7, (int)this.calendar.get(2));
        DateTimePropertyTypeTest.assertEquals((int)25, (int)this.calendar.get(5));
        ThreadResources.setLocale((ULocale)ULocale.CHINA);
        value = (Date)this.type.validateInputString((Module)this.design, this.propDefn, "2004-08-25");
        DateTimePropertyTypeTest.assertEquals((int)104, (int)(this.calendar.get(1) - 1900));
        DateTimePropertyTypeTest.assertEquals((int)7, (int)this.calendar.get(2));
        DateTimePropertyTypeTest.assertEquals((int)25, (int)this.calendar.get(5));
        try {
            this.type.validateInputString((Module)this.design, this.propDefn, "wrong-datetime-value");
            DateTimePropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DateTimePropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateXml() throws PropertyValueException {
        DateTimePropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, null));
        DateTimePropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)""));
        Date value = (Date)this.type.validateXml((Module)this.design, this.propDefn, (Object)"2004-10-18 10:34:22");
        this.calendar.setTime(value);
        DateTimePropertyTypeTest.assertEquals((int)104, (int)(this.calendar.get(1) - 1900));
        DateTimePropertyTypeTest.assertEquals((int)9, (int)this.calendar.get(2));
        DateTimePropertyTypeTest.assertEquals((int)18, (int)this.calendar.get(5));
        try {
            this.type.validateXml((Module)this.design, this.propDefn, (Object)"wrong-datetime-value");
            DateTimePropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            DateTimePropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testToDouble() {
    }

    public void testToInteger() {
    }

    public void testToXml() {
        DateTimePropertyTypeTest.assertEquals(null, (String)this.type.toXml((Module)this.design, this.propDefn, null));
        this.calendar.set(2004, 9, 18);
        String value = this.type.toXml((Module)this.design, this.propDefn, (Object)this.calendar.getTime());
        int index = value.indexOf(" ");
        value = value.substring(0, index);
        DateTimePropertyTypeTest.assertEquals((String)"2004-10-18", (String)value);
    }

    public void testToString() {
        DateTimePropertyTypeTest.assertEquals(null, (String)this.type.toString((Module)this.design, this.propDefn, null));
        this.calendar.set(2004, 9, 18);
        ULocale preULocale = ULocale.getDefault();
        ULocale.setDefault((ULocale)ULocale.ENGLISH);
        String value = this.type.toString((Module)this.design, this.propDefn, (Object)this.calendar.getTime());
        DateTimePropertyTypeTest.assertTrue((boolean)value.startsWith("2004-10-18"));
        ULocale.setDefault((ULocale)ULocale.GERMAN);
        value = this.type.toString((Module)this.design, this.propDefn, (Object)this.calendar.getTime());
        DateTimePropertyTypeTest.assertTrue((boolean)value.startsWith("2004-10-18"));
        ULocale.setDefault((ULocale)preULocale);
    }

    public void testToDisplayString() {
        DateTimePropertyTypeTest.assertEquals(null, (String)this.type.toDisplayString((Module)this.design, this.propDefn, null));
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        this.calendar.set(2004, 9, 18);
        String value = this.type.toDisplayString((Module)this.design, this.propDefn, (Object)this.calendar.getTime());
        DateTimePropertyTypeTest.assertEquals((String)"10/18/04", (String)value);
    }

    public void testToNumber() {
    }

    public void testToBoolean() {
    }
}

