/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DimensionValueTest
extends BaseTestCase {
    private DimensionValue value = null;

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetterAndSetter() {
        try {
            this.value = new DimensionValue(12.89, "unsupportedUnit");
            DimensionValueTest.fail();
        }
        catch (RuntimeException e) {
            DimensionValueTest.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        this.value = new DimensionValue(12.89, "mm");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue(("mm" == this.value.getUnits() ? 1 : 0) != 0);
        this.value = new DimensionValue(12.89, "in");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue(("in" == this.value.getUnits() ? 1 : 0) != 0);
    }

    public void testParse() throws PropertyValueException {
        this.value = DimensionValue.parse(null);
        DimensionValueTest.assertNull((Object)this.value);
        this.value = DimensionValue.parse((String)"         ");
        DimensionValueTest.assertNull((Object)this.value);
        this.value = DimensionValue.parse((String)"12.89mm");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertEquals((String)"mm", (String)this.value.getUnits());
        DimensionValueTest.assertEquals((String)"12.89mm", (String)this.value.toString());
        this.value = DimensionValue.parse((String)"12.89 cm");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue(("cm" == this.value.getUnits() ? 1 : 0) != 0);
        DimensionValueTest.assertEquals((String)"12.89cm", (String)this.value.toString());
        this.value = DimensionValue.parse((String)"12.89mm");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue(("mm" == this.value.getUnits() ? 1 : 0) != 0);
        DimensionValueTest.assertEquals((String)"12.89mm", (String)this.value.toString());
        this.value = DimensionValue.parse((String)"12.89in");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue(("in" == this.value.getUnits() ? 1 : 0) != 0);
        DimensionValueTest.assertEquals((String)"12.89in", (String)this.value.toString());
        this.value = DimensionValue.parse((String)"12.89 pt");
        DimensionValueTest.assertTrue((12.89 == this.value.getMeasure() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue(("pt" == this.value.getUnits() ? 1 : 0) != 0);
        DimensionValueTest.assertEquals((String)"12.89pt", (String)this.value.toString());
        try {
            this.value = DimensionValue.parse((String)"12.89 m");
            DimensionValueTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }

    public void testToString() {
        DimensionValue dim = new DimensionValue(1.2000000012345655E8, "cm");
        DimensionValueTest.assertEquals((String)"120000000.12345655cm", (String)dim.toString());
    }

    public void testToDisplayString() {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        DimensionValue dim = new DimensionValue(1.2000000012345655E8, "cm");
        DimensionValueTest.assertEquals((String)"120,000,000.123cm", (String)dim.toDisplayString());
    }

    public void testEquals() {
        DimensionValue v1 = new DimensionValue(25.4, "mm");
        DimensionValue v2 = DimensionUtil.convertTo((double)1.0, (String)"in", (String)"mm");
        DimensionValue v3 = new DimensionValue(25.4, "mm");
        DimensionValue v4 = new DimensionValue(1.0, "in");
        DimensionValueTest.assertFalse((boolean)v1.equals(null));
        DimensionValueTest.assertFalse((boolean)v1.equals((Object)"abc"));
        DimensionValueTest.assertFalse((boolean)v1.equals((Object)v4));
        DimensionValueTest.assertTrue((boolean)v1.equals((Object)v1));
        DimensionValueTest.assertTrue((boolean)v1.equals((Object)v2));
        DimensionValueTest.assertTrue((v1.hashCode() == v2.hashCode() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue((boolean)v2.equals((Object)v1));
        DimensionValueTest.assertTrue((boolean)v2.equals((Object)v3));
        DimensionValueTest.assertTrue((v2.hashCode() == v3.hashCode() ? 1 : 0) != 0);
        DimensionValueTest.assertTrue((boolean)v3.equals((Object)v1));
        DimensionValueTest.assertTrue((v1.hashCode() == v3.hashCode() ? 1 : 0) != 0);
        v1 = new DimensionValue(10.098, "mm");
        v2 = new DimensionValue(10.098, "mm");
        DimensionValueTest.assertTrue((boolean)v1.equals((Object)v2));
        DimensionValueTest.assertTrue((v1.hashCode() == v2.hashCode() ? 1 : 0) != 0);
        v1 = new DimensionValue(10.098, "in");
        v2 = new DimensionValue(10.098, "mm");
        DimensionValueTest.assertFalse((boolean)v1.equals((Object)v2));
        DimensionValueTest.assertFalse((v1.hashCode() == v3.hashCode() ? 1 : 0) != 0);
        v1 = new DimensionValue(10.098, "in");
        v2 = new DimensionValue(10.098, "IN");
        DimensionValueTest.assertTrue((boolean)v1.equals((Object)v2));
        DimensionValueTest.assertTrue((v1.hashCode() == v2.hashCode() ? 1 : 0) != 0);
    }
}

