/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.NamePropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.TextualPropertyTypeTestCase;

public class NamePropertyTypeTest
extends TextualPropertyTypeTestCase {
    NamePropertyType type = new NamePropertyType();
    PropertyDefnFake propDefn = new PropertyDefnFake();

    protected void setUp() throws Exception {
        MetaDataDictionary.getInstance();
        MetaDataDictionary.reset();
        engine = null;
        super.setUp();
    }

    public void testGetTypeCode() {
        NamePropertyTypeTest.assertEquals((int)13, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        NamePropertyTypeTest.assertEquals((String)"name", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        int value = 6;
        this.propDefn.setTrimOption(value);
        NamePropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, null));
        NamePropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, (Object)""));
        NamePropertyTypeTest.assertEquals((Object)"abc", (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, (Object)"abc"));
        NamePropertyTypeTest.assertEquals((Object)"abc", (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, (Object)"    abc "));
        NamePropertyTypeTest.assertEquals((Object)"a bc", (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, (Object)"a bc"));
        NamePropertyTypeTest.assertEquals((Object)"ab9c", (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, (Object)"ab9c"));
        NamePropertyTypeTest.assertEquals((Object)"9abc", (Object)this.type.validateValue((Module)this.design, (PropertyDefn)this.propDefn, (Object)"9abc"));
        try {
            PropertyDefn namePropDefn = (PropertyDefn)MetaDataDictionary.getInstance().getElement("DataSet").getProperty("name");
            NamePropertyTypeTest.assertEquals((Object)"ab.9c", (Object)this.type.validateValue((Module)this.design, namePropDefn, (Object)"ab.9c"));
            NamePropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            NamePropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateInputString() throws PropertyValueException {
    }

    public void testValidateXml() throws PropertyValueException {
    }

    public void testToDouble() {
        NamePropertyTypeTest.assertEquals((double)0.0, (double)this.type.toDouble((Module)this.design, (Object)"any-input"), (double)1.0);
    }

    public void testToInteger() {
        NamePropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, (Object)"any-input"));
    }

    public void testToXml() {
        NamePropertyTypeTest.assertEquals((String)"abc", (String)this.type.toXml((Module)this.design, (PropertyDefn)this.propDefn, (Object)"abc"));
    }

    public void testToString() {
        NamePropertyTypeTest.assertEquals((String)"abc", (String)this.type.toString((Module)this.design, (PropertyDefn)this.propDefn, (Object)"abc"));
    }

    public void testToDisplayString() {
        NamePropertyTypeTest.assertEquals((String)"abc", (String)this.type.toDisplayString((Module)this.design, (PropertyDefn)this.propDefn, (Object)"abc"));
    }

    public void testToNumber() {
        NamePropertyTypeTest.assertEquals((double)0.0, (double)this.type.toNumber((Module)this.design, (Object)"any-input").doubleValue(), (double)1.0);
    }

    public void testToBoolean() {
        NamePropertyTypeTest.assertEquals((boolean)false, (boolean)this.type.toBoolean((Module)this.design, (Object)"any-input"));
    }
}

