/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.NumberPropertyType;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;

public class NumberPropertyTypeTest
extends PropertyTypeTestCase {
    NumberPropertyType type = new NumberPropertyType();
    PropertyDefn propDefn = new PropertyDefnFake();

    public void testGetTypeCode() {
        NumberPropertyTypeTest.assertEquals((int)1, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        NumberPropertyTypeTest.assertEquals((String)"number", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, this.propDefn, null));
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateValue((Module)this.design, this.propDefn, (Object)""));
        Object input = new BigDecimal(1.0);
        NumberPropertyTypeTest.assertTrue((input == this.type.validateValue((Module)this.design, this.propDefn, input) ? 1 : 0) != 0);
        input = new Double(1.0);
        NumberPropertyTypeTest.assertEquals((double)1.0, (double)((BigDecimal)this.type.validateValue((Module)this.design, this.propDefn, input)).doubleValue(), (double)1.0);
        input = new Integer(1);
        NumberPropertyTypeTest.assertEquals((double)1.0, (double)((BigDecimal)this.type.validateValue((Module)this.design, this.propDefn, input)).doubleValue(), (double)1.0);
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        input = "1.0";
        NumberPropertyTypeTest.assertEquals((double)1.0, (double)((BigDecimal)this.type.validateValue((Module)this.design, this.propDefn, input)).doubleValue(), (double)1.0);
        try {
            input = "abc.abc";
            this.type.validateValue((Module)this.design, this.propDefn, input);
            NumberPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            NumberPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateInputString() throws PropertyValueException {
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, this.propDefn, null));
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateInputString((Module)this.design, this.propDefn, ""));
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        String input = "1.0";
        NumberPropertyTypeTest.assertEquals((double)1.0, (double)((BigDecimal)this.type.validateInputString((Module)this.design, this.propDefn, input)).doubleValue(), (double)1.0);
        input = "12,345.67";
        NumberPropertyTypeTest.assertEquals((double)12345.6, (double)((BigDecimal)this.type.validateInputString((Module)this.design, this.propDefn, input)).doubleValue(), (double)1.0);
        try {
            input = "abc.abc";
            this.type.validateInputString((Module)this.design, this.propDefn, input);
            NumberPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            NumberPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testValidateXml() throws PropertyValueException {
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, null));
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)""));
        String input = "1.0";
        NumberPropertyTypeTest.assertEquals((double)1.0, (double)((BigDecimal)this.type.validateXml((Module)this.design, this.propDefn, (Object)input)).doubleValue(), (double)1.0);
        input = " ";
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)input));
        input = null;
        NumberPropertyTypeTest.assertEquals(null, (Object)this.type.validateXml((Module)this.design, this.propDefn, (Object)input));
        NumberPropertyTypeTest.assertEquals((String)"1234567890123456789.123456789", (String)((BigDecimal)this.type.validateXml((Module)this.design, this.propDefn, (Object)"1234567890123456789.123456789")).toString());
        try {
            this.type.validateXml((Module)this.design, this.propDefn, (Object)"1,234");
            NumberPropertyTypeTest.fail();
        }
        catch (PropertyValueException e) {
            NumberPropertyTypeTest.assertEquals((String)"Error.PropertyValueException.INVALID_VALUE", (String)e.getErrorCode());
        }
    }

    public void testToDouble() {
        NumberPropertyTypeTest.assertEquals((double)1.0, (double)this.type.toDouble((Module)this.design, (Object)new BigDecimal(1.0)), (double)1.0);
    }

    public void testToInteger() {
        NumberPropertyTypeTest.assertEquals((int)1, (int)this.type.toInteger((Module)this.design, (Object)new BigDecimal(1.0)));
        NumberPropertyTypeTest.assertEquals((int)0, (int)this.type.toInteger((Module)this.design, null));
    }

    public void testToXml() {
        NumberPropertyTypeTest.assertEquals((String)"1234567.123", (String)this.type.toXml((Module)this.design, this.propDefn, (Object)new BigDecimal(1234567.123)));
    }

    public void testToString() {
        NumberPropertyTypeTest.assertEquals((String)"1234567.123", (String)this.type.toString((Module)this.design, this.propDefn, (Object)new BigDecimal(1234567.123)));
    }

    public void testToDisplayString() {
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
        NumberPropertyTypeTest.assertEquals((String)"1,234,567.123", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)new BigDecimal(1234567.123)));
    }

    public void testToNumber() {
        BigDecimal input = new BigDecimal(1.0);
        NumberPropertyTypeTest.assertEquals((Object)input, (Object)this.type.toNumber((Module)this.design, (Object)input));
    }

    public void testToBoolean() {
    }
}

