/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefnFake;
import org.eclipse.birt.report.model.metadata.PropertyTypeTestCase;
import org.eclipse.birt.report.model.metadata.StructPropertyType;

public class StructListPropertyTypeTest
extends PropertyTypeTestCase {
    StructPropertyType type = new StructPropertyType();
    ArrayList value = new ArrayList();
    PropertyDefn propDefn = new PropertyDefnFake();

    protected void setUp() throws Exception {
        super.setUp();
        MetadataTestUtil.setIsList((PropertyDefn)this.propDefn, (boolean)true);
        this.value.add("One");
        this.value.add("Two");
        this.value.add("Three");
    }

    public void testGetTypeCode() {
        StructListPropertyTypeTest.assertEquals((int)16, (int)this.type.getTypeCode());
    }

    public void testGetName() {
        StructListPropertyTypeTest.assertEquals((String)"structure", (String)this.type.getName());
    }

    public void testValidateValue() throws PropertyValueException {
        try {
            this.type.validateValue((Module)this.design, this.propDefn, (Object)"any-data");
            StructListPropertyTypeTest.fail();
        }
        catch (PropertyValueException propertyValueException) {}
    }

    public void testValidateInputString() throws PropertyValueException {
    }

    public void testValidateXml() throws PropertyValueException {
    }

    public void testToDouble() {
        StructListPropertyTypeTest.assertEquals((double)3.0, (double)this.type.toDouble((Module)this.design, (Object)this.value), (double)1.0);
    }

    public void testToInteger() {
        StructListPropertyTypeTest.assertEquals((int)3, (int)this.type.toInteger((Module)this.design, (Object)this.value));
    }

    public void testToXml() {
    }

    public void testToString() {
        StructListPropertyTypeTest.assertEquals((String)"[One, Two, Three]", (String)this.type.toString((Module)this.design, this.propDefn, (Object)this.value));
    }

    public void testToDisplayString() {
        StructListPropertyTypeTest.assertEquals((String)"[One, Two, Three]", (String)this.type.toDisplayString((Module)this.design, this.propDefn, (Object)this.value));
    }

    public void testToNumber() {
        StructListPropertyTypeTest.assertEquals((double)3.0, (double)this.type.toNumber((Module)this.design, (Object)this.value).doubleValue(), (double)1.0);
    }

    public void testToBoolean() {
    }
}

