/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class BidiParseTest
extends BaseTestCase {
    static final String IN_FILE_NAME = "BidiParseTest.xml";
    static final String IN_FILE_NAME_1 = "BidiParseTest_1.xml";
    static final String INVALID_FILE_NAME = "BidiParseTest_invalid.xml";
    static final String GOLDEN_FILE_NAME = "BidiParseTest_golden.xml";
    static final String GOLDEN_FILE_NAME_1 = "BidiParseTest_golden_1.xml";
    static final String ORIENTATION = "bidiLayoutOrientation";
    static final String DIRECTION = "bidiTextDirection";
    static final String LTR = "ltr";
    static final String RTL = "rtl";
    private static String[][] testStyleData;
    private static Object[][] testElementData;

    static {
        String[][] stringArrayArray = new String[4][];
        stringArrayArray[0] = new String[]{"Bidi-Style-LTR", LTR};
        stringArrayArray[1] = new String[]{"Bidi-Style-RTL", RTL};
        String[] stringArray = new String[2];
        stringArray[0] = "Empty-Style";
        stringArrayArray[2] = stringArray;
        stringArrayArray[3] = new String[]{"table-detail", RTL};
        testStyleData = stringArrayArray;
        testElementData = new Object[][]{{"testLabel", true, true}, {"testText", false, false}, {"testExtendedItem", true, false}, {"testTextData", true, true}, {"testGrid", true, true}, {"testGridLabel", true, true}, {"testGridLabelLTR", false, false}, {"testGridLabelRTL", true, false}, {"testTable", false, false}, {"testTableLabel", false, false}, {"testTableLabelLTR", false, false}, {"testTableLabelRTL", true, false}, {"testFooterLabel", false, false}, {"testFooterLabelRTL", true, false}, {"testList", true, false}, {"testListText", true, false}, {"testListTextLTR", false, false}, {"testListTextRTL", true, false}};
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(IN_FILE_NAME);
        int n = testStyleData.length;
        while (n-- > 0) {
            this.testStyleElementProperty(testStyleData[n][0], testStyleData[n][1]);
        }
        NameSpace ns = this.design.getNameHelper().getNameSpace(0);
        BidiParseTest.assertEquals((int)testStyleData.length, (int)ns.getCount());
        int n2 = testElementData.length;
        while (n2-- > 0) {
            this.testPropertyFromSelector((String)testElementData[n2][0], (boolean)((Boolean)testElementData[n2][1]), (boolean)((Boolean)testElementData[n2][2]));
        }
        BidiParseTest.assertEquals((Object)RTL, (Object)this.design.getProperty((Module)this.design, ORIENTATION));
        BidiParseTest.assertTrue((boolean)this.designHandle.isDirectionRTL());
    }

    public void testTable() throws Exception {
        this.openDesign(IN_FILE_NAME);
        TableItem table = (TableItem)this.design.findElement("testTable");
        this.testPropertyFromSelector((DesignElement)table, false, false, false, "Bidi-Style-LTR");
        DesignElement element = table.getSlot(2).getContent(0);
        this.testPropertyFromSelector(element, true, false, false, "table-detail");
        element = table.getSlot(0).getContent(0);
        this.testPropertyFromSelector(element, false, false, true, "Bidi-Style-LTR");
        element = table.getSlot(0).getContent(1);
        this.testPropertyFromSelector(element, true, false, false, "Bidi-Style-RTL");
        element = table.getSlot(3).getContent(0);
        this.testPropertyFromSelector(element, false, false, true, "Bidi-Style-LTR");
        element = table.getSlot(4).getContent(0);
        this.testPropertyFromSelector(element, false, false, true, "Bidi-Style-LTR");
        table.setStyle(null);
        this.testPropertyFromSelector(element, true, true, true, "table-detail");
        BidiParseTest.assertNull((Object)table.getFactoryProperty((Module)this.design, DIRECTION));
        table.setStyleName("Bidi-Style-RTL");
        this.testPropertyFromSelector(element, true, false, true, "Bidi-Style-RTL");
        BidiParseTest.assertNotNull((Object)table.getFactoryProperty((Module)this.design, DIRECTION));
        table.setStyleName("Bidi-Style-LTR");
        this.testPropertyFromSelector(element, false, false, true, "Bidi-Style-LTR");
    }

    private void testStyleElementProperty(String name, String value) {
        StyleElement style = this.design.findStyle(name);
        BidiParseTest.assertNotNull((Object)style);
        BidiParseTest.assertEquals((String)value, (String)style.getStringProperty((Module)this.design, DIRECTION));
    }

    private void testPropertyFromSelector(String name, boolean rtl, boolean inherited) {
        this.testPropertyFromSelector(this.designHandle.findElement(name), rtl, inherited);
    }

    private void testPropertyFromSelector(DesignElementHandle deh, boolean rtl, boolean inherited) {
        BidiParseTest.assertNotNull((Object)deh);
        BidiParseTest.assertNull((Object)deh.getStringProperty(ORIENTATION));
        BidiParseTest.assertEquals((boolean)deh.isDirectionRTL(), (boolean)rtl);
        BidiParseTest.assertEquals((deh.getStringProperty(DIRECTION) == null ? 1 : 0) != 0, (boolean)inherited);
    }

    private void testPropertyFromSelector(DesignElement element, boolean rtl, boolean inherited, boolean factoryPropIsNull, String styleName) {
        BidiParseTest.assertNotNull((Object)element);
        DesignElementHandle deh = element.getHandle((Module)this.design);
        BidiParseTest.assertNotNull((Object)deh);
        this.testPropertyFromSelector(deh, rtl, inherited);
        StyleElement style = this.design.findStyle(styleName);
        BidiParseTest.assertNotNull((Object)style);
        BidiParseTest.assertEquals((boolean)rtl, (boolean)RTL.equals(style.getStringProperty((Module)this.design, DIRECTION)));
        BidiParseTest.assertEquals((element.getFactoryProperty((Module)this.design, DIRECTION) == null ? 1 : 0) != 0, (boolean)factoryPropIsNull);
    }

    public void testWriter() throws Exception {
        this.openDesign(IN_FILE_NAME);
        DesignElementHandle handle = this.designHandle.findElement("testLabel");
        handle.setStyleName("Bidi-Style-LTR");
        handle = this.designHandle.findElement("testText");
        StyleHandle style = handle.getPrivateStyle();
        style.setTextDirection(RTL);
        this.design.setProperty(ORIENTATION, (Object)LTR);
        this.save();
        BidiParseTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE_NAME));
    }

    public void testReadHighlightRules() throws Exception {
        this.openDesign(IN_FILE_NAME_1);
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        BidiParseTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        BidiParseTest.assertNotNull((Object)highlightHandle);
        BidiParseTest.assertEquals((String)RTL, (String)highlightHandle.getTextDirection());
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        BidiParseTest.assertNotNull((Object)highlightHandle);
        BidiParseTest.assertNull((Object)highlightHandle.getTextDirection());
    }

    public void testWriteHighlightRules() throws Exception {
        this.openDesign(IN_FILE_NAME_1);
        SharedStyleHandle styleHandle = this.designHandle.findStyle("My-Style");
        Iterator highlightHandles = styleHandle.highlightRulesIterator();
        BidiParseTest.assertNotNull((Object)highlightHandles);
        HighlightRuleHandle highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        try {
            highlightHandle.setTextDirection("nochoice");
            BidiParseTest.fail();
        }
        catch (PropertyValueException e) {
            BidiParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        highlightHandle.setTextDirection(LTR);
        highlightHandle = (HighlightRuleHandle)highlightHandles.next();
        BidiParseTest.assertNotNull((Object)highlightHandle);
        highlightHandle.setTextDirection(RTL);
        BidiParseTest.assertEquals((String)RTL, (String)highlightHandle.getTextDirection());
        this.save();
        BidiParseTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE_NAME_1));
    }

    public void testSessionDefault() throws DesignFileException, PropertyValueException {
        this.openDesign(IN_FILE_NAME);
        DesignElementHandle grid = this.designHandle.findElement("testGrid");
        BidiParseTest.assertNotNull((Object)grid);
        this.design.getSession().setDefaultValue(DIRECTION, (Object)LTR);
        BidiParseTest.assertEquals((String)LTR, (String)grid.getStringProperty(DIRECTION));
        BidiParseTest.assertFalse((boolean)grid.isDirectionRTL());
        DesignElementHandle list = this.designHandle.findElement("testList");
        BidiParseTest.assertNotNull((Object)list);
        BidiParseTest.assertEquals((String)RTL, (String)list.getStringProperty(DIRECTION));
        BidiParseTest.assertTrue((boolean)list.isDirectionRTL());
        this.design.getSession().setDefaultValue(DIRECTION, null);
        BidiParseTest.assertTrue((boolean)grid.isDirectionRTL());
        BidiParseTest.assertNull((Object)grid.getStringProperty(DIRECTION));
        BidiParseTest.assertTrue((boolean)list.isDirectionRTL());
        BidiParseTest.assertEquals((String)RTL, (String)list.getStringProperty(DIRECTION));
    }

    public void testErrorValidation() throws Exception {
        this.openDesign(IN_FILE_NAME);
        DesignElementHandle text = this.designHandle.findElement("testText");
        BidiParseTest.assertNotNull((Object)text);
        BidiParseTest.assertNotNull((Object)this.designHandle.getProperty(ORIENTATION));
        Object oldValue = text.getProperty(DIRECTION);
        text.setProperty(DIRECTION, null);
        try {
            text.setProperty(DIRECTION, (Object)"ltr.");
            BidiParseTest.fail();
        }
        catch (SemanticException e) {
            BidiParseTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
            this.testPropertyFromSelector(text, true, true);
        }
        try {
            text.setProperty(DIRECTION, (Object)"rtl_");
            BidiParseTest.fail();
        }
        catch (SemanticException e) {
            BidiParseTest.assertEquals((String)"Error.PropertyValueException.CHOICE_NOT_FOUND", (String)e.getErrorCode());
            this.testPropertyFromSelector(text, true, true);
        }
        text.setProperty(DIRECTION, (Object)LTR.toUpperCase());
        this.testPropertyFromSelector(text, false, false);
        text.setProperty(DIRECTION, (Object)RTL.toUpperCase());
        this.testPropertyFromSelector(text, true, false);
        if (oldValue != null) {
            text.setProperty(DIRECTION, oldValue);
        }
        try {
            this.openDesign(INVALID_FILE_NAME);
            BidiParseTest.fail();
        }
        catch (DesignFileException designFileException) {
            return;
        }
        BidiParseTest.assertTrue((boolean)false);
    }

    public void testTOC() throws Exception {
        this.openDesign(IN_FILE_NAME);
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        this.testPropertyFromSelector((DesignElementHandle)label, false, true);
        this.designHandle.getBody().add((DesignElementHandle)label);
        this.testPropertyFromSelector((DesignElementHandle)label, this.designHandle.isDirectionRTL(), true);
        label.addTOC("label toc expression");
        TOCHandle tocHandle = label.getTOC();
        BidiParseTest.assertNull((Object)tocHandle.getTextDirection());
        CommandStack stack = this.designHandle.getCommandStack();
        stack.startTrans(null);
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("newTocStyle");
        style.setTextDirection(LTR);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        tocHandle.setStyleName(style.getName());
        stack.commit();
        BidiParseTest.assertEquals((String)style.getTextDirection(), (String)tocHandle.getTextDirection());
        stack.undo();
        BidiParseTest.assertNull((Object)tocHandle.getTextDirection());
        this.designHandle.getStyles().add((DesignElementHandle)style);
        tocHandle.setStyleName(style.getName());
        BidiParseTest.assertEquals((String)style.getTextDirection(), (String)tocHandle.getTextDirection());
        stack.undo();
        BidiParseTest.assertNull((Object)tocHandle.getTextDirection());
    }
}

