/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DataItemParseTest
extends BaseTestCase {
    String fileName = "DataItemParseTest.xml";
    String goldenFileName = "DataItemParseTest_golden.xml";
    private String semanticFile = "DataItemParseTest_1.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        DataItem data = (DataItem)this.design.findElement("My First Data");
        DataItemHandle dataHandle = (DataItemHandle)data.getHandle((Module)this.design);
        DataItemParseTest.assertTrue((boolean)dataHandle.allowExport());
        DataItemParseTest.assertEquals((String)"First data value", (String)dataHandle.getResultSetColumn());
        DataItemParseTest.assertNull((Object)dataHandle.getValueExpr());
        DataItemParseTest.assertEquals((String)"First data value", (String)dataHandle.getResultSetExpression());
        DataItemParseTest.assertEquals((String)"data help", (String)dataHandle.getHelpText());
        DataItemParseTest.assertEquals((String)"help", (String)dataHandle.getHelpTextKey());
        ActionHandle actionHandle = dataHandle.getActionHandle();
        DataItemParseTest.assertNotNull((Object)actionHandle);
        DataItemParseTest.assertEquals((String)"hyperlink", (String)actionHandle.getLinkType());
        DataItemParseTest.assertEquals((String)"http://localhost:8080/", (String)actionHandle.getURI());
        dataHandle = (DataItemHandle)this.designHandle.findElement("Body Data");
        DataItemParseTest.assertEquals((int)6, (int)dataHandle.getContainer().findContentSlot((DesignElementHandle)dataHandle));
        DataItemParseTest.assertEquals((String)"column1", (String)dataHandle.getResultSetColumn());
        DataItemParseTest.assertNull((Object)dataHandle.getValueExpr());
        DataItemParseTest.assertEquals((String)"column1 expr", (String)dataHandle.getResultSetExpression());
        DataItemParseTest.assertEquals((String)"data help", (String)dataHandle.getHelpText());
        DataItemParseTest.assertEquals((String)"help", (String)dataHandle.getHelpTextKey());
        actionHandle = dataHandle.getActionHandle();
        DataItemParseTest.assertNotNull((Object)actionHandle);
        DataItemParseTest.assertEquals((String)"hyperlink", (String)actionHandle.getLinkType());
        DataItemParseTest.assertEquals((String)"http://localhost:80/", (String)actionHandle.getURI());
        Iterator columnBindings = dataHandle.columnBindingsIterator();
        ComputedColumnHandle column = (ComputedColumnHandle)columnBindings.next();
        DataItemParseTest.assertEquals((String)"column1", (String)column.getName());
        DataItemParseTest.assertEquals((String)"column1 expr", (String)column.getExpression());
        DataItemParseTest.assertEquals((String)"Display data value", (String)column.getDisplayName());
        DataItemParseTest.assertEquals((String)"ResourceKey.DisplayName", (String)column.getDisplayNameID());
        DataItemParseTest.assertEquals((String)"localized test", (String)column.getDisplayText());
        DataItemParseTest.assertEquals((String)"integer", (String)column.getDataType());
        DataItemParseTest.assertEquals((String)"column1 aggre1", (String)column.getAggregateOn());
        DataItemParseTest.assertEquals((String)"column1 aggre1, column1 aggre2", (String)DataItemParseTest.serializeStringList(column.getAggregateOnList()));
        Iterator iter = column.argumentsIterator();
        AggregationArgumentHandle argument = (AggregationArgumentHandle)iter.next();
        DataItemParseTest.assertEquals((String)"arg_1", (String)argument.getName());
        DataItemParseTest.assertEquals((String)"argument_value", (String)argument.getValue());
        argument = (AggregationArgumentHandle)iter.next();
        DataItemParseTest.assertEquals((String)"arg_2", (String)argument.getName());
        DataItemParseTest.assertEquals((String)"argument_value", (String)argument.getValue());
        DataItemParseTest.assertEquals((String)"sum", (String)column.getAggregateFunction());
        DataItemParseTest.assertEquals((String)"colmn1 filter expr", (String)column.getFilterExpression());
        dataHandle = (DataItemHandle)this.designHandle.findElement("componentsData");
        DataItemParseTest.assertNull((Object)dataHandle.getValueExpr());
        DataItemParseTest.assertEquals((String)"Components data value", (String)dataHandle.getResultSetExpression());
        dataHandle = (DataItemHandle)this.designHandle.findElement("scratchpadData");
        DataItemParseTest.assertNull((Object)dataHandle.getValueExpr());
        DataItemParseTest.assertEquals((String)"Scratch pad data value", (String)dataHandle.getResultSetExpression());
        dataHandle = (DataItemHandle)this.designHandle.findElement("graphicmasterpageData");
        DataItemParseTest.assertNull((Object)dataHandle.getValueExpr());
        DataItemParseTest.assertEquals((String)"Graphic master page data value", (String)dataHandle.getResultSetExpression());
        dataHandle = (DataItemHandle)this.designHandle.findElement("Body Data1");
        columnBindings = dataHandle.columnBindingsIterator();
        column = (ComputedColumnHandle)columnBindings.next();
        DataItemParseTest.assertEquals((String)"column1", (String)column.getName());
        DataItemParseTest.assertEquals((String)"column1 expr", (String)column.getExpression());
        DataItemParseTest.assertEquals((String)"Display data value", (String)column.getDisplayName());
        DataItemParseTest.assertEquals((String)"integer", (String)column.getDataType());
        DataItemParseTest.assertEquals((String)"column1 aggre1", (String)column.getAggregateOn());
        DataItemParseTest.assertEquals((String)"column1 aggre1, column1 aggre2", (String)DataItemParseTest.serializeStringList(column.getAggregateOnList()));
        DataItemParseTest.assertFalse((boolean)dataHandle.allowExport());
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        DataItem data = (DataItem)this.design.findElement("My First Data");
        DataItemHandle dataHandle = (DataItemHandle)data.getHandle((Module)this.design);
        dataHandle.setHelpTextKey("New key");
        dataHandle.setHelpText("New help");
        ActionHandle action = dataHandle.getActionHandle();
        DataItemParseTest.assertNotNull((Object)action);
        dataHandle = (DataItemHandle)this.designHandle.findElement("Body Data");
        dataHandle.setHelpTextKey("New body help key");
        dataHandle.setHelpText("New body help");
        action = dataHandle.getActionHandle();
        DataItemParseTest.assertNotNull((Object)action);
        Iterator columnBindings = dataHandle.columnBindingsIterator();
        ComputedColumnHandle column = (ComputedColumnHandle)columnBindings.next();
        column.setDisplayName("New Display Name");
        column.setDisplayNameID("new display name id");
        column.setAggregateFunction("count");
        data = (DataItem)this.design.findElement("Body Data");
        columnBindings = dataHandle.columnBindingsIterator();
        column = (ComputedColumnHandle)columnBindings.next();
        AggregationArgumentHandle argumentHandle = (AggregationArgumentHandle)column.argumentsIterator().next();
        argumentHandle.setName("new_" + argumentHandle.getName());
        argumentHandle.setValue("new_" + argumentHandle.getValue());
        dataHandle = (DataItemHandle)this.designHandle.findElement("Body Data1");
        dataHandle.setAllowExport(true);
        this.save();
        DataItemParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.semanticFile);
        List list = this.designHandle.getErrorList();
        DataItemParseTest.assertEquals((int)1, (int)list.size());
        ErrorDetail error = (ErrorDetail)list.get(0);
        DataItemParseTest.assertEquals((String)"Error.SemanticError.MISSING_COLUMN_BINDING", (String)error.getErrorCode());
    }
}

