/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DerivedDataSetParseTest
extends BaseTestCase {
    private static final String fileName = "DerivedDataSetParseTest.xml";

    public void testProperties() throws Exception {
        this.createDesign();
        DerivedDataSetHandle setHandle = this.designHandle.getElementFactory().newDerivedDataSet(null, "test");
        this.designHandle.getDataSets().add((DesignElementHandle)setHandle);
        DerivedDataSetParseTest.assertNotNull((Object)setHandle.paramBindingsIterator());
        DerivedDataSetParseTest.assertNotNull((Object)setHandle.parametersIterator());
        DerivedDataSetParseTest.assertNull((Object)setHandle.getDataSourceName());
        try {
            setHandle.setDataSource("Test");
            DerivedDataSetParseTest.fail();
        }
        catch (PropertyNameException e) {
            DerivedDataSetParseTest.assertEquals((String)"Error.PropertyNameException.PROPERTY_NOT_VALID", (String)e.getErrorCode());
        }
    }

    public void testParser() throws Exception {
        this.openDesign(fileName);
        DerivedDataSetHandle derivedDataSetHandle = (DerivedDataSetHandle)this.designHandle.findDataSet("derivedDataSet");
        DerivedDataSetParseTest.assertEquals((String)"derived.extension", (String)derivedDataSetHandle.getExtensionID());
        DerivedDataSetParseTest.assertEquals((String)"query text for the derived data set", (String)derivedDataSetHandle.getQueryText());
        List dataSets = derivedDataSetHandle.getInputDataSets();
        DerivedDataSetParseTest.assertEquals((Object)this.designHandle.findDataSet("DataSet1"), dataSets.get(0));
        DerivedDataSetParseTest.assertEquals((Object)this.designHandle.findDataSet("DataSet2"), dataSets.get(1));
    }

    public void testWriter() throws Exception {
        this.openDesign(fileName);
        DerivedDataSetHandle derivedDataSetHandle = (DerivedDataSetHandle)this.designHandle.findDataSet("derivedDataSet");
        derivedDataSetHandle.setQueryText("updated " + derivedDataSetHandle.getQueryText());
        derivedDataSetHandle.removeInputDataSet("DataSet2");
        derivedDataSetHandle = this.designHandle.getElementFactory().newDerivedDataSet(null, "derived.extensionID.new");
        derivedDataSetHandle.addInputDataSets("DataSet3");
        derivedDataSetHandle.addInputDataSets("DataSet1");
        this.designHandle.getDataSets().add((DesignElementHandle)derivedDataSetHandle);
        this.save();
        DerivedDataSetParseTest.assertTrue((boolean)this.compareFile("DerivedDataSetParseTest_golden.xml"));
    }
}

