/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DynamicFilterParameterParseTest
extends BaseTestCase {
    private static final String inputFile = "DynamicFilterParameterParseTest.xml";

    public void testParse() throws Exception {
        this.openDesign(inputFile);
        DynamicFilterParameterHandle handle = (DynamicFilterParameterHandle)this.designHandle.findParameter("Param 1");
        DynamicFilterParameterParseTest.assertEquals((String)"testColumn", (String)handle.getColumn());
        DynamicFilterParameterParseTest.assertEquals((String)"advanced", (String)handle.getDisplayType());
        DynamicFilterParameterParseTest.assertEquals((int)3, (int)handle.getListlimit());
        List list = handle.getFilterOperatorList();
        DynamicFilterParameterParseTest.assertEquals((int)2, (int)list.size());
        DynamicFilterParameterParseTest.assertEquals((String)"value1", (String)((String)list.get(0)));
        DynamicFilterParameterParseTest.assertEquals((String)"value2", (String)((String)list.get(1)));
    }

    public void testWrite() throws Exception {
        this.openDesign(inputFile);
        DynamicFilterParameterHandle handle = (DynamicFilterParameterHandle)this.designHandle.findParameter("Param 1");
        DynamicFilterParameterParseTest.assertEquals((String)"Param 1", (String)handle.getName());
        handle.setColumn("newColumn");
        handle.setDisplayType("simple");
        handle.setListlimit(5);
        ArrayList<String> list = new ArrayList<String>();
        list.add("test1");
        list.add("test2");
        handle.setFilterOperator(list);
        this.save();
        DynamicFilterParameterParseTest.assertTrue((boolean)this.compareFile("DynamicFilterParameterParseTest_golden.xml"));
    }
}

