/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class FilterAndSortParseTest
extends BaseTestCase {
    private static final String FILE_NAME = "FilterAndSortParseTest.xml";

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        FilterAndSortParseTest.assertNotNull((Object)testTable);
        List valueList = testTable.getListProperty("filter");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        FilterAndSortParseTest.assertEquals((String)"lt", (String)filter.getOperator());
        FilterAndSortParseTest.assertTrue((boolean)filter.isOptional());
        FilterAndSortParseTest.assertEquals((String)"filter expression", (String)filter.getExpr());
        FilterAndSortParseTest.assertEquals((String)"value1 expression", (String)filter.getValue1());
        FilterAndSortParseTest.assertEquals((String)"value2 expression", (String)filter.getValue2());
        FilterAndSortParseTest.assertEquals((String)"ResultSet", (String)filter.getFilterTarget());
        FilterAndSortParseTest.assertEquals((String)"ext name", (String)filter.getExtensionName());
        FilterAndSortParseTest.assertEquals((String)"ext id", (String)filter.getExtensionExprId());
        FilterAndSortParseTest.assertTrue((boolean)filter.pushDown());
        FilterAndSortParseTest.assertEquals((String)"DynamicFilterParam", (String)filter.getDynamicFilterParameter());
        MemberValueHandle memberValue = filter.getMember();
        FilterAndSortParseTest.assertEquals((String)"value_1", (String)memberValue.getValue());
        FilterAndSortParseTest.assertEquals((String)"testDimension/testLevel", (String)memberValue.getCubeLevelName());
        FilterAndSortParseTest.assertNotNull((Object)memberValue.getLevel());
        memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        FilterAndSortParseTest.assertEquals((String)"value_2", (String)memberValue.getValue());
        FilterAndSortParseTest.assertNull((Object)memberValue.getLevel());
        FilterAndSortParseTest.assertNull((Object)memberValue.getCubeLevelName());
        valueList = testTable.getListProperty("sorts");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        SortElementHandle sort = (SortElementHandle)valueList.get(0);
        FilterAndSortParseTest.assertEquals((String)"key_1", (String)sort.getKey());
        FilterAndSortParseTest.assertEquals((String)"desc", (String)sort.getDirection());
        memberValue = sort.getMember();
        FilterAndSortParseTest.assertEquals((String)"value_1", (String)memberValue.getValue());
        FilterAndSortParseTest.assertEquals((String)"testDimension/testLevel", (String)memberValue.getCubeLevelName());
        FilterAndSortParseTest.assertNotNull((Object)memberValue.getLevel());
        memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        FilterAndSortParseTest.assertEquals((String)"value_2", (String)memberValue.getValue());
        FilterAndSortParseTest.assertNull((Object)memberValue.getLevel());
        FilterAndSortParseTest.assertNull((Object)memberValue.getCubeLevelName());
        TableHandle table = (TableHandle)this.designHandle.findElement("Test table");
        FilterAndSortParseTest.assertNotNull((Object)table);
        FilterConditionHandle filterHandle = (FilterConditionHandle)table.filtersIterator().next();
        FilterAndSortParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        FilterAndSortParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        FilterAndSortParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        FilterAndSortParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        FilterAndSortParseTest.assertEquals((String)"ext name", (String)filterHandle.getExtensionName());
        FilterAndSortParseTest.assertEquals((String)"ext id", (String)filterHandle.getExtensionExprId());
        FilterAndSortParseTest.assertTrue((boolean)filterHandle.pushDown());
        FilterAndSortParseTest.assertEquals((String)"DynamicFilterParam", (String)filterHandle.getDynamicFilterParameter());
    }

    public void testWriter() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        FilterAndSortParseTest.assertNotNull((Object)testTable);
        List valueList = testTable.getListProperty("filter");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        filter.setOperator("ge");
        filter.setOptional(false);
        filter.setExpr("new " + filter.getExpr());
        filter.setValue1("new " + filter.getValue1());
        filter.setValue2("new " + filter.getValue2());
        filter.setFilterTarget("DataSet");
        filter.setExtensionExprId("new " + filter.getExtensionExprId());
        filter.setExtensionName("new " + filter.getExtensionName());
        filter.setPushDown(false);
        filter.setDynamicFilterParameter("new " + filter.getDynamicFilterParameter());
        MemberValueHandle memberValue = filter.getMember();
        memberValue.setValue("new " + memberValue.getValue());
        memberValue.setLevel(this.designHandle.findLevel("testDimension/testLevel_one"));
        valueList = testTable.getListProperty("sorts");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        SortElementHandle sort = (SortElementHandle)valueList.get(0);
        sort.setKey("new " + sort.getKey());
        sort.setDirection("asc");
        memberValue = sort.getMember();
        memberValue.setValue("new " + memberValue.getValue());
        memberValue.setLevel(this.designHandle.findLevel("testDimension/testLevel_one"));
        TableHandle table = (TableHandle)this.designHandle.findElement("Test table");
        FilterAndSortParseTest.assertNotNull((Object)table);
        Iterator iter1 = table.filtersIterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)iter1.next();
        filterHandle.setOperator("gt");
        filterHandle.setExpr("new " + filterHandle.getExpr());
        filterHandle.setValue1("new " + filterHandle.getValue1());
        filterHandle.setExtensionExprId("new " + filterHandle.getExtensionExprId());
        filterHandle.setExtensionName("new " + filterHandle.getExtensionName());
        filterHandle.setPushDown(false);
        filterHandle.setDynamicFilterParameter("new " + filterHandle.getDynamicFilterParameter());
        filterHandle = (FilterConditionHandle)iter1.next();
        ArrayList<Expression> tmpList = new ArrayList<Expression>();
        tmpList.add(new Expression((Object)"constant1", "constant"));
        filterHandle.setValue1(tmpList);
        this.save();
        FilterAndSortParseTest.assertTrue((boolean)this.compareFile("FilterAndSortParseTest_golden.xml"));
    }
}

